// ***********************************************************************************************
// *												 *																																			*
// *                                     Software License Agreement				 *											*
// *												 *																																			*
// * The software supplied herewith by Microchip Technology Incorporated (the "Company") for its *
// * PICmicro Microcontrller is intended and supplied to you, the Companys customer, for use  *
// * solely and exclusively on Microchip PICmicro Microcontroller products.			 *								*
// * The software is owned by the Company and/or its supplier, and is protected under applicable *
// * copyright laws. All rights are reserved. Any use in violation of the foregoing restrictions *
// * may subject the user to criminal sanctions under applicable laws, as well as to civil       *
// * liability for the breach of the terms and conditions of this license.                       *
// *												 *																																			*
// * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, WHETHER EXPRESS, IMPLIED  *
// * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND      *
// * FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, IN ANY      *
// * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON   *
// * WHATSOEVER.										 *																															*
// *												 *																																			*
// ***********************************************************************************************

// ***********************************************************************************************
//                                                                     				 *
//                                                                     				 *
// ***********************************************************************************************
//	filename:		LINbasic.c
//				LIN ( Local Interconnect Network ) SpecRev 1.2,1.3 & 2.0
//
// ************************************************************************************************
//
//    	Author:			Thorsten Waclawczyk 
//    	Company:		Microchip Technology GmbH
//
//	Revision:		1.2
//
//	Date:			15/06/2005
//
//	Compiler used		HITECH C18  OR MCHIP MCC18
//									MPLAB 7.11.00
//
// ************************************************************************************************
//
//	include files:
//
// ************************************************************************************************
//
// ************************************************************************************************
//
//	what's changed
//
/*	09/09/04	add enhanced checksum for LIN 2.0 and selection of reserved identifiers using the  	*/
/*						the classic checksum generation																											*/
/*                                                                                                */
/*  09/01/06  modify code to be able to support also PIC16 derivates                              */
/*                timeout calculation 																														*/
/* ************************************************************************************************/

#include "lin_cfg.h"

#include "controller.h"
#include "LIN_appl.h"					// LIN specific header file describing the system

#define _LIN_BASIC_CFG
#include "LINbasic.h"						// driver specific defines

/* ************************************************************************************************ */
/* ************************************************************************************************ */

#define ID_MasterReqFrame	0x3C
#define ID_SlaveRespFrame	0x3D
#define ID_UserDefFrame		0x3E
#define ID_futureResFrame	0x3F

#define BAUDCON BAUDCTL

/* ************************************************************************************************ */
/* protocol error flags  																																						*/
/* ************************************************************************************************ */

union
{
	l_u8	byte;
	struct
	{
		l_u8 FNORESPONSE			:1;		/* no echo on bus	*/
		l_u8 FIDPARITYERROR		:1;		/* parity over ID not correct  */
		l_u8 FCRCERROR				:1;		/* CRC isn't correct  */
		l_u8 FBITERROR				:1;		/* an outgoing bit value is  */
		l_u8 FINCOMPLETE			:1;
		l_u8 FAUTOBAUD				:1;
		l_u8 FINTENTRY			  :1;
		l_u8 FTIMEOUT					:1;		/* no communication on receive / transmit  */
	}bits;
}errorflags_u;

#define _FIDPARITYERROR 1				/* used for inline assembler */

/* ************************************************************************************************ */
/* linbus communication bits 																																				*/
/* ************************************************************************************************ */

union
{
	l_u8 byte;
	
	struct
	{
		l_u8  						:5;
	 	l_u8 FPENDING 		:1;
	 	l_u8 FCOMPLETE 		:1;		/* communication completed  */
	 	l_u8 FSLEEPMODE		:1;		/* sleep-mode frame  */
	}bits;
}comflags_u;

/* ************************************************************************************************ */
/* defines of task states available for LINprotocol																									*/
/* ************************************************************************************************ */

#define	SYNCHBREAKMODE	0		/* startup from scratch	*/
#define	XMITMODE				1		/* data has to be send on the bus	*/
#define	RECEIVEMODE			2		/* data has to be read from the bus	*/
#define	SYNCHBYTEMODE		3		/* frameerror has occured before, check if next is synch byte	*/
#define	IDENTIFIERMODE	4		/* synchbyte has detected, next should the identifier	*/
#define SLEEPMODE				5		/* wait until next rising edge, TMR0 must interrupt earlier	*/
#define IDLEMODE				6		/* no activity during the last couple of seconds	*/
#define AUTODETECTMODE	7		/* used for manual autobaud detection as workaround	*/
														/* for non functional ABD on RLT design */

// ************************************************************************************************
//
//
// ************************************************************************************************

static volatile l_u8 combuffer_b;
static volatile l_u8 comstatus_b;
static volatile l_u8 datacrc_b;						// checksum over xmit / rcsv block
static volatile l_u8 localbuffer_b[8];
static volatile l_u8 * localptr_b;
static volatile l_u8 localcntr_b;
static volatile l_u8 handle_b;	
static volatile l_u8 linmode_b;
static volatile l_u8 * bufferptr_b;
static volatile l_u8 datablocklength_b;		// numbers of send/receive block
volatile l_u8 idnumber_b;										/* carries the ID_number */	

/* containing the */
static volatile l_u8 lastid_b;
static volatile l_u8 LIN_Error;									/* protocols communication errors */
static l_u8 cpSPBRGH;


#ifdef _MCHIPC18

/* used to store temporary the rom pointer registes */
static volatile l_u8 cpTBLPTRL;
static volatile l_u8 cpTBLPTRH;
static volatile l_u8 cpTBLPTRU;
static volatile l_u8 cpTABLAT;
static volatile l_u16 cp__tmp_0;
#endif

/* structure contain information about last transmission */

_u_ifc_status ifc_status;

/* helpful structures to reduce the __tmp */

static u_wb wordbyte;
static u_wb help;

/* necessary until old 150k process based devices in the field to */
/* support the autobaud feature in correct matter */

#ifdef _MANUAL_AUTODETECT
static u_wb cpSnap_1;
static u_wb cpSnap_2;
static l_u8 edgecnt_b;
#endif

//l_u8 PRODL,PRODH;


  const l_u8 LinPidList[64] = { 0x80,0xC1,0x42,0x03,0xC4,0x85,0x06,0x47,\
                        0x08,0x49,0xCA,0x8B,0x4C,0x0D,0x8E,0xCF,\
                        0x50,0x11,0x92,0xD3,0x14,0x55,0xD6,0x97,\
                        0xD8,0x99,0x1A,0x5B,0x9C,0xDD,0x5E,0x1F,\
                        0x20,0x61,0xE2,0xA3,0x64,0x25,0xA6,0xE7,\
                        0xA8,0xE9,0x6A,0x2B,0xEC,0xAD,0x2E,0x6F,\
                        0xF0,0xB1,0x32,0x73,0xB4,0xF5,0x76,0x37,\
                        0x78,0x39,0xBA,0xFB,0x3C,0x7D,0xFE,0xBF};

// ************************************************************************************************
//
//
// ************************************************************************************************
	
extern l_u8 l_ifc_pid_to_handle(void);
void SetupTimeoutIDLE(void);
void InitEUSART(void);

// ************************************************************************************************
//
//
// ************************************************************************************************

void Handle(void)
{
	
	idnumber_b = combuffer_b;			/* store orign PID */

	handle_b = l_ifc_pid_to_handle();

//	idnumber_b &= 0x3F;					/* generate raw ID */
	if (handle_b > 0)							/* check if handle is not a NUL handle */
	{

		_STORETBLPTR();								/* save ROMptr before using */
																/* doing this here instead of "save section" */
																/* saves time of 8 instr each int occures */

		linmode_b = l_HandleList[handle_b].l_target_mode;
		bufferptr_b = l_HandleList[handle_b].l_target_addr;
		datablocklength_b = l_HandleList[handle_b].l_target_len;
		datablocklength_b = datablocklength_b + 1;

#ifdef _LIN_REV20

/*
	related to LIN protocol spec,chapter 2.1.5 the identifiers 60 to 63 shall
	always use the classic checksum generation
	classic checksum -> inverted modulo 256 over the response data
	enhanced checksum -> inverted modulo 256 over the response data AND protected identifier
*/
		help.b.lo = idnumber_b;
		help.b.lo &= 0x3F;	

		if (help.b.lo < ID_MasterReqFrame)
		{
			datacrc_b = combuffer_b;
		}
		else
		{		
			datacrc_b = 0;
		}

#else

		{		
			datacrc_b = 0;								/* use classic checksum */
		}

#endif

/*
 calculate the max response time  
 		count_response_bits * 1,4 * Tbit = count_of_bytes * 14 * Tbit
 		count_of_bytes = datablocklength_b, Tbit = SPBRGH:SPBRG
*/

#ifdef _USETIMEOUT

  	wordbyte.w = CalcTimeout(datablocklength_b,0x208);

		wordbyte.w = datablocklength_b;		/* datablocklength max 9 byte * 14 = 126 */
		wordbyte.b.lo *= 14L;							/* 14L represents 10Tbit * 1.4 */
		help.w = l_rd_Baudrate();			/* get bitrate and calculate the response time */
		wordbyte.w *= help.w;

		DisableTMR(0);		// stop timer for calculation

/*
	 calculate the rest of available frame time = max_response_time + rest_of_max_header_time
		rest_of_max_header = TMR0, reminder: TMR0 count from 0 .. 0xFFFF 
		max_response_time = TMR0 - (l_u16)((l_u8)(14 * (bytecount+1))*	(SPBRG+1));
*/	 
		help.b.lo = TMR0L;
		help.b.hi = TMR0H; //help.w = l_rd_TMR(0);
		wordbyte.w = help.w - wordbyte.w;
//		l_wr_TMR(0,wordbyte.w);


		TMR0H = wordbyte.b.hi; //0x22;
		TMR0L = wordbyte.b.lo; //0xD8;
//		TMR0IF = 0;

		EnableTMR(0);

#endif			

		_RESTORETBLPTR();														/* restore the ROMptr */
		
	}
	else
	{
		SetupTimeoutIDLE();
	}	
}

// ************************************************************************************************
//
//
// ************************************************************************************************

void TransferCompleted(void)
{	
	static l_u8 offset,bytepos,mask;
	
	bytepos = handle_b >> 3;
	offset = handle_b - ( handle_b & 0xF8);
	mask = (l_u8)(1) << offset;

#ifndef _MASTERNODE
	if (linmode_b == RECEIVEMODE)
#else	
	if (linmode_b == XMITMODE)
#endif
	{

/* if frame related data have been received successful set corresponding bit */

		FrameCtrlFlags._c[bytepos] |= mask;
	}
	else
	{
/* if frame related data have been transmitted successful clear corresponding bit */

		mask = mask ^ 0xFF;
		FrameCtrlFlags._c[bytepos] &= mask;
	}

/* identify the last frame handled on the bus and make the successful communication visible */

	lastid_b = idnumber_b;					
	comflags_u.bits.FCOMPLETE = 1;
}

// ************************************************************************************************
//
//
// ************************************************************************************************

void SetupTimeoutIDLE(void)
{	
#ifdef _USETIMEOUT	
	T0CON = (kTMR0_PRESCALE_IDLE | k16BITMODE);
	l_wr_TMR(0,BUSidle_TTIMEOUT)
	TMR0IF = 0;
	TMR0ON = 1;	
#endif	

#ifdef _TX_ONREQUEST	
	DisableTransmitter();
#endif

	LIN_Error = errorflags_u.byte;
	errorflags_u.byte = 0;
	comflags_u.bits.FPENDING = 0;			
	linmode_b = SYNCHBREAKMODE;

}

// ************************************************************************************************
//
//
// ************************************************************************************************

void l_ifc_rx_MyLinIfc(void)
{

	_STORETEMPREGS();

// ************************************************************************************************
//	 this is only used to correct the issue in most of EUSART modules that before 
//	 starting the autobaud detection the RX must be recessive 
// ************************************************************************************************

#ifdef _USEEXTINT
	if (CheckINT())
	{
		if (linmode_b == SYNCHBREAKMODE)
		{
//			if (0 == rd_bool_RXpin())
//			{
//				errorflags_u.bits.FAUTOBAUD = 1;
//				SetupTimeoutIDLE();			
//			}
//			else
			{
#ifdef _MANUAL_AUTODETECT
				linmode_b = AUTODETECTMODE;
//				INTEDG0 = 0;
				INTEDG = 0;
				edgecnt_b = 0;
#else
				linmode_b = SYNCHBYTEMODE;
#endif

#ifdef _AUTOBAUD
			ABDEN = 1;
#endif
			}
#ifndef _MANUAL_AUTODETECT
			DisableINT();
#endif
		}
#ifdef _MANUAL_AUTODETECT		
		else
		if (linmode_b == AUTODETECTMODE)
		{
			if (edgecnt_b == 0)						/* detected first falling edge */
			{
#ifdef _USETIMEOUT
				cpSnap_1.b.lo = TMR0L;			/* make snapshot from actual timer value */
				cpSnap_1.b.hi = TMR0H;
#endif				
			}
			else
			if (edgecnt_b == 4)						/* detected last falling edge */
			{
				
//				INTEDG0 = 1;
				INTEDG = 1;
				DisableINT();								/* disable ext interrupt */
				
				ABDEN = 0;

#ifdef _USETIMEOUT				
				cpSnap_2.b.lo = TMR0L;			/* make second snapshot from actual timer value */
				cpSnap_2.b.hi = TMR0H;
					
				wordbyte.w = cpSnap_2.w - cpSnap_1.w;	
				
				wordbyte.w -= 9;
				wordbyte.w >>= 3;						/* calculate the timer value counted over 8bits */
																		/* and devide it by 8 for baudrate preload */				

				SPBRG = wordbyte.b.lo;
				SPBRGH = wordbyte.b.hi;
				
				linmode_b = SYNCHBYTEMODE;
				goto label_dummy;
#endif				
			}
			edgecnt_b++;				
		}
#endif		
		else
		{
			errorflags_u.bits.FINTENTRY = 1;
			SetupTimeoutIDLE();						
		}
		ClearINT();
	}
#endif

// ************************************************************************************************
//	if master use the TXIF to detect if the synchbreak is ready
// ************************************************************************************************

#ifdef _MASTERNODE

	if ((TXIF) && (linmode_b == SYNCHBREAKMODE))
	{
		TXIE = 0;
		RCIE = 1;
	}
	
#endif

// ************************************************************************************************
// Check Timeout behavior during LIN protocol handling 
// ************************************************************************************************

#ifdef _USETIMEOUT
	if	((TMR0IE) && (TMR0IF))
	{
		if (linmode_b != SYNCHBREAKMODE)
		{
			if (localcntr_b > 0)
			{
				if (localcntr_b != datablocklength_b)
				{
					errorflags_u.bits.FINCOMPLETE = 1;
				}
				errorflags_u.bits.FNORESPONSE = 1;
			}
		}
//		PORTCbits.RC5 = 0;
		errorflags_u.bits.FTIMEOUT = 1;
		SetupTimeoutIDLE();
	}
#endif

// ************************************************************************************************
//	do the LINprotocol handling based ony on reception interupt
// ************************************************************************************************
	
	if (RCIF)															// check if something has been received
	{	

		comstatus_b = RCSTA;
		combuffer_b = RCREG;
		
// ************************************************************************************************
//	check if overrun then reinitialize the receiver engine
// ************************************************************************************************

		if (comstatus_b & 2)
		{
			CREN = 0;
			CREN = 1;
		}

// ************************************************************************************************
// check if frameerror occured AND received value is 0, this addresses the possible SynchBreak
// at this point calculate the rest of maximum available header time and if required enable
// external interrupt with rising edge detection for end of SynchBreak check.
// 
// ************************************************************************************************
		
		if (comstatus_b & 4)														// check if synch break
		{

			if ((0 == combuffer_b))						// has been a zero received ?
			{
#ifndef _MASTERNODE
	comflags_u.bits.FPENDING = 1;
#endif
        linmode_b = SYNCHBREAKMODE;
				errorflags_u.byte = 0x0;

// ************************************************************************************************
//
//	calculate the maximum allowed header time - >recieved 10bits , min_header_bits = 34
//  min_bits = min_header_bits - 10 = 24
//	max_bits = (min_bits + 1)*1,4 -> 25*1,4 = 35 -> 0x23
//
//	marks: use word/byte union to reduce codesize
//
// ************************************************************************************************

				
#ifdef _USETIMEOUT

				T0CON = (kTMR0_PRESCALE_ACTIVE | k16BITMODE);
				TMR0ON = 0;

	#ifdef _AUTOBAUD
				wordbyte.w = l_rd_Baudrate(); //wordbyte.b.hi = SPBRGH;
																			//wordbyte.b.lo = SPBRG;
				wordbyte.w *= 0x23;
				
				l_wr_TMR(0,~wordbyte.w);
	#else
		l_wr_TMR(0,kMAX_HEADER_TIMEOUT_SLAVE);

	#endif				
				TMR0IF = 0;
				TMR0ON = 1;												// and activate the timer
#endif

#ifdef _USEEXTINT

				EnableINT();											// 
#else
				linmode_b = SYNCHBYTEMODE;			
//        while(!RC5);
//        WUE = 1;
  			ABDEN = 1;

#endif


#ifdef _MASTERNODE
				TXREG = 0x55;
#endif
			}
		}																			// end of frame error check

// ************************************************************************************************
//
//
// ************************************************************************************************

		else																	// no frame error -> deal with standard LIN protocol
		{

#ifdef _MANUAL_AUTODETECT
			if ( AUTODETECTMODE == linmode_b)
			{
				linmode_b = SYNCHBYTEMODE;
			}
#endif

			if ( RECEIVEMODE == linmode_b)								// = 2 data has to be read from the bus
			{                

				datacrc_b +=  combuffer_b;
				if (CARRY)
					datacrc_b++;

				*localptr_b++ = combuffer_b;								// store received data into local buffer
				localcntr_b--;	

				if (0 == localcntr_b)												// received byte should be the checksum
				{
					if (0 != (++datacrc_b))
					{
						errorflags_u.bits.FCRCERROR = 1;
					}				

					if (!( errorflags_u.byte & 0x7F))					// copy data to destination if no errors
					{
						localptr_b = &localbuffer_b[0];
						while ((--datablocklength_b))
						{
							*bufferptr_b++ = *localptr_b++;
						};
						
						TransferCompleted();
					}
					SetupTimeoutIDLE();						
				}
			}
			
// *****************************************************************************************************

			else

			if ( XMITMODE == linmode_b)									// = 1 data has to be send on the bus
			{
				if (TXREG != combuffer_b)
				{
					errorflags_u.bits.FBITERROR = 1;
      	}

				wordbyte.b.lo = errorflags_u.byte & 0x7F; 
				
				if (0 == wordbyte.b.lo)										// check if errors occured
			  {
			  	if (0 == datablocklength_b)							// no errors, response completed
					{
						TransferCompleted();
						SetupTimeoutIDLE();
					}
					else																/* at least one bit left for transmission */
					{
						ReInitTransmitter();							/* allow transmission */						
				  	if (0 ==(--datablocklength_b))		/* next byte is the last one = Checksum */
						{
							TXREG = ~datacrc_b;							/* copy inverted value of Checksum */
						}
						else
						{
							TXREG = *bufferptr_b++;					// otherwise pickup the next data
							datacrc_b += TXREG;							// add value to checksum
							if (CARRY)											// and check MOD256
								datacrc_b++;
						}
					}
				}
				else
				{
					SetupTimeoutIDLE();									// initial the Idle timeout counter
				}
			}

// *****************************************************************************************************

			else
			if ( SYNCHBYTEMODE == linmode_b)						// ABaud has been finalized
			{
label_dummy:
#ifdef	_AUTOBAUD

				CREN = 1;																	/* reenable the USART */

				wordbyte.b.hi = SPBRGH;
				wordbyte.b.lo = SPBRG;
				wordbyte.w--;
				SPBRGH = wordbyte.b.hi;
				SPBRG = wordbyte.b.lo;

								
				if ( (wordbyte.w > kMaxSPBRG) || (wordbyte.w < kMinSPBRG))
#else

				if (0x55 != combuffer_b)
#endif				
				{
					errorflags_u.bits.FAUTOBAUD = 1;
					SPBRGH = (l_u8)(BdratePreload >> 8);
					SPBRG = (l_u8)(BdratePreload);

					SetupTimeoutIDLE();											// ignore rest of response if not synchbyte
				
				}
				else
				{
					linmode_b = IDENTIFIERMODE;							// if inside +/- 15% then wait for identifier

#ifdef _MASTERNODE
					TXREG = idnumber_b;					
#endif					
				}
			}

// *****************************************************************************************************

			else
			if ( IDENTIFIERMODE == linmode_b)						/* received byte should be the identifier */
			{

//				if (CheckParity(combuffer_b))							/* there was a parity failure in PID */
				if (LinPidList[(combuffer_b & 0x3F)] != combuffer_b)																/* there was a parity failure in PID */
 				{
					errorflags_u.bits.FBITERROR = 1;				/* it was a bit failure */
					errorflags_u.bits.FIDPARITYERROR = 1;		/* as well as aparity */
				}

				if (0 == ( errorflags_u.byte & 0x7F))			/* if no error occured before */
				{
					Handle();																/* setup driver based on req identifier */

					localptr_b = &localbuffer_b[0];
					localcntr_b = datablocklength_b;

					if (XMITMODE == linmode_b)							/* slave should respond */
					{
						EnableTransmitter();									/* workaround: eliminate sporadic 0x00 transmission */
															
            TXREG = *bufferptr_b;                 /* and send next value */
            bufferptr_b++;
           	datablocklength_b--;
						datacrc_b += TXREG;										/* update checksum */
						if (CARRY)														/* and check MOD256 */
						{
							datacrc_b++;
						}
					}
					else if (SYNCHBREAKMODE == linmode_b)		/* identifier is not implemented */
					{
						SetupTimeoutIDLE();										/* ignore rest of response */
					}	
				}
				else
				{
					SetupTimeoutIDLE();
				}
			}
				
// *****************************************************************************************************

			else
			if ( SLEEPMODE == linmode_b)
			{
#ifdef _AUTOBAUD
				while(WUE);
#endif		

				if ((combuffer_b > 0xEF) && (combuffer_b < 0xFD))
				{
					SPEN = 0;											// disable the USART port
					InitEUSART();
					SetupTimeoutIDLE();	
				}
			}

// *****************************************************************************************************
							
			else
			{
				SetupTimeoutIDLE();
			}
		}
	}


	_RESTORETEMPREGS();
}

// *****************************************************************************************************
// *****************************************************************************************************

void InitEUSART(void)
{
	
	l_wr_Baudrate(BdratePreload);

#ifdef _USE_BRGH
	TXSTA = 0x04;								// workaround errata DS80180B,page3,sect13
#else
	TXSTA = 0;
#endif	

	SetupPort();
	SetupUART();
	
	combuffer_b = RCREG;				// empty the buffer
	combuffer_b = RCREG;

	SetRcvInt();
	SetRcvPrio(DriverPriority);			// set configured priority

#ifdef _MASTERNODE
	TXIE = 0;
	ClrRcvInt();
	TXIP = DriverPriority;			// set configured priority
#endif
}

// *****************************************************************************************************
// *****************************************************************************************************

void l_ifc_init_MyLinIfc(void)
{

	datablocklength_b=0;				/* numbers of send/receive block */
	localptr_b = localbuffer_b;
	bufferptr_b=localbuffer_b;

	comflags_u.byte = 0;
	ifc_status.w = 0;
	LIN_Error = 0;
	lastid_b = 0xFF;							/* indicate a fault start pid */

	linmode_b = SYNCHBREAKMODE;

#ifdef _USE_EAUSART
	BAUDCON = 0x00;						// workaround errata DS80180B,page3,sect15
#endif
	
/* */

	SetTmrPrio(0,DriverPriority);		// set configured priority on timeout
	ClrTmrFlag(0);

#ifdef _USETIMEOUT	
	SetTmrInt(0); //TMR0IE = 1;
#endif

#ifdef _USEEXTINT
	SetExtInt();
#endif
	
	for(localcntr_b = 0;localcntr_b < sizeof(FrameCtrlFlags);localcntr_b++)
	{
		FrameCtrlFlags._c[localcntr_b] = 0;
	}
	
	SetupTimeoutIDLE();
	DisableTMR(0);
	InitEUSART();
}

// *****************************************************************************************************
// *****************************************************************************************************

void l_ifc_wake_up_MyLinIfc(void)
{
	linmode_b = SLEEPMODE;
	EnableTransmitter();
	TXREG = 0xF0;
}

// *****************************************************************************************************
// *****************************************************************************************************
	
void l_ifc_goto_sleep_req_MyLinIfc(void)
{
	DisableTMR(0);
//	comflags_u.bits.FSLEEPMODE = 1;
  ifc_status.b.Goto_sleep = 1;
	linmode_b = SLEEPMODE;


#ifdef _AUTOBAUD	
//	WUE = 1;
#endif

}	

// *****************************************************************************************************
// *****************************************************************************************************

#ifdef _MASTERNODE

l_u8 l_ifc_StartMaster(l_u8 pid)
{
	if (0 == comflags_u.bits.FPENDING)
	{
		RCIE = 0;													// disable receive int until synch break is over
	
	#ifdef _USETIMEOUT
	
		T0CON = (kTMR0_PRESCALE_ACTIVE | k16BITMODE);
		TMR0ON = 0;
		l_wr_TMR(0,kMAX_HEADER_TIMEOUT_MASTER);
		TMR0IF = 0;
		TMR0ON = 1;												// and activate the timer
	
	#endif				
		
		idnumber_b = pid;
		EnableTransmitter();
		SENDB = 1;                       	// sync break generation on 
		TXREG = 0x00;                     // dummy byte for sync break generation 
		comflags_u.bits.FPENDING = 1;
		Nop();
		Nop();
		Nop();
		Nop();
	
		TXIE = 1;													// enable transmission ready interrupt
		return (0);												// return that initialization 
	}
	else
	{
		return (0xFF);
	}		

}
#endif

/* ***************************************************************************************************** */

l_u16 l_ifc_read_status_MyLinIfc(void)
{
	l_u16 status_help;
	l_u8 help;
	
	help = comflags_u.byte;
	
	if (0 == (help & 0x20)) // its.FPENDING)
	{
		ifc_status.b.LastFrame_PID = lastid_b;

		if (help & 0x40)	// comflags_u.bits.FCOMPLETE)
		{
			ifc_status.b.LastFrame_PID = lastid_b;

			ifc_status.b.Error_In_Response = 0;
			comflags_u.byte &= 0xBF;
		
			if (ifc_status.b.Successful_transfer)
			{
				ifc_status.b.Overrun = 1;
			}
			else
			{
				ifc_status.b.Successful_transfer = 1;
				ifc_status.b.Overrun = 0;
			}
		}
		else
		{
			if (0 != LIN_Error)
			{
				ifc_status.b.Error_In_Response = 1;
				LIN_Error = 0;
			}
		}
	}
	
	status_help = ifc_status.w;
	ifc_status.b.Successful_transfer = 0;
	ifc_status.b.Error_In_Response = 0;
	
	return (status_help);
}

/* ***************************************************************************************************** */

#ifdef _LIN_REV20

l_u8 ld_AssignFrameID(l_u8 *l_NAD)
{
	static u_wb MID;
	static l_u8 help;
	static l_u8 RetVal;
	
	RetVal = 0xFF;
	
	if (MasterReqB0 == *l_NAD)
	{
	  if (MasterReqB1 == 0x06)
		{
	    if (MasterReqB3 == (l_u8)(kApplSupplierID))
			{
	      if ( MasterReqB4 == (l_u8)(kApplSupplierID >> 8))
				{

					MID.b.lo = MasterReqB5;
					MID.b.hi = MasterReqB6;

					for (help=1;help < kMaxHandle-1;help++)
          {
	          if (l_HandleList[help].l_target_MID == MID.w)
	          {	
		         	if (MasterReqB7 == 0x40)                 // sequence was an UnAssignID
         			{
	         			(*(l_u8*)l_HandleList[help].l_id_addr) =0xFF;
           			RetVal = 0;
           			break;
         			}
         			else
         			{
        				if (LinPidList[(MasterReqB7 & 0x3F)] == MasterReqB7)																/* there was a parity failure in PID */
//		         		if (0 == CheckParity(MasterReqB7))
			         	{
									(*(l_u8*)l_HandleList[help].l_id_addr) = MasterReqB7;
     	      			RetVal = 0;
     	      			break;
								}
							}
						}
					}

	/* positive assign frame ID response if done succesful */
	
	       	if (RetVal == 0)
					{
						SlaveRespB0 = MasterReqB0;
	          SlaveRespB1 = 0x01;
	  	      SlaveRespB2 = 0xF1;
	          SlaveRespB3 = 0xFF;
	     	    SlaveRespB4 = 0xFF;
	       	  SlaveRespB5 = 0xFF;
	         	SlaveRespB6 = 0xFF;
		        SlaveRespB7 = 0xFF;
						
						u_flg_SlaveResp = 1;
					}
	      }
			}
		}
	}
	return(RetVal);
}

/* ****************************************************************** */

l_u8 ld_AssignNAD(l_u8 * l_NAD)
{
  l_u8 RetVal;
  
  RetVal = 0xFF;
  u_flg_SlaveResp = 0;

	if ((MasterReqB0 == *l_NAD) || (MasterReqB0 == 127L))
	{
	  if (MasterReqB1 == 0x06)
		{
			if (MasterReqB3 == (l_u8)(kApplSupplierID & 0xFF))
			{
				if( MasterReqB4 == ((l_u8)(kApplSupplierID >> 8)))
	     	{
	       	if (MasterReqB5 == (l_u8)(kApplFunctionID & 0xFF))
	       	{
		       	if (MasterReqB6 == ((l_u8)(kApplFunctionID >> 8)))
	  	     	{
  	  	     	if (MasterReqB0 != 127L)
  	  	     	{
		  	     	  *l_NAD = MasterReqB7;
	            }
	          /* create positive response */
	
							SlaveRespB0 = *l_NAD;
	     	   		SlaveRespB1 = 1;
	         		SlaveRespB2 = 0xF0;
	         		SlaveRespB3 = 0xFF;
	         		SlaveRespB4 = 0xFF;
	         		SlaveRespB5 = 0xFF;
	         		SlaveRespB6 = 0xFF;
	         		SlaveRespB7 = 0xFF;
	         		u_flg_SlaveResp = 1;

							RetVal = 0;
	        	}
	      	}
	     	}
			}
		}
	}
	return(RetVal);
}

/* ***************************************************************************************************** */

l_u8 ld_ReadByID(l_u8 * l_NAD) //, l_u16 l_SupplID, l_u16 l_FunctID)
{
  l_u8 RetVal;
  
  RetVal = 0xFF;
  u_flg_SlaveResp = 0;
	if (MasterReqB0 == *l_NAD)
	{
	  if (MasterReqB1 == 0x06)
		{
			if (MasterReqB4 == (l_u8)(kApplSupplierID & 0xFF))
			{
				if( MasterReqB5 == ((l_u8)(kApplSupplierID >> 8)))
	     	{
	       	if (MasterReqB6 == (l_u8)kApplFunctionID)
	       	{
		       	if (MasterReqB7 == ((l_u8)(kApplFunctionID >> 8)))
	  	     	{
						  SlaveRespB0 = MasterReqB0;
						  SlaveRespB2 = MasterReqB2 + kRSID_pAdder;

		  	     	if (MasterReqB3 == 0)
		  	     	{
							  SlaveRespB1 = 0x06;
							  SlaveRespB3 = MasterReqB4; //ld_product_id[0]; 
							  SlaveRespB4 = MasterReqB5; //ld_product_id[1]; 
							  SlaveRespB5 = MasterReqB6; //ld_product_id[2]; 
							  SlaveRespB6 = MasterReqB7; //ld_product_id[3]; 
							  SlaveRespB7 = ld_product_id[4]; 
		         		u_flg_SlaveResp = 1;
								RetVal = 0;
			  	    }
			  	    else
			  	    if (MasterReqB2 == 1)
			  	    {
							  SlaveRespB1 = 0x05;
							  SlaveRespB3 = ld_serial[0]; 
							  SlaveRespB4 = ld_serial[1]; 
							  SlaveRespB5 = ld_serial[2]; 
							  SlaveRespB6 = ld_serial[3]; 
							  SlaveRespB7 = 0xFF;
		         		u_flg_SlaveResp = 1;
								RetVal = 0;
				  	  }
				  	  else
				  	  if (MasterReqB2 < 16)
				  	  {
					  	}
					  	else
					  	if (MasterReqB2 < 32)
					  	{
						  }
						  else
						  if (MasterReqB2 < 64)
						  {
							}
							else
							{
							}
						}
					}
				}
			}
		}
	}
	
	if (0xFF == RetVal)			/* negative response */
	{
		SlaveRespB0 = *l_NAD;
		SlaveRespB1 = 0x03;
		SlaveRespB2 = 0x7F;
		SlaveRespB3 = kSID_ReadByID;
		SlaveRespB4 = 0x12;
		SlaveRespB5 = 0xFF;
		SlaveRespB6 = 0xFF;
		SlaveRespB7 = 0xFF;
		u_flg_SlaveResp = 1;
		
	}
	return(RetVal);
}

/* ***************************************************************************************************** */

l_u8 ld_Cond_Change_NAD(l_u8 *l_NAD)
{
  l_u8 RetVal;
  
  RetVal = 0xFF;
  u_flg_SlaveResp = 0;

	if (MasterReqB0 == *l_NAD)
	{
	  if (MasterReqB1 == 0x06)
		{		
    }
  }
      
}

#endif

/* ***************************************************************************************************** */
/* ***************************************************************************************************** */
