/*                                    Software License Agreement				 				 										
												 											 																																		
 The software supplied herewith by Microchip Technology Incorporated (the "Company") for its 
 PICmicro Microcontrller is intended and supplied to you, the Companys customer, for use   
 solely and exclusively on Microchip PICmicro Microcontroller products.			 			 
 The software is owned by the Company and/or its supplier, and is protected under applicable 
 copyright laws. All rights are reserved. Any use in violation of the foregoing restrictions 
 may subject the user to criminal sanctions under applicable laws, as well as to civil       
 liability for the breach of the terms and conditions of this license.                       
 THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, WHETHER EXPRESS, IMPLIED  
 OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND      
 FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, IN ANY      
 CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON   
 WHATSOEVER.										 									
                                    
   Filename:	     LINbasic.h                                    
   Date:          	1/6/2005                                        
   File Version:  	1.0                                               
   Author:        	Thorsten Waclawczyk                               
   Company:       	Microchip Technology GmbH                         
   Files required:  processor header files                         
   Notes:  					build with MPLAB-C18
										
										21.08.05 	add define STORETBLPTR and RESTORETBLPTR
															useful for MPLAB-C18, save time at interrupt execution instead using .section "tmp_data"

*/

#ifdef _LIN_BASIC_CFG             			/* switch to define variables only one */
  #define EXTERN                     	/* time without 'extern' */
#else
  #define EXTERN extern
#endif

#include "lin_cfg.h"

#define l_u8 unsigned char
#define l_u16 unsigned int
#define l_bool unsigned

//#define _SporZero
/************************************************************************************************/

#define TRUE (1)
#define FALSE (0)

#define _CS_DATA_HIGH	CSport |= mask_CS
#define _CS_DATA_LOW	CSport &= ~mask_CS

#define mask_TX	(1 << TXpin)
#define mask_RX	(1 << RXpin)
#define mask_CS	(1 << CSpin)

/************************************************************************************************/

//#ifdef _LINBASIC_DEF_
//	#undef _LINBASIC_DEF_


#define SetupPort()	   \
		TXport |=  mask_TX;\
		CSport &= ~mask_CS;\
		CStris &= ~mask_CS;\
		TXtris &= ~mask_TX;\
		RXtris |= mask_RX;

#define rd_bool_RXpin() (RXport & mask_RX)
	
/************************************************************************************************/
#define ExpBaudrate	kLinBaudrate

#ifdef _MCHIPC18

	#define	OERR		RCSTAbits.OERR
	#define FERR		RCSTAbits.FERR

	#define RCIF		PIR1bits.RCIF
	#define RCIE		PIE1bits.RCIE
	#define RCIP		IPR1bits.RCIP
	#define TXIF		PIR1bits.TXIF
	#define TXIE		PIE1bits.TXIE
	#define TXIP		IPR1bits.TXIP

	#define CREN		RCSTAbits.CREN
	#define	SPEN 		RCSTAbits.SPEN
	#define TXEN		TXSTAbits.TXEN
	#define BRGH		TXSTAbits.BRGH

	#define SENDB		TXSTAbits.SENDB
	
	#define IOFS		OSCCONbits.IOFS
	
	#ifdef _USE_EAUSART	
		#define BRG16		BAUDCONbits.BRG16
	#endif
	

	#define F 1
	#define W 0
	
#ifdef _AUTOBAUD
	#define ABDEN		BAUDCONbits.ABDEN
	#define WUE			BAUDCONbits.WUE
#endif

	#define TMR0ON 	T0CONbits.TMR0ON
	#define CARRY 	STATUSbits.C

	#define TMR0IF	INTCONbits.TMR0IF
	#define TMR0IE	INTCONbits.TMR0IE
	#define TMR0IP	INTCON2bits.TMR0IP
	
	#define INT0IF	INTCONbits.INT0IF
	#define INT0IE	INTCONbits.INT0IE
	#define INT0IP	IRP1bits.INT0IP
	#define INTEDG0	INTCON2bits.INTEDG0
#endif

/************************************************************************************************/

#ifdef _DRV_ON_LOWPRIO
	#define DriverPriority	0
#else
	#define DriverPriority	1
#endif

/************************************************************************************************/

#ifdef _USEEXTINT
	#ifndef _EXTINT_NBR
		#error " if external interrupt is in use please select interrupt number"
	#else
		#if ( _EXTINT_NBR > 0x002 )
			#error " select number between 0 .. 2"
		#endif
	#endif
#endif

/************************************************************************************************/

#ifdef _USE_EAUSART
	#ifndef _TX_ONREQUEST
//		#error " use EUSART only in combination with _TX_ONREQUEST "
	#endif
#endif

#ifdef _AUTOBAUD
	#ifndef _USEEXTINT
//		#error " use AUTOBAUD only in combination with external interrupt "
	#endif
#endif

#ifdef _CONTROLLER_FAMILY_PIC18
	#ifdef _DRV_ON_LOWPRIO
		#error " PIC16 controller family only uses one int vector "
	#endif
#endif

#ifdef _MASTERNODE
	#ifdef _AUTOBAUD
		#error " While driver is configured as a Master autobaud feature is not possible. Please deselect the _AUTOBAUD switch "
	#endif
	#ifdef _USEEXTINT
		#error " While driver is configured as a Master external interrupt is not necessary. Please deselect the _USEEXTINT switch "
	#endif
#endif
/************************************************************************************************/

#ifndef _TX_ONREQUEST
	#define _TX_val (1)
#else
	#define _TX_val (0)
#endif

/* define storage type for SPBRG reg size */
/* NOTE: */

#ifdef _USE_BRG16
	#define STORETYPE_BRG	unsigned int
#else
	#define STORETYPE_BRG	unsigned char
#endif

/* ****************************************************************** */

#ifdef _USE_EAUSART

	#ifdef _USE_BRGH

		#ifdef _USE_BRG16

//		#error " do not use both BRGH and BRG16, please disable the BRGH "
		
// max fosc = 40MHz, Bdr = 20kbps -> preload = 499
// max fosc = 40MHz, Bdr = 1kbps -> preload = 9999
		
			#define _BRG16_val (1)
			#define _BRGH_val  (1)
			#define kCLK_FACTOR (4L)
			#define SetupBRGClock() BRGH = 1;BRG16 = 1;
		#else

// max fosc = 40MHz, Bdr = 20kbps -> preload = 124
// max fosc = 40MHz, Bdr = 1kbps -> preload = 2499
// !!!! NOTE : 8bit prescale only gives a lowest Baudrate of 9765 bps at max fosc !!!!
		
			#define _BRG16_val (0)
			#define _BRGH_val  (1)
			#define kCLK_FACTOR (16L)
			#define SetupBRGClock() BRGH = 1;BRG16=0;
		#endif
														
	#else
		
		#ifdef _USE_BRG16

// max fosc = 40MHz, Bdr = 20kbps -> preload = 124
// max fosc = 40MHz, Bdr = 1kbps -> preload = 2499
		
			#define _BRG16_val (1)
			#define _BRGH_val  (0)
			#define kCLK_FACTOR (16L)
			#define SetupBRGClock() BRGH =0;BRG16=1;			
		#else

// max fosc = 40MHz, Bdr = 20kbps -> preload = 30
// max fosc = 40MHz, Bdr = 1kbps -> preload = 624			
// !!!! NOTE : 8bit prescale only gives a lowest Baudrate of 2440 bps at max fosc!!!!
		
			#define _BRG16_val (0)
			#define _BRGH_val  (0)
			#define kCLK_FACTOR (64L)
			#define SetupBRGClock() BRGH =0;BRG16=0;			
		#endif
	#endif

	#define BdratePreload ( kFosc / (ExpBaudrate * kCLK_FACTOR))-1

	#define SetupBRGClock_temp() BRGH = _BRGH_val;BRG16 = _BRG16_val;			

	#define SetupUART() BAUDCON = (_BRG16_val << 3);\
										 TXSTA = (_BRGH_val << 2) | (_TX_val << 5);\
										 RCSTA = 0x90;\
	
	#ifndef _USE_BRG16
		#if (BdratePreload > 255)
			#error " Baudrate preload value is greater than 255 . Do not fit into 8bit prescaler ."
		#endif
	#endif

#else			// standard UART

	#ifdef _USE_BRGH
			#define _BRGH_val  (4)
			#define kCLK_FACTOR (16)
			#define SetupBRGClock() BRGH = 1;
	#else
			#define _BRGH_val  (0)
			#define kCLK_FACTOR (64)
			#define SetupBRGClock() BRGH = 0;
	#endif


	#define BdratePreload ((kFosc / ExpBaudrate)/kCLK_FACTOR)-1

	#define SetupUART() TXSTA = _BRGH_val | _TX_val;\
										 RCSTA = 0x90;\


	#if BdratePreload > 255
		#error " Baudrate preload value is greater than 255 . Do not fit into 8bit prescaler ."
	#endif
	
#endif

#ifdef _AUTOBAUD
	
	#define kBitRateErr	22L
	#define kMaxSPBRG 	((100L + kBitRateErr)* BdratePreload)/100L
	#define kMinSPBRG 	((100L - kBitRateErr) * BdratePreload)/100L
#else
//	calculate the maximum allowed header time - >recieved 10bits , min_header_bits = 34
//  min_bits = min_header_bits - 10 = 24
//	max_bits = (min_bits + 1)*1,4 -> 25*1,4 = 35 -> 0x23

	#define kMAX_HEADER_TIMEOUT_SLAVE (65536L - (35L * BdratePreload))

#endif

#ifdef _MASTERNODE
	#define kMAX_HEADER_TIMEOUT_MASTER (65536L - (49L * BdratePreload))
#endif

/*
	Timer0 used as Frame Timeout counter
	define specific values for TMR0 prescaler depending on Fosc and requested Baudrate
*/

#define kTMR0_PRESCALE_ACTIVE_HELP	(kCLK_FACTOR/4L)

#define k16BITMODE	(0)

#if (kTMR0_PRESCALE_ACTIVE_HELP == 1)
	#define kTMR0_PRESCALE_ACTIVE 0x08		//	prescaler should 1:1, swith over to wdt
#else
	#if (kTMR0_PRESCALE_ACTIVE_HELP == 4)
		#define kTMR0_PRESCALE_ACTIVE 0x01	//	prescaler should 1:4
	#else
		#define kTMR0_PRESCALE_ACTIVE 0x08	//	prescaler should 1:16
	#endif
#endif

/* 
	BUSidle TTIME_OUT
	
	If a slave detects no activity on the bus for TTIME_OUT, it may assume that the bus is in
	sleep mode. This could e.g. be the case when the sleep message was corrupted.

fosc	4800		9600	14400		19200		20000
4	    20345	 10173	 6782	   5086	   4883
8	    40690	 20345	13563	  10173	   9766
16	  81380	 40690	27127	  20345	  19531
32	 162760	 81380	54253	  40690	  39063
40	 203451	101725	67817	  50863	  48828

*/

#define BUSidle (((kFosc /1024L)*25000L)/ExpBaudrate)

#if (BUSidle > 65535L)

	#error " overflow "
	#define EXT_TIMEOUT_DIV  (BUSidle/65535L)
	#define EXT_TIMEOUT_REST  BUSidle - (EXT_TIMEOUT_DIV * 65535L)
	#define _EXTENDED_TIMEOUT

#else
 
	#define BUSidle_TTIMEOUT	65535L - BUSidle

#endif

	#define kTMR0_PRESCALE_IDLE	(0x07)

//#endif

/* ****************************************************************** */
/* define Macro */

#ifdef _CONTROLLER_FAMILY_PIC18

	#define __EnableINT(nr)  	INT##nr##IF = 0; INT##nr##IE = 1;
	#define __DisableINT(nr) 	INT##nr##IE = 0
	#define __CheckINT(nr) 		(INT##nr##IE) && (INT##nr##IF)
	#define __ClearINT(nr) 		INT##nr##IF = 0
	#define __SetupINT(nr) 		INTEDG##nr = 1;INTtris |= (1 << INTpin);__ClearINT(nr);

	#define SetRcvInt()	RCIE = 1
	#define SetIntPrio(nr,v)	RCIP = v

#else


	#define __EnableINT(nr)  	INTF = 0;INTE = 1;
	#define __DisableINT(nr) 	INTE = 0
	#define __CheckINT(nr) 		(INTE) && (INTF)
	#define __ClearINT(nr) 		INTF = 0
	#define __SetupINT(nr) 		INTtris |= (1 << INTpin);__ClearINT(nr);

	#define SetRcvInt()	RCIE = 1
	#define SetRcvPrio(v)

	#define SetTmrPrio(nr,p)
	#define ClrTmrFlag(nr) T0IF = 0
	#define SetTmrInt(nr)	T0IE = 1
	#define ClrTmrInt(nr)	T0IE = 0

#endif

#ifdef _MANUAL_AUTODETECT
	#define _EDGEval (0)					// falling edge needed for manual auto detection
#else
	#define _EDGEval (1)					// rising edge needed by using th einternal autobaud detection
#endif

/* rising edge, pin configured as input,reset interrupt flag */

	#if (_EXTINT_NBR == 0)
		#define EnableINT()  	__EnableINT(0)
		#define DisableINT() 	__DisableINT(0)
		#define CheckINT() 		__CheckINT(0)
		#define ClearINT() 		__ClearINT(0)
		#define SetExtInt() 		__SetupINT(0)
	#elif (_EXTINT_NBR == 1)
		#define EnableINT()  	__EnableINT(1)
		#define DisableINT() 	__DisableINT(1)
		#define CheckINT() 		__CheckINT(1)
		#define ClearINT() 		__ClearINT(1)
		#define SetExtInt() 		__SetupINT(1)
	#elif (_EXTINT_NBR == 2)
		#define EnableINT()  	__EnableINT(2)
		#define DisableINT() 	__DisableINT(2)
		#define CheckINT() 		__CheckINT(2)
		#define ClearINT() 		__ClearINT(2)
		#define SetExtInt() 		__SetupINT(2)
	#else
		#error " select number between 0 .. 2"
	#endif

#ifdef _USE_BRG16
	#define	l_wr_Baudrate(val)  SPBRGH = (l_u8)((l_u16)val >> 8); SPBRG = (l_u8)val;
	#define	l_rd_Baudrate() ((l_u16)(SPBRGH) << 8) | SPBRG
#else
	#define	l_wr_Baudrate(val)  SPBRG = (l_u8)val;
	#define	l_rd_Baudrate(dest) dest = (l_u8)SPBRG;
#endif

#ifdef _CONTROLLER_FAMILY_PIC18
	#define EnableTMR(nr) TMR##nr##ON = (1L)
	#define DisableTMR(nr) TMR##nr##ON = (0L)
#else
	#define EnableTMR(nr)
	#define DisableTMR(nr)
#endif

#define l_wr_TMR(nr,x)	TMR##nr##H = ((x) >> 8);\
												TMR##nr##L = (x);\
												TMR##nr##IF = 0;\

#define l_rd_TMR(nr)  (((l_u16)(TMR##nr##L) | (l_u16)(TMR##nr##H) << 8 ))

#define SetupTMR_Int(nr,priority,select)	TMR##nr##IF = 0;\
																					TMR##nr##IP = priority;\
																					TMR##nr##IE = select;\

#define SetupRX_Int(nr,priority,select)		RCIF = 0;\
																					RCIP = priority;\
																					RCIE = select;\

#define EnableTransmitter()  TXEN = 1
#define DisableTransmitter() TXEN = 0

#ifdef _SporZero
	#define ReInitTransmitter() TXEN = 0; TXEN = 1
#else
	#define ReInitTransmitter()
#endif

/* ****************************************************************** */

#ifdef _MCHIPC18

	#define _STORETEMPREGS()	_asm\
												movff	0x14,cp__tmp_0\
 												movff	0x15,cp__tmp_0+1\
 												_endasm

	#define _RESTORETEMPREGS()	_asm\
												movff	cp__tmp_0,0x14\
 												movff	cp__tmp_0+1,0x15\
 												_endasm
 												
	#define _STORETBLPTR()		_asm\
												movff	TBLPTRL,cpTBLPTRL\
												movff	TBLPTRH,cpTBLPTRH\
												movff	TBLPTRU,cpTBLPTRU\
												movff	TABLAT,cpTABLAT\
 												_endasm						

	#define _RESTORETBLPTR()	_asm\
												movff	cpTBLPTRL,TBLPTRL\
												movff	cpTBLPTRH,TBLPTRH\
												movff	cpTBLPTRU,TBLPTRU\
												movff	cpTABLAT,TABLAT\
 												_endasm						
												
#else

		#define _STORETEMPREGS()
		#define _RESTORETEMPREGS()

		#define _STORETBLPTR()
		#define _RESTORETBLPTR()

#endif

/* ****************************************************************** */

#define l_u8 unsigned char

typedef union
{
	unsigned int w;
	struct
	{
		unsigned char lo;
		unsigned char hi;
	}b;
}u_wb;

typedef union
{
	l_u16	w;
	struct
	{
		l_bool Error_In_Response :1;
		l_bool Successful_transfer :1;
		l_bool Overrun : 1;
		l_bool Goto_sleep :1;
		l_u8	 :4;
		l_u8	LastFrame_PID;
	}b;
}_u_ifc_status;

typedef union
{
	l_u8 _c[5];
	struct
	{
		l_u16	SID;
		l_u16 FID;
		l_u8	VID;
	}b;
}_u_product_id;

/* ****************************************************************** */

EXTERN void l_ifc_rx_MyLinIfc(void);
EXTERN void l_ifc_init_MyLinIfc(void);
EXTERN void l_ifc_init_pid(void);

EXTERN void l_ifc_wake_up_MyLinIfc(void);
EXTERN void l_ifc_goto_sleep_req_MyLinIfc(void);
EXTERN l_u16 l_ifc_read_status_MyLinIfc(void);

/* ****************************************************************** */

#ifdef _LIN_REV20

	
/* ****************************************************************** */
/*          diagnostic specific defines                               */
/* ****************************************************************** */

#define kSID_AssignNAD      0xB0
#define kSID_AssignFrameID  0xB1
#define kSID_ReadByID       0xB2
#define kSID_CondNADChange  0xB3
#define kSID_DumpRequest    0xB4

#define kRSID_pAdder        0x40

typedef union
{
  l_u16 w;
  struct
  {
    l_u8 lo;
    l_u8 hi;
  }b;
}u_wb;

EXTERN l_u8 ld_AssignFrameID(l_u8 *l_NAD); //,l_u16 l_SupplID);
EXTERN l_u8 ld_AssignNAD(l_u8 *l_NAD); //,l_u16 l_SupplID,l_u16 l_FunctID);
EXTERN l_u8 ld_ReadByID(l_u8 *l_NAD); //l_u16 l_SupplID, l_u16 l_FunctID);

#endif

/* ****************************************************************** */


#ifdef _MASTERNODE
	EXTERN l_u8 l_ifc_StartMaster(unsigned char pid);
#endif
	
	
#ifdef EXTERN
	#undef EXTERN
#endif

#ifdef _LIN_BASIC_CFG
	#undef _LIN_BASIC_CFG
#endif
