#define _LIN_APPL_CFG
#include "LIN_appl.h"          // include the network specific definitions

#include "controller.h"

/************************************************************************/

extern volatile l_u8 idnumber_b;

l_u8 l_ifc_pid_to_handle(void)
{
		
  l_u8 val; 
  
  val = 0;
  
	if (idnumber_b == Window_pid)
  {
//    Response._c[6]++;
    val = SetupLinDrv(kWindow_handle);
  }
	else
	if (idnumber_b == Response_pid)
  {
//    Response._c[7]++;
    val = SetupLinDrv(kResponse_handle);
  }
	else
	if (idnumber_b == kMasterReq_pid)
  {
    val = SetupLinDrv(kMasterReq_handle);
  }
	else
	if (idnumber_b == kSlaveResp_pid)
  {
    if (u_flg_SlaveResp)
    {
     	val = SetupLinDrv(kSlaveResp_handle);
    }
}
    return val;
}

// *****************************************************************************************************
void l_ifc_init_pid(void)
{
	l_u8 cnt;
	
	Window_pid = 0xFF; //kWindow_pid;
	Response_pid = 0xFF; //kResponse_pid;
	
	cnt = sizeof(Response);
	do
	{
		Response._c[cnt-1] = 0x3C;
	}while(--cnt);
}

// *****************************************************************************************************
