#include "lin_cfg.h"
#include "controller.h"
#include "LIN_appl.h"                   // created from ldf file
#include "LINbasic.h"

#include "delay.h"

/************************************************************************************************/

_u_ifc_status lin_status;                       // the typedef of ifcstatus is defined in LINbasic.h

u_wb DLY_CNT;
l_u8 ADDRESS;
l_u8 ButtonImage;
l_u8 Flag = 0;
l_u8 ConfiguredNAD = 0xFF;

/************************************************************************************************/
/* prototypes */

l_u8 FastReadInput(void);
void WindowUp(void);
void WindowDown(void);

/************************************************************************************************/

#define VoltageThreshold        (12500L /(50000L / 256L))       /* set for 1.25V */
#define PA_ADC0CON      0x01      /* channel 0, A/DC ON, Left-justified, ADCS2=0 */
#define PA_ADC1CON      0x05      /* channel 1, A/DC ON, Left-justified, ADCS2=0 */

/* PORTA definitions */

#define AnalogIn0               RA0
#define AnalogIn1               RA1
#define UpButton                RA4
#define DwnButton               RA5
#define TRISAset          0xFB  /* B'11111011' */
#define ButtonMask      0x30  /* B'00110000' */

/* PORTC definitions */

#define UpDirection             RC0
#define DwnDirection    RC1
#define LINCS         RC2
//no connect            #define LINfault        RC3
#define LINTX         RC4
#define LINRX         RC5
#define TRISCset            0xE0  /* B'11100000' */


/************************************************************************************************/

void interrupt InterruptHandlerHigh(void)
{
   l_ifc_rx_MyLinIfc();            /* call the driver */
}

/************************************************************************************************/

void LinCOM(void)
{
   static l_u8 help;
   lin_status.w = l_ifc_read_status_MyLinIfc();

   /* check if transfer is finished and not more than one message has been received since last status check */

   if (lin_status.b.Successful_transfer)
   {
      if ( 0 == lin_status.b.Overrun)
      {
         l_u8_wr_Window_error(0);

         if ( lin_status.b.LastFrame_PID == kMasterReq_pid)
         {
            if ( MasterReqB0 == 0 )               /*~+:Sleep request*/
            {
               l_ifc_goto_sleep_req_MyLinIfc();
             
               /**/
               /* NOTE : the controller is NOT in POWERDOWN at this point only the LINdriver is configured */
               /*        to support the wakeup feature. If customer want to set controller into PowerDown  */
               /*        he has to add this sequence                                                       */
               /**/
            }
            else               /*~+:Diagnostics layer*/
            {
               if (MasterReqB2 == kAssignNAD)
               {
                  ld_AssignNAD(&ConfiguredNAD);
               }
               else
               {
                  if (MasterReqB2 == kAssignFrameID)
                  {
                     ld_AssignFrameID(&ConfiguredNAD);
                  }
                  else
                  {
                     if (MasterReqB2 == kReadByID)
                     {
                        ld_ReadByID(&ConfiguredNAD);
                     }
                  }
               }
            }
            l_flg_clr(u_flg_MasterReq);
         }
         else
         {
            /************************************************************************************************/
            /*      applications Layer                                                                                                                                                                                                                                      */
            /************************************************************************************************/

            if ( lin_status.b.LastFrame_PID == Window_pid)
            {
               Flag = 0xFF;
            }
         }
      }
   }
   else
   {
      /************************************************************************************************/
      /*      failure layer                                                                                                                                                                                                                                   */
      /************************************************************************************************/

      if (lin_status.b.Error_In_Response)
      {
         l_u8_wr_Window_error((l_u8)(lin_status.w)/*b.Error_In_Response*/);
      }
   }
}

/************************************************************************************************/

void WindowDown(void)
{
   l_bool_wr(UpDirection,0);
   l_bool_wr(DwnDirection,1);
}

/************************************************************************************************/

void WindowUp(void)
{
   l_bool_wr(DwnDirection,0);
   l_bool_wr(UpDirection,1);

   if (0 == (l_u8_rd_WindowLiftStatus() ^ 0xFF))
   {
      if (FastReadInput() < VoltageThreshold) /* get current value acroos shunt */
      {
         l_u8_wr_WindowLiftStatus(0xFF);
      }
      else         /*~+:/~* EmergencyReverse *~/*/
      {
         l_bool_wr(UpDirection,0);
         l_bool_wr(DwnDirection,1);
         DelayMs(250L);
         DelayMs(250L);
         l_bool_wr(UpDirection,0);   /* stop motor */
         l_bool_wr(DwnDirection,0);
         DelayMs(250L);
         DelayMs(250L);
         l_u8_wr_WindowLiftStatus(0x80);
      }
   }
   else
   {
      /* initial spike */
      DelayMs(20L);/* wait until into initial ramp */
      if (FastReadInput() < VoltageThreshold) /* get current value acroos shunt */
      {
         l_u8_wr_WindowLiftStatus(0xFF);
      }
      else
      {
         l_u8_wr_WindowLiftStatus(0);
      }
   }
}

/************************************************************************************************/

void WindowStop(void)
{
   l_bool_wr(UpDirection,0);
   l_bool_wr(DwnDirection,0);
   l_u8_wr_WindowLiftStatus(0);
}

/************************************************************************************************/

l_u8 ReadSwitchInput(void)
{
   l_u8 temp;

   temp = PORTA ^ 0xFF;
   ButtonImage = temp & ButtonMask;
   asm("swapf _ButtonImage,f");
   return( ButtonImage );
}

/************************************************************************************************/

l_u8 FastReadInput(void)
{
   GODONE = 1;
   while(GODONE);

   return ADRESH;          /* get conversion value */
}

/************************************************************************************************/

l_u8 ReadXInput(l_u8 val)
{
   ADCON1 = val;
   DelayUs(10L);
   return FastReadInput();
}

/************************************************************************************************/

l_u8 ReadFastInput(void)
{
   l_u8 temp;

   while(GODONE);

   temp = ADRESH;
   GODONE = 1;
   return temp;
}

/************************************************************************************************/

#define WaitMCP DelayUs(200L) // Delay100TCYx(255)
#define MCP201CSHIGH      _CS_DATA_HIGH; WaitMCP
#define MCP201CSLOW       _CS_DATA_LOW; WaitMCP

/************************************************************************************************/

void EnableMCP201(void)
{
   _CS_DATA_LOW; WaitMCP;
   WaitMCP;
   _CS_DATA_HIGH; WaitMCP;
   WaitMCP;
   _CS_DATA_LOW; WaitMCP;
   WaitMCP;
   _CS_DATA_HIGH; WaitMCP;
   WaitMCP;
}

/************************************************************************************************/

void DisableMCP201(void)
{
   MCP201CSLOW;
}

/************************************************************************************************/

l_bool l_ifc_connect_MyLinIfc(void)
{

   EnableMCP201();
   return 0;
}

/************************************************************************************************/

l_bool l_ifc_disconnect_MyLinIfc(void)
{
   DisableMCP201();
   return 0;
}

/************************************************************************************************/

void main(void)
{
   l_u8 help;

   OSCCON = 0x71;

   ADDRESS = 0;
   CMCON0 = 7;
   ANSEL = 2;      /* only AN1 - analogue channel for current feedback */
   ADCON1 = 0x10;  /* ADC conversion clock - Fosc/8 */


   OPTION = 0x13;  /*  pullups=ON, int=falling edge, T0=timer, T0prescale=1:256 */
                   /*  @4MHz, T0 is clocked every 64us and rollover every 16.384mS */

   TRISA = TRISAset;
   TRISC = TRISCset;
   PORTA = 0xFF;
   PORTC = 0xFC;
   ADCON0 = PA_ADC1CON; /* Setup A/D Converter */

   GODONE = 1;

   DLY_CNT.w = 0;

   l_u8_wr_WindowLiftStatus(0);

   ConfiguredNAD = kCfgNAD_Window;

   l_ifc_init_pid();
   l_ifc_init_MyLinIfc();                        /* initialize the driver */
   l_ifc_connect_MyLinIfc();             /* get the physical connection to LIN */
   l_ifc_goto_sleep_req_MyLinIfc();    /* wait for wakeup sequence */

   INTCON |= 0xC0;                       /* enable the interrupt */

   for (;;)
   {
      LinCOM();                                           /* check Status of driver */
      l_u8_wr_WindowLiftStatus(PORTC & 3);

      if (Flag)
      {
         Flag = 0;
         help = l_u8_rd_ButtonInfo() & 3;
         l_u8_wr_WindowBusInfo(help);

         if ((help ^ 0x02) == 0)          // goto BusWindowUp
         {
            Response._c[0] = (help ^ 0xFF);
            WindowUp();
         }
         else
         {
            if ((help ^ 0x01) == 0)               // goto BusWindowDown
            {
               Response._c[0] = (help ^ 0xFF);
               WindowDown();
               //l_u8_wr_ButtonInfo(0);
            }
         }
      }

      help = ReadSwitchInput();
      l_u8_wr_WindowPanelInfo(help);

      if (ButtonImage & 0x01)
      {
         WindowDown();
      }
      else
      {
         if (ButtonImage & 0x02)
         {
            WindowUp();
         }
         else
         {
            if (l_u8_rd_ButtonInfo() & 3)
            {
            }
            else
            {
               WindowStop();
            }
         }
      }
   }
}

/************************************************************************************************/
