/************************************************************************/
/*                                                                      */
/*                                     Software License Agreement				*/
/*                                                                      */
/* The software supplied herewith by Microchip Technology Incorporated 	*/
/* (the "Company") for its PICmicro Microcontrller is intended and 		*/
/* supplied to you, the Companys customer, for use solely and 					*/
/* exclusively on Microchip PICmicro Microcontroller products.			 		*/
/* The software is owned by the Company and/or its supplier, and is 		*/
/* protected under applicable copyright laws. All rights are reserved. 	*/
/* Any use in violation of the foregoing restrictions  may subject the 	*/
/* user to criminal sanctions under applicable laws, as well as to civil*/
/* liability for the breach of the terms and conditions of this license.*/
/*                                                                      */
/* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 		*/
/* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO,*/
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 	*/
/* PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, IN ANY      	*/
/* CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR CONSEQUENTIAL 		*/
/* DAMAGES, FOR ANY REASON WHATSOEVER.										 							*/
/*                                                                      */
/************************************************************************/

#ifndef _LINCFG_H
	#define _LINCFG_H
#endif

/************************************************************************************************/
/*																																															*/
/* 													compiler switches for LINdriver 																		*/
/*																																															*/
/************************************************************************************************/

#define _LIN_REV20								/* select driver specification */
																	/* if undefined then support is 1.x */

/************************************************************************************************/

//#define _MCHIPC18									/* use the Microchip C18 compiler */

/************************************************************************************************/

//#define _CONTROLLER_FAMILY_PIC18	/* driver is for PIC18 family */
//#define _DRV_ON_LOWPRIO					/* define drivers priority level on interrupt */
#define _TX_ONREQUEST							/* define transmission only allowed if node */
																	/* has to respond on a frame identifier */
//#define _USEEXTINT								/* use external int pin for synchbreak end detection */
#define _EXTINT_NBR	0							/* should be 0,1 or 2 for PIC18 */
//#define _USETIMEOUT								/* define if timeout manager should be in use */

/************************************************************************************************/
																	
#define _AUTOBAUD								/* define if baudrate reconfiguration is needed */

/* if autobaud feature is used and one of the following controller are used the switch */
/* _MANUAL_AUTODETECT must enabled to workaround to the issue in Autobaud feature */
/*
/* PIC18Fx4x0,PIC18Fx5x0,PIC18Fx6x0, PIC18Fx55x */

//#define _MANUAL_AUTODETECT			/* only used for RLT based EUSARTs */

/************************************************************************************************/

#define _USE_BRGH									/* baudrate in highspeed clock mode */
#define _USE_BRG16							/* use Baudrate generator in 16bit mode
																	/* inplemented in EAUSART only */
#define _USE_EAUSART						/* select type of UART */

/************************************************************************************************/

//#define _MASTERNODE							/* define if used in Master or slave node */

/************************************************************************************************/

#define kFosc	8000000L						/* system frequency */

/************************************************************************************************/
/*          								USART / Timer specific defines                            					*/
/************************************************************************************************/

 #define kLinTimeBase 5ms
 #define kLinBaudrate  10400L


/************************************************************************************************/
/*												controller specific hardware description 															*/
/************************************************************************************************/

#define TXport 	PORTC					/* configure the TX pin data & direction */
#define TXtris 	TRISC
#define TXpin	 	4

#define RXport 	PORTC					/* configure the RX pin data & direction */
#define RXtris	TRISC
#define RXpin  		5

#define CSport 	PORTC					/* configure the CSpin from physical interface */
#define CStris	TRISC
#define CSpin	 	2

#define INTport	PORTA					/* configure the INTpin data & direction if used */
#define INTtris	TRISA
#define INTpin	2

/************************************************************************************************/
/* 				SupplierID,FunctionID and Variant used at LIN2.0																			*/
/************************************************************************************************/

#define ApplSupplierID	0x0014
#define ApplFunctionID	0xAA55
#define ApplVariant			0x3C
#define ApplSerial			0

/************************************************************************************************/
/************************************************************************************************/

