/***********************************************************************************************/
/*                                                                                             */
/*                                     Software License Agreement                              */
/*                                                 *                                           */
/* The software supplied herewith by Microchip Technology Incorporated (the 'Company') for its */
/* PICmicro Microcontrller is intended and supplied to you, the Companys customer, for use   */
/* solely and exclusively on Microchip PICmicro Microcontroller products.                      */
/* The software is owned by the Company and/or its supplier, and is protected under applicable */
/* copyright laws. All rights are reserved. Any use in violation of the foregoing restrictions */
/* may subject the user to criminal sanctions under applicable laws, as well as to civil       */
/* liability for the breach of the terms and conditions of this license.                       */
/*                                                                                             */
/* THIS SOFTWARE IS PROVIDED IN AN 'AS IS' CONDITION. NO WARRANTIES, WHETHER EXPRESS, IMPLIED  */
/* OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND      */
/* FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, IN ANY      */
/* CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON   */
/* WHATSOEVER.                                                                                 */
/*                                                                                             */
/***********************************************************************************************/
/*                                                                                             */
/*                                                                                             */
/* created by Lcfg3a Rev: 1.0.18*/
/*                                                                                             */
/*            changes  : 12/04/04 implementing table 'l_table_s l_HandleList[kMaxHandle]'      */
/*                       12/07/04 add variable in specific IDtable to make HiTech-Support      */
/*                                add switch _MCHIPC18                                         */
/*                       10/09/04 add status flags for each frame                              */
/* last modification   : 23.10.2004 19:36:51                              */
/*                                                                                             */
/* origin LDF script   : LDF-2-.h Converter : C:\extraProg\VB98\projects\ldf\ldf_folder\Demoboard_2.0_int.ldf                                             */
/*                                                                                             */
/***********************************************************************************************/

#include "lin_cfg.h"

#ifdef _LIN_APPL_CFG
    #define EXTERN
#else
    #define EXTERN extern
#endif

#ifndef _MASTERNODE				// if master then frame data direction is twisted
	#define RESPOND (1)
	#define RECEIVE (2)
#else
	#define RESPOND (2)
	#define RECEIVE (1)
#endif

#ifdef _MCHIPC18
    #define CONST_ROM const rom 
#else
    #define CONST_ROM const 
#endif

#define l_u8 unsigned char
#define l_u16 unsigned int
#define l_bool unsigned

#define kAssignNAD						0xB0
#define kAssignFrameID				0xB1
#define kReadByID							0xB2
#define kConditionalNADChange	0xB3
#define kDumpRequest					0xB4
#define	kRSID_pAdder					0x40

#define LD_SUCCESS 	0			// The call was successfully carried out.
#define LD_NEGATIVE 1 		// The call failed, more information can be found by parsing error_code.
#define LD_NO_RESPONSE 2	// No response was received on the request.
#define	LD_OVERWRITTEN 3	// The slave response frame has been overwritten by another operation, i.e. the result is lost.

#define LD_IN_PROGRESS 	0	// The transmission is not yet completed.
#define LD_COMPLETED 		1	// The transmission has completed successfully (and
													// you can issue a new ld_send_message call).
#define LD_FAILED 			2	// The transmission ended in an error. The data was
													// only partially sent. (You can make a new call to ld_send_message.)

typedef union
{
	l_u16 w;
	struct
	{
		l_u8  lo;
		l_u8  hi;
	}b;
}u_wb;

/* ****************************************************************** */
/*          USART / Timer specific defines                            */
/* ****************************************************************** */

// #define kLinTimeBase 5.0ms
// #define kLinBaudrate  10400
 #define kLinVersion 2.0

/* ****************************************************************** */
/* *         system specific handle description                     * */
/* ****************************************************************** */

extern volatile l_u8  idnumber_b;
#define SetupLinDrv(handle)  handle

#define kWindow_handle          1
#define kWindow_id              5
#define kWindow_pid             133
#define kWindow_len             2
#define kWindow_mode            RECEIVE
EXTERN bank1 l_u8 Window_pid;

#define kResponse_handle        2
#define kResponse_id            53
#define kResponse_pid           245
#define kResponse_len           8
#define kResponse_mode          RESPOND
EXTERN bank1 l_u8 Response_pid;

#define kMasterReq_handle       3
#define kMasterReq_id           60
#define kMasterReq_pid          60
#define kMasterReq_len          8
#define kMasterReq_mode         RECEIVE

#define kSlaveResp_handle       4
#define kSlaveResp_id           61
#define kSlaveResp_pid          125
#define kSlaveResp_len          8
#define kSlaveResp_mode         RESPOND

#define kMaxHandle 0x05

/* ****************************************************************** */
/*        typedef frame related structure                                     */
/* ****************************************************************** */

typedef struct 
{
    l_bool  UP : 1;
    l_bool  DOWN : 1;
    l_u8  :6;
} _c_Window_msgType;

typedef struct 
{
  l_u8  WindowDriverInfo:8;
  l_u8  RB1:8;
  l_u8  WindowBusInfo:8;
  l_u8  WindowPanelInfo:8;
  l_u8  Window_error:8;
  l_u8  WindowLiftStatus:8;
  l_u8  RB6:8;
  l_u8  RB7:8;
} _c_Response_msgType;

typedef struct 
{
    l_u8  MasterReqB0 : 8;
    l_u8  MasterReqB1 : 8;
    l_u8  MasterReqB2 : 8;
    l_u8  MasterReqB3 : 8;
    l_u8  MasterReqB4 : 8;
    l_u8  MasterReqB5 : 8;
    l_u8  MasterReqB6 : 8;
    l_u8  MasterReqB7 : 8;
} _c_MasterReq_msgType;

typedef struct 
{
    l_u8  SlaveRespB0 : 8;
    l_u8  SlaveRespB1 : 8;
    l_u8  SlaveRespB2 : 8;
    l_u8  SlaveRespB3 : 8;
    l_u8  SlaveRespB4 : 8;
    l_u8  SlaveRespB5 : 8;
    l_u8  SlaveRespB6 : 8;
    l_u8  SlaveRespB7 : 8;
} _c_SlaveResp_msgType;


/* ****************************************************************** */
/*        typedef frame related unions                                */
/* ****************************************************************** */


typedef union 
{
     l_u8  _c[kWindow_len];
     _c_Window_msgType window;
} _c_Window_msgBuf;

typedef union 
{
     l_u8  _c[kResponse_len];
     _c_Response_msgType response;
} _c_Response_msgBuf;


typedef union 
{
     l_u8  _c[kMasterReq_len];
     _c_MasterReq_msgType masterreq;
} _c_MasterReq_msgBuf;


typedef union 
{
     l_u8  _c[kSlaveResp_len];
     _c_SlaveResp_msgType slaveresp;
} _c_SlaveResp_msgBuf;


/* ****************************************************************** */
/*                 frame related signal defines                       */
/* ****************************************************************** */


#define UP               	  Window.window.UP
#define DOWN              	Window.window.DOWN
#define ButtonInfo          Window._c[0]
#define WindowLiftStatus    Response.response.WindowLiftStatus
#define Window_error        Response.response.Window_error
#define WindowPanelInfo     Response.response.WindowPanelInfo
#define WindowBusInfo       Response.response.WindowBusInfo
 
#define MasterReqB0               MasterReq.masterreq.MasterReqB0
#define MasterReqB1               MasterReq.masterreq.MasterReqB1
#define MasterReqB2               MasterReq.masterreq.MasterReqB2
#define MasterReqB3               MasterReq.masterreq.MasterReqB3
#define MasterReqB4               MasterReq.masterreq.MasterReqB4
#define MasterReqB5               MasterReq.masterreq.MasterReqB5
#define MasterReqB6               MasterReq.masterreq.MasterReqB6
#define MasterReqB7               MasterReq.masterreq.MasterReqB7

#define SlaveRespB0               SlaveResp.slaveresp.SlaveRespB0
#define SlaveRespB1               SlaveResp.slaveresp.SlaveRespB1
#define SlaveRespB2               SlaveResp.slaveresp.SlaveRespB2
#define SlaveRespB3               SlaveResp.slaveresp.SlaveRespB3
#define SlaveRespB4               SlaveResp.slaveresp.SlaveRespB4
#define SlaveRespB5               SlaveResp.slaveresp.SlaveRespB5
#define SlaveRespB6               SlaveResp.slaveresp.SlaveRespB6
#define SlaveRespB7               SlaveResp.slaveresp.SlaveRespB7

/* ****************************************************************** */
/*                 frame related API variable calls                   */
/* ****************************************************************** */

#define l_bool_rd_UP()   	(UP)
#define l_bool_wr_UP(a)  	UP = a
#define l_bool_rd_DOWN()  	(DOWN)
#define l_bool_wr_DOWN(a) 	DOWN = a

#define l_u8_rd_ButtonInfo()  (ButtonInfo)
#define l_u8_wr_ButtonInfo(a)  ButtonInfo = a

#define l_u8_rd_WindowLiftStatus()  WindowLiftStatus
#define l_u8_wr_WindowLiftStatus(a)  WindowLiftStatus = a
#define l_u8_rd_Window_error()      Window_error
#define l_u8_wr_Window_error(a)     Window_error = a
#define l_u8_rd_WindowPanelInfo()  WindowPanelInfo
#define l_u8_wr_WindowPanelInfo(a)  WindowPanelInfo = a
#define l_u8_rd_WindowBusInfo()  WindowBusInfo
#define l_u8_wr_WindowBusInfo(a)  WindowBusInfo = a

/* ****************************************************************** */
/*                 general dynamic API calls                          */
/* ****************************************************************** */

#define l_bool_wr(l_signal_handle,a)     l_signal_handle = a
#define l_bool_rd(l_signal_handle)       l_signal_handle
#define l_u8_wr(l_signal_handle,a)       l_signal_handle = a
#define l_u8_rd(l_signal_handle)         l_signal_handle
#define l_u16_wr(l_signal_handle,a)      l_signal_handle = a
#define l_u16_rd(l_signal_handle)        l_signal_handle
#define l_flg_tst(l_flag_handle)         l_flag_handle
#define l_flg_clr(l_flag_handle)         l_flag_handle = 0

/* ****************************************************************** */
/*           reserve memory for application related variables         */
/* ****************************************************************** */

EXTERN _c_Window_msgBuf Window;
EXTERN _c_Response_msgBuf Response;
EXTERN union
{
	_c_MasterReq_msgBuf MasterReq;
	_c_SlaveResp_msgBuf SlaveResp;
}_u_Buffer;

#define MasterReq _u_Buffer.MasterReq
#define SlaveResp _u_Buffer.SlaveResp

/*
					Node Attributes
*/

#define kApplSupplierID	0x0014
#define kApplFunctionID	0xAA55
#define kApplVariant		0x3C
#define kApplSerial			0

typedef struct
{
	l_u8	CfgNAD;
	l_u16	SID;
	l_u16	FID;
	l_u8	VID;
}_c_Attr_msgType;


#define kNode_Window							1
#define kProtLIN_Window   				2.0 
#define kCfgNAD_Window				 	0x04

#define	kSID_Window						0x6000
#define kFID_Window						1
#define kVID_Window						0

#define response_error_Window 	Window_Error 
#define kMID_Window 		0x0500
#define kMID_Response		0x2000


/* ****************************************************************** */
/* *                    IDTable entry points                        * */
/* ****************************************************************** */

/*	
*/

#ifdef _LIN_REV20

  typedef struct						// supports LIN2.0
  {
  unsigned char    l_target_mode;
  unsigned char  *l_target_addr;
  unsigned char    l_target_len;
  unsigned int		l_target_MID;
  unsigned char *l_id_addr;
  }l_table_s;

#else

  typedef struct						// supports LIN1.x
  {
  unsigned char    l_target_mode;
  unsigned char  * l_target_addr;
  unsigned char    l_target_len;
  }l_table_s;

#endif

#define NUL_handle  0

/* ****************************************************************** */

#ifdef _LIN_APPL_CFG

#ifdef _LIN_REV20

          CONST_ROM l_table_s l_HandleList[kMaxHandle] = {
        {0x00,0x00,0x00,0xFFFF,0xFF},
        {kWindow_mode,&Window,kWindow_len,kMID_Window,&Window_pid},
        {kResponse_mode,&Response,kResponse_len,kMID_Response,&Response_pid},
        {kMasterReq_mode,&MasterReq,kMasterReq_len,0xFFFF,0xFF},
        {kSlaveResp_mode,&SlaveResp,kSlaveResp_len,0xFFFF,0xFF}
       };
#else

        CONST_ROM l_table_s l_HandleList[kMaxHandle] = {
        {NUL_handle,NUL_handle,NUL_handle},
        {kWindow_mode,(l_u16)&Window,kWindow_len},
        {kResponse_mode,(l_u16)&Response,kResponse_len},
        {kMasterReq_mode,(l_u16)&MasterReq,kMasterReq_len},
        {kSlaveResp_mode,(l_u16)&SlaveResp,kSlaveResp_len}\
        };
#endif
		CONST_ROM l_u8 ld_product_id[5] = {
			kApplSupplierID,kApplSupplierID/256L,\
			kApplFunctionID,kApplFunctionID/256L,\
			kApplVariant};		

		CONST_ROM l_u8 ld_serial[4] = {
			kApplSerial,(kApplSerial>>8),(kApplSerial>>16),(kApplSerial>>24)};

#else
    extern CONST_ROM l_table_s l_HandleList[kMaxHandle];
		extern CONST_ROM l_u8 ld_product_id[5];
		extern CONST_ROM l_u8 ld_serial[4];
#endif


/* ****************************************************************** */
/*          definition of control flags corresponding                 */
/* ****************************************************************** */
/*                                                                    */
/* usage : if frame has to respond :                                  */
/*         flag should be set after linked as been updated, flag      */
/*         will be cleared after successful transmission              */
/*                                                                    */
/*         if frame has to receive :                                  */
/*         flag will be set if reception was successful               */
/*                                                                    */
/* ****************************************************************** */

 typedef struct 
 {
    l_bool : 1;
    l_bool u_bit_Window : 1;
    l_bool u_bit_Response : 1;
    l_bool u_bit_MasterReq : 1;
    l_bool u_bit_SlaveResp : 1;
    l_bool : 3;
 }_c_FrameCtrlFlags_msgType; 

 typedef union 
 {
    l_u8  _c[1];
    _c_FrameCtrlFlags_msgType framectrlflags; 
 }_c_FrameCtrlFlags_msgBuf;

/* ****************************************************************** */

#define u_flg_Window 			    FrameCtrlFlags.framectrlflags.u_bit_Window
#define u_flg_Response 				FrameCtrlFlags.framectrlflags.u_bit_Response
#define u_flg_MasterReq 					FrameCtrlFlags.framectrlflags.u_bit_MasterReq
#define u_flg_SlaveResp 					FrameCtrlFlags.framectrlflags.u_bit_SlaveResp

/* ****************************************************************** */

EXTERN _c_FrameCtrlFlags_msgBuf FrameCtrlFlags;

/* ****************************************************************** */

//#define _MASTERNODE


#ifdef  _MASTERNODE

  #define SysTimeBase(x) ((kFosc/1000000L) * x)/4L
  #define SchedTicks(us,ms)  (ms * SysTimeBase(us))/us
  
  #define kT1_Reload SysTimeBase(500L)
  
  /* ******************************************************************* */
  /* LIN Schedule table includes the PID and the schedule timing */
  
  typedef struct
  {
  unsigned char handle;
  unsigned char pid;
  unsigned char	ticks;
  }_c_SysSched_msgType;
  
  typedef struct
  {
  	unsigned int SID;
  	unsigned int MID_FID;
  	unsigned char PID;
  }_c_Assign_msgType;
  
  typedef struct
  {
  	unsigned char handle;
  	unsigned char pid;
  }_c_SysEvent_msgType;

  #ifdef _LIN_APPL_CFG

	  CONST_ROM _c_SysSched_msgType NormalTable[2]= {\
            {kWindow_handle,kWindow_pid,15},\
            {kResponse_handle,kResponse_pid,15},\
						};\
								    			
  #else
	  extern CONST_ROM _c_SysSched_msgType NormalTable[3];
  #endif

#endif

/* ******************************************************************* */

#ifdef _LIN_APPL_CFG
    #undef _LIN_APPL_CFG
//  #error "define had been defined"
#endif
#ifdef EXTERN
    #undef EXTERN
#endif
