//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jerry Gao, Jemmey Huang					 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *	File name:	   Calcu.c											 *
// * 	File description: calculation the parameters like RMS current,	 *
// *                      RMS voltage, power, power factor etc           *
// **********************************************************************/

#define _CALCULATE_C
//#include <p33FJ64GP206.h>
//#include <p33FJ128GP706.h>
#include <math.h>
#include <dsp.h>
#include "global.h"
#include "MCP390x.h"
#include "uart_comm.h"
#include "calibrate.h"
#include "calcu.h"
#include "interrupt.h"
#undef _CALCULATE_C  

//#define CALIBRATE_MODE

extern void copy_data(int length, int* data_out, int* data_in, int offset, int* end_data_in);
extern void DFT(int length, int* data_in, int* data_out, int* table, int page);
extern void DFT_Fundamental(int length, int* data_in, int* data_out, int* table, int page, int cycles);
extern float calculate_freq(int data1, int data2, int data3, int data4, unsigned char smp_pnt);
extern void qusi_syn_wnd(int smp_pnt, int* input_data, int offset, int* end_input_data, int* table, int page, int* output_data);
extern void ComputeMagnitude(int* input, unsigned long* output, int len, unsigned long* total_magnitude);
extern void ComputePower(int* voltage_buffer, int* current_buffer, int* output, int len);



/*
const int signal[200] __attribute__ ((space(auto_psv), aligned (1024))) = 
{
30720, 29781, 27125, 23195, 18593, 13930, 9682, 6093, 3168, 730, -1461, -3587, -5679, -7595, -9068, -9802, -9600, -8456, -6593, -4427, -2467, -1181, -869, -1593, -3168, -5230, -7352, -9163, -10447, -11173, -11465, -11523, -11520, -11523, -11465, -11173, -10447, -9163, -7352, -5230, -3168, -1593, -869, -1181, -2467, -4427, -6593, -8456, -9600, -9802, -9068, -7595, -5679, -3587, -1461, 730, 3168, 6093, 9682, 13930, 18593, 23195, 27125, 29781, 30720, 29781, 27125, 23195, 18593, 13930, 9682, 6093, 3168, 730, -1461, -3587, -5679, -7595, -9068, -9802, -9600, -8456, -6593, -4427, -2467, -1181, -869, -1593, -3168, -5230, -7352, -9163, -10447, -11173, -11465, -11523, -11520, -11523, -11465, -11173, -10447, -9163, -7352, -5230, -3168, -1593, -869, -1181, -2467, -4427, -6593, -8456, -9600, -9802, -9068, -7595, -5679, -3587, 
-1461, 730, 3168, 6093, 9682, 13930, 18593, 23195, 27125, 29781, 30720, 29781, 27125, 23195, 18593, 13930, 9682, 6093, 3168, 730, -1461, -3587, -5679, -7595, -9068, -9802, -9600, -8456, -6593, -4427, -2467, -1181, -869, -1593, -3168, -5230, -7352, -9163, -10447, -11173, -11465, -11523, -11520, -11523, -11465, -11173, -10447, -9163, -7352, -5230, -3168, -1593, -869, -1181, -2467, -4427, -6593, -8456, -9600, -9802, -9068, -7595, -5679, -3587, -1461, 730, 3168, 6093, 9682, 13930, 18593, 23195, 27125, 29781, 30720, 29781, 27125, 23195, 18593, 13930, 9682, 6093, 3168, 730, -1461
};

const int i_signal[200] __attribute__ ((space(auto_psv), aligned (1024))) = 
{
10240,	10196,	10064,	9845,	9541,	9156,	8691,	8151,	7541,	6866,	6132,	5345,	4512,	3640,	2737,	1810,	868,	-82,	-1032,	-1972,	-2895,	-3794,	-4660,	-5485,	-6263,	-6988,	-7652,	-8250,	-8777,	-9228,	-9600,	-9889,	-10093,	-10210,	-10239,	-10179,	-10032,	-9798,	-9480,	-9081,	-8603,	-8050,	-7429,	-6743,	-5999,	-5204,	-4364,	-3486,	-2578,	-1648,	-703,	247,	1196,	2134,	3053,	3947,	4806,	5624,	6393,	7107,	7760,	8347,	8861,	9299,	9656,	9931,	10120,	10221,	10235,	10160,	9998,	9749,	9417,	9003,	8512,	7947,	7314,	6618,	5865,	5061,	4214,	3330,	2418,	1485,	539,	-412,	-1359,	-2295,	-3210,	-4098,	-4951,	-5761,	-6521,	-7225,	-7867,	-8441,	-8942,	-9366,	-9710,	-9970,	-10143,	-10230,	-10228,	-10138,	
-9961,	-9698,	-9351,	-8924,	-8419,	-7842,	-7198,	-6492,	-5729,	-4917,	-4063,	-3174,	-2257,	-1321,	-374,	577,	1522,	2455,	3366,	4249,	5094,	5896,	6647,	7341,	7971,	8533,	9021,	9432,	9761,	10006,	10165,	10236,	10219,	10114,	9921,	9643,	9282,	8842,	8324,	7735,	7080,	6363,	5592,	4772,	3911,	3017,	2096,	1158,	209,	-741,	-1685,	-2615,	-3522,	-4398,	-5237,	-6030,	-6772,	-7455,	-8074,	-8623,	-9098,	-9495,	-9810,	-10040,	-10183,	-10239,	-10207,	-10086,	-9879,	-9587,	-9212,	-8757,	-8227,	-7626,	-6960,	-6233,	-5453,	-4626,	-3758,	-2859,	-1935,	-994,	-44,	906,	1848,	2774,	3676,	4546,	5378,	6163,	6895,	7567,	8174,	8711,	9173,	9555
};
*/


float ratio1; //for the compensation of current and voltage calculation
float ratio2; //for the compenastion of power calculation
float KF; //for the k1,k2 compensation under different input frequency

unsigned int suffix, gain_value, suffix1; 
	
void Calculation(void)
{
/*------------------------------------------------------------------
	Function Name:  Calculation()
	this routine will calculate each phase RMS current/voltage value, active power, reactive power, apparent power, power factor
	frequency, energy, THD, HD etc

	firstly, calculate the frequency and find a suitable window for quasi-synchronous window processing
	then do a loop to calculate each phase parameter, in the loop,the calculation includes -
		1. voltage signal data pre-processing -  to shift the data into a better range for better accurcy during calculation
		2. adding qusi_synchronous window to voltage signal
		3. voltage signal DFT transform - to get 0~31 order harmonic value(real part and image part)
		4. calculate amplitude for each order harmonic for voltage signal
		5. update the DC offset
		6. calculate RMS voltage value
		7. calculate the HD and THD
		8. current signal data pre-processing -  to shift the data into a better range for better accurcy during calculation
		9. adding qusi_synchronous window to current signal
		10. current signal DFT transform - to get 0~31 order harmonic value(real part and image part)
		11. calculate amplitude for each order harmonic for current signal
		12. update the DC offset
		13. calculate RMS current value	
		14. calculate the HD and THD
		15. compute power - active power, reactive power, power factor
	then calculate the total active power, total reactive power, total power factor and the energy

	input:
			none
	return:
			none

	Design By:					 Jemmey Huang  CADC
	Last modification:			 Oct 8 / 2006

------------------------------------------------------------------*/	
	unsigned char cnt;
	unsigned char DFTPreProcessCnt1, DFTPreProcessCnt2;
	int temp, i, mag_sft_cnt;
	unsigned int delta_time;
	
	int* 	table_pointer;
	int* 	window_pointer;
	int 	table_page, window_page;
//	int 	length;	
	
	float tempValue, tempValue1;
	float tempTime;	
//	float ratio1, ratio2;
	unsigned long amplitude;
	long 	power[4];
	
	float 	PhaseVoltage[3];
	float 	PhaseCurrent[3];
	float 	PhaseApparentPwr[3];
	float 	PhaseActPwr[3];
	float 	PhaseReactPwr[3]; 	
	float 	PhasePwrFactor[3];
	float	fundemental_active_pwr[3];
	float 	fundemental_reactive_pwr[3];
	float	harmonic_active_pwr[3];
	float 	harmonic_reactive_pwr[3];
	
	float 	step_culmulation;
	float   k1, k2;
	

/*	
	PSVPAG=__builtin_psvpage(&signal[0]); 
	CORCONbits.PSV=1;
	
	for(i=0;i<200;i++)
	{
		temp = signal[i];
		voltage_sample[0][i] =  temp;
		voltage_sample[1][i] =  temp;
		voltage_sample[2][i] = temp;
	}

	PSVPAG=__builtin_psvpage(&i_signal[0]); 	
	for(i=0;i<200;i++)
	{	
		temp = i_signal[i];
		current_sample[0][i] =  temp;
		current_sample[1][i] =  temp;
		current_sample[2][i] = temp;
	}
*/

/*	gds.data.Frequency = measure_freq();
	
	T2_PRD = Fcy/(gds.data.Frequency*16);
	Delta_F = Delta_F*Delta_F;
	DataNum_Cycle3 = smp_pnt*3;	
*/

	tempTime = DataNum_Cycle3*ENGY_MULTIPLIER;				//ENGY_MULTIPLIER = 3*sample period/3600

	// get the suffix of ajustment parameters
	switch (smp_pnt)
	{
		case 58:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_58pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window58[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_58pt[0]);
			window_page = (int)__builtin_psvpage(&window58[0]);
			ratio1 = RATIO64_58*(1+RATIOF_P58*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_58*RATIO64_58*(1+RATIOF_P58*PWR_ERROR_COMPENS*Delta_F);
			break;			
		case 59:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_59pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window59[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_59pt[0]);
			window_page = (int)__builtin_psvpage(&window59[0]);
			ratio1 = RATIO64_59*(1+RATIOF_P59*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_59*RATIO64_59*(1+RATIOF_P59*PWR_ERROR_COMPENS*Delta_F);
			break;
		case 60:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_60pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window60[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_60pt[0]);
			window_page = (int)__builtin_psvpage(&window60[0]);
			ratio1 = RATIO64_60*(1+RATIOF_P60*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_60*RATIO64_60*(1+RATIOF_P60*PWR_ERROR_COMPENS*Delta_F);
			break;			
		case 61:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_61pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window61[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_61pt[0]);
			window_page = (int)__builtin_psvpage(&window61[0]);
			ratio1 = RATIO64_61*(1+RATIOF_P61*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_61*RATIO64_61*(1+RATIOF_P61*PWR_ERROR_COMPENS*Delta_F);
			break;
		case 62:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_62pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window62[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_62pt[0]);
			window_page = (int)__builtin_psvpage(&window62[0]);
			ratio1 = RATIO64_62*(1+RATIOF_P62*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_62*RATIO64_62*(1+RATIOF_P62*PWR_ERROR_COMPENS*Delta_F);
			break;
		case 63:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_63pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window63[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_63pt[0]);
			window_page = (int)__builtin_psvpage(&window63[0]);
			ratio1 = RATIO64_63*(1+RATIOF_P63*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_63*RATIO64_63*(1+RATIOF_P63*PWR_ERROR_COMPENS*Delta_F);
		case 65:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_65pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window65[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_65pt[0]);
			window_page = (int)__builtin_psvpage(&window65[0]);
			ratio1 = RATIO64_65*(1+RATIOF_P65*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_65*RATIO64_65*(1+RATIOF_P65*PWR_ERROR_COMPENS*Delta_F);
			break;
		case 66:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_66pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window66[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_66pt[0]);
			window_page = (int)__builtin_psvpage(&window66[0]);
			ratio1 = RATIO64_66*(1+RATIOF_P66*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_66*RATIO64_66*(1+RATIOF_P66*PWR_ERROR_COMPENS*Delta_F);
			break;
		case 67:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_67pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window67[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_67pt[0]);
			window_page = (int)__builtin_psvpage(&window67[0]);
			ratio1 = RATIO64_67*(1+RATIOF_P67*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_67*RATIO64_67*(1+RATIOF_P67*PWR_ERROR_COMPENS*Delta_F);
			break;
		case 68:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_68pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window68[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_68pt[0]);
			window_page = (int)__builtin_psvpage(&window68[0]);
			ratio1 = RATIO64_68*(1+RATIOF_P68*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_68*RATIO64_68*(1+RATIOF_P68*PWR_ERROR_COMPENS*Delta_F);
			break;
		case 69:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_69pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window69[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_69pt[0]);
			window_page = (int)__builtin_psvpage(&window69[0]);
			ratio1 = RATIO64_69*(1+RATIOF_P69*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_69*RATIO64_69*(1+RATIOF_P69*PWR_ERROR_COMPENS*Delta_F);
			break;
		case 70:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_70pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window70[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_70pt[0]);
			window_page = (int)__builtin_psvpage(&window70[0]);
			ratio1 = RATIO64_70*(1+RATIOF_P70*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_70*RATIO64_70*(1+RATIOF_P70*PWR_ERROR_COMPENS*Delta_F);
			break;
		case 71:
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_71pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window71[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_71pt[0]);
			window_page = (int)__builtin_psvpage(&window71[0]);
			ratio1 = RATIO64_71*(1+RATIOF_P70*RMS_ERROR_COMPENS*Delta_F);
			ratio2 = RATIO64_71*RATIO64_71*(1+RATIOF_P70*PWR_ERROR_COMPENS*Delta_F);
			break;								
		default : 
			table_pointer = (int*)__builtin_psvoffset(&cos_sin_64pt[0]);
			window_pointer = (int*)__builtin_psvoffset(&window64[0]);
			table_page = (int)__builtin_psvpage(&cos_sin_64pt[0]);
			window_page = (int)__builtin_psvpage(&window64[0]);
			ratio1 = 1+RATIOF_P64*RMS_ERROR_COMPENS*Delta_F;
			ratio2 = 1+RATIOF_P64*PWR_ERROR_COMPENS*Delta_F;
	}	
	
//	KF = 1+(gds.data.Frequency-50.0)*coeff_freq;
	KF = 1+(gds.data.Frequency-STD_FREQ)*coeff_freq;
//	KF = 1;			
	// 	detect_phase_order(table_pointer, table_page);
		
	// now calculate U/V/W each phase parameter respectively
	// including - DC offset of current channel and voltage channel, RMS voltage, RMS current, 
	// and HD value(Harmonics of current and voltage channel)
	// and each phase's active power, reactive power, apparent power, power factor
	for(cnt = 0; cnt < 3; cnt++)
	{
		//*****************************************************************************************************************
		// processing current channel firstly
	
		//------------ pre-processing the data -----------------		
		//DFTPreProcessCnt1 = Data_Preprocessing(length, (int*)&voltage_sample[cnt][0]);
		DFTPreProcessCnt1 = 0;
		//------------ adding the qusi-synchronous window ------------
		qusi_syn_wnd(DataNum_Cycle3, (int*)&voltage_sample[cnt][0],DataStart, (int*)&voltage_sample[cnt][BUF_SIZE-1], window_pointer, window_page,(int*)&data_copy[0]);
		//------------ DFT Transform --------------------
		//get DFT transform, store every order's real/image part value into DFTOut_V[i], notes that DFTOut_V[0] is DC value
		DFT(smp_pnt, (int*)&data_copy[0], (int*)&DFTOut_V[0].real, table_pointer, table_page);
		//----------- get amplitude --------------------
		//calculate the amplitude of every order, store into DFTMagnitude[i]
		ComputeMagnitude((int*)&DFTOut_V[0].real, &DFTMagnitude[0], 32, &amplitude);
	
	/*		//------------ calculate DC offset -------------
		tempValue = DFTOut_V[0].real;
		tempValue = tempValue*ratio/8;
		temp = (int)tempValue;
		//if(DFTPreProcessCnt1)		//remember that during pre-processing, we enlarge the data, now we should adjust it
		//	temp = temp >> DFTPreProcessCnt1;
		//update the DC offset
		ZeroValueCh[cnt*2] += (int)temp;	
	*/
	
		//---------- calculate RMS voltage -------------
		//if(DFTPreProcessCnt1)		//remember that during pre-processing, we enlarge the data, now we should adjust it
		//	amplitude = amplitude >> DFTPreProcessCnt1*2;
		PhaseVoltage[cnt] = sqrt((float)amplitude)*32*ratio1*Coeff.data.linear.V_channel[cnt];	//as the result was divide by 1024 in computeMagnitude(),  
															//so here we multiply with sqrt(1024)=32 for compensation	

		//------------ harmonic ------------------
		//Calculate harmonic, the 1st value (harmonicMag[x][0])is base value
		ComputeHarmonic(&DFTMagnitude[0], &harmonicMag[cnt*2][0], 32+1);	// Calculate distortion
		gds.data.TotalHarmonic.voltage[cnt] = ((float)harmonicMag[cnt*2][31])/10.0;			// calculate THD, THD was stored in the last unit
	
	
		//*****************************************************************************************************************
		// now processing current channel
	
		//---------pre-processing the data----------		
		//DFTPreProcessCnt2 = Data_Preprocessing(length, (int*)&current_sample[cnt][0]);
		DFTPreProcessCnt2 = 0;
		//---------adding the qusi-synchronous window---------------
		qusi_syn_wnd(DataNum_Cycle3, (int*)&current_sample[cnt][0],DataStart, (int*)&current_sample[cnt][BUF_SIZE-1], window_pointer, window_page,(int*)&data_copy[0]);
		//--------- DFT transform ------------
		//get DFT transform, store every order's real/image part value into DFTOut_V[i], notes that DFTOut_V[0] is DC value
		DFT(smp_pnt, (int*)&data_copy[0], (int*)&DFTOut_I[0].real, table_pointer, table_page);
		//--------- get amplitude ------------
		//calculate the amplitude of every order, store into DFTmagnitude[i]
		ComputeMagnitude((int*)&DFTOut_I[0].real, (long*)&DFTMagnitude[0], 32,&amplitude);
		
		if(amplitude>128)
			mag_sft_cnt = 10;
		else	//calculate again without left shift amplitude value before store
		{
		 	mag_sft_cnt = 0;	
		 	ComputeSmallMagnitude((int*)&DFTOut_I[0].real, (long*)&DFTMagnitude[0], 32,&amplitude);
		}	 
		
	/*		//--------- calculate DC offset -----------
		tempValue = DFTOut_I[0].real;
		tempValue = tempValue*ratio/8;
		temp = (int)tempValue;
		if(DFTPreProcessCnt2)			//remember that during pre-processing, we enlarge the data, now we should adjust it
			temp = temp >> DFTPreProcessCnt2;
		//update the DC offset
		ZeroValueCh[cnt*2+1] += (int)temp;	
	*/
	
		//---------- calculate RMS Current -----------
		//remember that during pre-processing, we enlarge the data, now we should right shift to adjust it
		//and we use gain control in the current channel,during calcualtion, we need to adjust the result 
		//according to the present gain value
		DFTPreProcessCnt2 = DFTPreProcessCnt2 + phase_gain[cnt];		
		temp = DFTPreProcessCnt2*2;	//we need to multiply with 2 because amplitude value is a square value 
		temp = mag_sft_cnt-temp;	//as the result was divide by 1024 in computeMagnitude(), or not divide in computeMagnitude()  
									//so we must the shift value for compensation during calculate the RMS value	
									//so we merge with the right shift adjustmet to guarantee the precision 
		tempValue = 1;
		if(temp<=0)		//still need right shift
		{
			temp = -temp;
			amplitude = amplitude >> temp;			
		}
		else// if(temp>0)
		{	
			// need to prevent overflow
			// still need to left shift
			// for examples:
			//				sqrt(amplitude*4) = sqrt(amplitude)*2; 
			//				sqrt(amplitude*2) = sqrt(amplitude/2)*2;
			if(temp&1)		//if need to shift even bits, then we right shift the value
			{				//and increase a bit to the left shift counter
				amplitude = amplitude >> 1;
				temp++;
			}
			
			// calculate the multiply value after the sqrt() operation
			temp = temp>>1;
			while(temp>0)
			{
				tempValue = tempValue*2;
				temp = temp--;
			}
		}
	
		if(phase_gain[cnt]==0)		
			PhaseCurrent[cnt] = sqrt((float)amplitude)*tempValue*ratio1*Coeff.data.linear.C_channel[1][cnt]; 
		else
			PhaseCurrent[cnt] = sqrt((float)amplitude)*tempValue*ratio1*Coeff.data.linear.C_channel[0][cnt]; 
		
	//****************************** harmonic of current ******************************************************
		//Calculate harmonic, the 1st value (harmonicMag[x][0])is base value
			if(PhaseCurrent[cnt]>0.02*Ib)	
				ComputeHarmonic(&DFTMagnitude[0], &harmonicMag[cnt*2+1][0], 32+1);	// Calculate distortion
				
			gds.data.TotalHarmonic.current[cnt] = ((float)harmonicMag[cnt*2+1][31])/10.0;
	
	//********************************  phase power *****************************************************************
			// now calculate the active power, re-active power, apparent power and the power factor
			ComputePower((int*)DFTOut_V, (int*)DFTOut_I, (int*)&power, 31);
			//DFTPreProcessCnt2 = DFTPreProcessCnt2 + DFTPreProcessCnt1;			
			
			//adjust the value to compensate the pre-processing if necessary
			if(DFTPreProcessCnt2)
			{
				power[0] = power[0] >> 	DFTPreProcessCnt2;	//fundemental active power
				power[1] = power[1] >> 	DFTPreProcessCnt2;	//total harmonic active power
				power[2] = power[2] >> 	DFTPreProcessCnt2;  //fundemental reactive power
				power[3] = power[3] >> 	DFTPreProcessCnt2;	//total harmonic reactive power		
				
			}
	
			//adjust the value to compensate the qusai-synchronous window 
			//adjust the value to compensate the linear transform system
			fundemental_active_pwr[cnt] = ((float)(power[0]))*ratio2;
			fundemental_reactive_pwr[cnt] = ((float)(power[2]))*ratio2;
			harmonic_active_pwr[cnt] = ((float)(power[1]))*ratio2;
			harmonic_reactive_pwr[cnt] = ((float)(power[3]))*ratio2;
			
			if(work_mode)//if under measurement mode
			{
				//adjust the value to compensate the current region of CT
				if(PhaseCurrent[cnt] > IRegion6*1.05)//>2.0Ib
				{		
					//tempValue = (PhaseCurrent[cnt]-IRegion6)/(IRegion6-IRegion5);
					k1 = Coeff.data.region[6].K1[cnt];
					k2 = Coeff.data.region[6].K2[cnt];
					suffix = 6;
				}			
				else if(PhaseCurrent[cnt] > IRegion5*1.05)//2.0> I >1.0Ib
				{		
					//tempValue = (PhaseCurrent[cnt]-IRegion5)/(IRegion6-IRegion5);
					k1 = Coeff.data.region[5].K1[cnt];
					k2 = Coeff.data.region[5].K2[cnt];
					suffix = 6;
				}			
				else if(PhaseCurrent[cnt] > IRegion4*1.05)//1.0> I >0.50Ib
				{		
					tempValue = (PhaseCurrent[cnt]-IRegion4)/(IRegion5-IRegion4);
					k1 = Coeff.data.region[4].K1[cnt];
					k2 = Coeff.data.region[4].K2[cnt];
					suffix = 5;
				}					
				else if(PhaseCurrent[cnt] > IRegion3*1.1)//0.50> I >0.20Ib
				{		
					tempValue = (PhaseCurrent[cnt]-IRegion3)/(IRegion4-IRegion3);
					k1 = Coeff.data.region[3].K1[cnt];
					k2 = Coeff.data.region[3].K2[cnt];
	
					if(phase_gain[cnt]!=0)		
						suffix = 3;
					else	
						suffix = 4;					
				}
				else if(PhaseCurrent[cnt] > IRegion2*1.1)//0.20> I >0.10Ib
				{		
					tempValue = (PhaseCurrent[cnt]-IRegion2)/(IRegion3-IRegion2);
					k1 = Coeff.data.region[2].K1[cnt];
					k2 = Coeff.data.region[2].K2[cnt];
					if(phase_gain[cnt]!=0)		
						suffix = 3;
					else	
						suffix = 4;				
				}
				else if(PhaseCurrent[cnt] > IRegion1*1.1)// 0.10> I >0.05Ib
				{
					tempValue = (PhaseCurrent[cnt]-IRegion1)/(IRegion2-IRegion1);
					k1 = Coeff.data.region[1].K1[cnt];
					k2 = Coeff.data.region[1].K2[cnt];
					suffix = 2;				
				}
				else if(PhaseCurrent[cnt] > IRegion0*1.1)//0.05> I >0.02Ib
				{
					tempValue = (PhaseCurrent[cnt]-IRegion0)/(IRegion1-IRegion0);
					k1 = Coeff.data.region[0].K1[cnt];
					k2 = Coeff.data.region[0].K2[cnt];
					suffix = 1;				
				}
				else //<0.02Ib
				{
					tempValue = (PhaseCurrent[cnt]-IRegion0)/(IRegion1-IRegion0);
					k1 = Coeff.data.region[0].K1[cnt];
					k2 = Coeff.data.region[0].K2[cnt];
					suffix = 0;
				}
	
				if(suffix==0)
				{
					k1 += (Coeff.data.region[1].K1[cnt] - Coeff.data.region[0].K1[cnt])*tempValue;
					k2 += (Coeff.data.region[1].K2[cnt] - Coeff.data.region[0].K2[cnt])*tempValue;
				}
				else if(suffix<6)
				{
					k1 += (Coeff.data.region[suffix].K1[cnt] - Coeff.data.region[suffix-1].K1[cnt])*tempValue;
					k2 += (Coeff.data.region[suffix].K2[cnt] - Coeff.data.region[suffix-1].K2[cnt])*tempValue;
				}
			}
			else
			{
				//adjust the value to compensate the current region of CT
				if(PhaseCurrent[cnt] > IRN56)// I >1.5Ib			condition = 2.0Ib
				{		
					k1 = Coeff.data.region[6].K1[cnt];
					k2 = Coeff.data.region[6].K2[cnt];
					suffix = 6;
				}			
				else if(PhaseCurrent[cnt] > IRN45)// I >0.750Ib   condition = 1.0Ib
				{		
					k1 = Coeff.data.region[5].K1[cnt];
					k2 = Coeff.data.region[5].K2[cnt];
					suffix = 5;
				}					
				else if(PhaseCurrent[cnt] > IRN34)// I >0.30Ib    condition = 0.5Ib
				{		
					k1 = Coeff.data.region[4].K1[cnt];
					k2 = Coeff.data.region[4].K2[cnt];
					
					if(phase_gain[cnt]!=0)		
						suffix = 3;
					else	
						suffix = 4;									
				}
				else if(PhaseCurrent[cnt] > IRN23)// I >0.15Ib	 condition = 0.2Ib
				{		
					k1 = Coeff.data.region[3].K1[cnt];
					k2 = Coeff.data.region[3].K2[cnt];	

					if(phase_gain[cnt]!=0)		
						suffix = 3;
					else	
						suffix = 4;											
				}
				else if(PhaseCurrent[cnt] > IRN12)// I >0.075Ib	 condition = 0.1Ib
				{
					k1 = Coeff.data.region[2].K1[cnt];
					k2 = Coeff.data.region[2].K2[cnt];
					suffix = 2;				
				}
				else if(PhaseCurrent[cnt] > IRN01)// I >0.03Ib	condition = 0.05Ib
				{
					k1 = Coeff.data.region[1].K1[cnt];
					k2 = Coeff.data.region[1].K2[cnt];
					suffix = 1;
				}
				else //condition = 0.02Ib
				{
					k1 = Coeff.data.region[0].K1[cnt];
					k2 = Coeff.data.region[0].K2[cnt];
					suffix = 0;
				}							
			}
			
			//k1, k2 's compensation for the frequency, refer to design note
			//ratio3 = -ratio3;
/*			if(PhaseCurrent[cnt] > 0.6*Ib)
			{
				tempValue = k1;
				tempValue1 = k2;
				k1 = k1 - ratio3*k2*k2;
				k2 = k2 + ratio3*tempValue*tempValue1;
			}
*/
			
//			if(cnt==0)
//			 suffix1 = suffix;
			 		
	//********************** handle active energy that cumulate in time domain ***********************
			if(phase_gain[cnt]==0)
			tempValue = 1;
			else if(phase_gain[cnt]==1)
			tempValue = 0.5;//1/2;
			else if(phase_gain[cnt]==3)
			tempValue = 0.125;//1/8;
			else if(phase_gain[cnt]==4)
			tempValue = 0.0625;//1/16;
			
			cycle_energy[cnt] = cycle_energy[cnt]*tempValue*0.5; // x0.5 because energy cumulation in 128 point per cycle			
			cycle_energy[cnt] = cycle_energy[cnt]*Coeff.data.region[suffix].KP[cnt]*KF;
			tempValue = (fundemental_reactive_pwr[cnt]+ harmonic_reactive_pwr[cnt])*Coeff.data.region[suffix].KP[cnt]*0.5*KF;
			tempValue = tempValue*DataNum_Cycle3; // tempTime; //reactive power energy
						
			if(pulse_generator.EnergyCumulateMode==0) //cumulate energy in active energy mode
			{		
				cycle_energy[cnt] = k1*cycle_energy[cnt];
				cycle_energy[cnt] += k2*tempValue;
//				cycle_energy[cnt] = cycle_energy[cnt]*KF;
			}
			else // cumulate energy in apparent energy mode
			{
				cycle_energy[cnt] = cycle_energy[cnt]*cycle_energy[cnt];			
				tempValue = tempValue*tempValue;
				cycle_energy[cnt]+=tempValue;
				cycle_energy[cnt] = sqrt(cycle_energy[cnt]);
			}			
	
	//************************ calculate active/reactive power for fundemantal and harmonic ********************					
			tempValue = fundemental_active_pwr[cnt];
			tempValue1 = harmonic_active_pwr[cnt];	
					
			fundemental_active_pwr[cnt] = k1*fundemental_active_pwr[cnt];
			fundemental_active_pwr[cnt] += k2*fundemental_reactive_pwr[cnt];
			fundemental_reactive_pwr[cnt] = k1*fundemental_reactive_pwr[cnt];
			fundemental_reactive_pwr[cnt] -= k2*tempValue;	
					
			harmonic_active_pwr[cnt] = k1*harmonic_active_pwr[cnt];					
			harmonic_active_pwr[cnt] += k2*harmonic_reactive_pwr[cnt];
			harmonic_reactive_pwr[cnt] = k1*harmonic_reactive_pwr[cnt];					
			harmonic_reactive_pwr[cnt] -= k2*tempValue1;

			fundemental_active_pwr[cnt] = fundemental_active_pwr[cnt]*Coeff.data.region[suffix].KP[cnt]*0.5*KF;
		//	fundemental_active_pwr[cnt] = fundemental_active_pwr[cnt]*KF;			
			harmonic_active_pwr[cnt] = harmonic_active_pwr[cnt]*Coeff.data.region[suffix].KP[cnt]*0.5*KF;
		//	harmonic_active_pwr[cnt] = harmonic_active_pwr[cnt]*KF;
			fundemental_reactive_pwr[cnt] = fundemental_reactive_pwr[cnt]*Coeff.data.region[suffix].KP[cnt]*0.5*KF; 
			harmonic_reactive_pwr[cnt] = harmonic_reactive_pwr[cnt]*Coeff.data.region[suffix].KP[cnt]*0.5*KF;
	
	//**************************** total phase power and power factor *********************************************
			PhaseActPwr[cnt] = fundemental_active_pwr[cnt] + harmonic_active_pwr[cnt];
			PhaseReactPwr[cnt] = fundemental_reactive_pwr[cnt] + harmonic_reactive_pwr[cnt];
	
			//update the RMS voltage, current data
			//update the active, reactive power data, apparent power and power factor
			tempValue = sqrt(PhaseActPwr[cnt]*PhaseActPwr[cnt] + PhaseReactPwr[cnt]*PhaseReactPwr[cnt]);
			if(tempValue<10)
				tempValue1 = 1;
			else 
				tempValue1 = PhaseActPwr[cnt]/tempValue;
	
			PhaseApparentPwr[cnt] = tempValue;
			PhasePwrFactor[cnt] = tempValue1;
			
		//	PhasePwrFactor[cnt] = cycle_energy[cnt]/DataNum_Cycle3;
		//	PhasePwrFactor[cnt] = suffix;
			if(PhaseApparentPwr[cnt]<START_UP_POWER)
			{
				fundemental_active_pwr[cnt]=0;
				fundemental_reactive_pwr[cnt]=0;
				harmonic_active_pwr[cnt]=0;
				harmonic_reactive_pwr[cnt]=0;
				PhaseActPwr[cnt]=0;
				PhaseReactPwr[cnt]=0; 		
				PhaseApparentPwr[cnt]=0;
				PhasePwrFactor[cnt]=1;	
				
				cycle_energy[cnt] = 0;
			}	
	} // End of  for(cnt = 0; cnt < 3; cnt++)	
	 

 //*************************** update the calcuation result to data buffer ************************************
	SET_CPU_IPL(4); 					//disable interrupt from UART when update the data	
	for(cnt=0;cnt<3;cnt++)
	{
		gds.data.Rms.PhaseVoltage[cnt] = PhaseVoltage[cnt];
		gds.data.Rms.PhaseCurrent[cnt] = PhaseCurrent[cnt];
		gds.data.Power.Fundemental_ActPwr[cnt]= fundemental_active_pwr[cnt];
		gds.data.Power.Fundemental_ReactPwr[cnt]= fundemental_reactive_pwr[cnt];
		gds.data.Power.Harmonic_ActPwr[cnt]= harmonic_active_pwr[cnt];
		gds.data.Power.Harmonic_ReactPwr[cnt]= harmonic_reactive_pwr[cnt];
		gds.data.Power.PhasePwr[cnt].ActPwr = PhaseActPwr[cnt];
		gds.data.Power.PhasePwr[cnt].ReactPwr = PhaseReactPwr[cnt]; 		
		gds.data.Power.PhasePwr[cnt].ApparentPwr = PhaseApparentPwr[cnt];
		gds.data.Power.PhasePwr[cnt].PowerFactor = PhasePwrFactor[cnt];

		
		if(PhaseVoltage[cnt]<LOST_PHASE_VOTAGE)
		{
			if(cnt==0)
			 gds.data.PowerState.PhaseA = 2;
			else if(cnt==1)
			 gds.data.PowerState.PhaseB = 2;
			else
			 gds.data.PowerState.PhaseC = 2;
			 
			gds.data.PowerState.PhaseOrderVoltage = 1;
		}
		else if(PhaseVoltage[cnt]<LOW_VOLTAGE_LIMIT)
		{
			if(cnt==0)
			 gds.data.PowerState.PhaseA = 1;
			else if(cnt==1)
			 gds.data.PowerState.PhaseB = 1;
			else
			 gds.data.PowerState.PhaseC = 1;
			
			gds.data.PowerState.PhaseOrderVoltage = 1; 			
		}
		else
		{
			if(cnt==0)
			 gds.data.PowerState.PhaseA = 0;
			else if(cnt==1)
			 gds.data.PowerState.PhaseB = 0;
			else
			 gds.data.PowerState.PhaseC = 0;				
		}
		
	}	
		
//*************************** total active/inactive power,apparent power, power factor ***********************
	gds.data.Power.TotalActivePwr = gds.data.Power.PhasePwr[0].ActPwr + 
									gds.data.Power.PhasePwr[1].ActPwr + 
									gds.data.Power.PhasePwr[2].ActPwr;
	gds.data.Power.TotalReactivePwr = gds.data.Power.PhasePwr[0].ReactPwr + 
									gds.data.Power.PhasePwr[1].ReactPwr + 
									gds.data.Power.PhasePwr[2].ReactPwr;
	gds.data.Power.TotalApparentPwr =  gds.data.Power.PhasePwr[0].ApparentPwr + 
									gds.data.Power.PhasePwr[1].ApparentPwr + 
									gds.data.Power.PhasePwr[2].ApparentPwr;

	if(gds.data.Power.TotalApparentPwr<8)
		gds.data.Power.TotalPwrFactor = 1;
	else
		gds.data.Power.TotalPwrFactor = gds.data.Power.TotalActivePwr/gds.data.Power.TotalApparentPwr;

	SET_CPU_IPL(0); 					//disable interrupt from UART	



//****************************** handle energy data and pulse ***********************************	
//		tempTime = DataNum_Cycle3*ENGY_MULTIPLIER;			//ENGY_MULTIPLIER = sample period/3600
		tempValue = gds.data.Power.TotalReactivePwr; 	//calculate the inactive energy of last two cycles
//		tempValue = 1856.18;
		step_culmulation = tempValue*ENGY_MULTIPLIER;	//calculate the reactive energy culmulation during one sample period
		tempValue = tempValue*tempTime;					//calculate the energy culmulation during (length+1) sample period
// four quadrant inactive energy & energy	
	    if((gds.data.Power.TotalActivePwr>0.0)&&(gds.data.Power.TotalReactivePwr>0.0))
	   	{
		    gds.data.Energy.Q1 += tempValue;
			gds.data.Energy.Forward_ReActive +=tempValue;
		}
	   	else if((gds.data.Power.TotalActivePwr<0.0)&&(gds.data.Power.TotalReactivePwr>0.0))
		{
			gds.data.Energy.Q2 += tempValue; 
			gds.data.Energy.Forward_ReActive +=tempValue;
		}
	   	else if((gds.data.Power.TotalActivePwr<0.0)&&(gds.data.Power.TotalReactivePwr<0.0))
		{
		    gds.data.Energy.Q3 += tempValue; 
			gds.data.Energy.Reverse_ReActive +=tempValue;
		}
	  	else if((gds.data.Power.TotalActivePwr>0.0)&&(gds.data.Power.TotalReactivePwr<0.0))
		{
		    gds.data.Energy.Q4 += tempValue; 
			gds.data.Energy.Reverse_ReActive +=tempValue;
		}

	// ********************** handle reactive energy pulse ********************************	
		SET_CPU_IPL(6); 					//disable interrupt 		
		reactive_energy_integrate = reactive_energy_integrate + tempValue;
		SET_CPU_IPL(0); 	
		tempValue1 = reactive_energy_integrate + tempValue*1.5;	
		if(!flag.bits.HandleReactPulse)
		{
			if((tempValue1>integrate_limitation)||(tempValue1<-integrate_limitation))
			{
				if(tempValue1>0)
				{
					pulse_threshold1 = (integrate_limitation - reactive_energy_integrate)*2.0/step_culmulation;
					flag.bits.ReactPwrDir = FOREWARD;
				}
				else
				{
					pulse_threshold1 = -(integrate_limitation + reactive_energy_integrate)*2.0/step_culmulation;
					flag.bits.ReactPwrDir = BACKWARD;
				}			
				
				SET_CPU_IPL(6); 					//disable interrupt 
				flag.bits.HandleReactPulse = 1;										
				trigger_count1 = 2*(LeftDataNum-DataNum_Cycle3)+ flag.bits.temp_flag;
				SET_CPU_IPL(0); 					//disable interrupt					
			}
		}
	
	
	//*********************** handle active energy ************************************					
	// forward/reverse active energy
		tempValue = 0;
		for(i=0;i<3;i++)	//calculate the total active energy cumulation
		 tempValue += cycle_energy[i];
		tempValue = tempValue * ENGY_MULTIPLIER;
//		gds.data.Power.PhasePwr[0].PowerFactor = tempValue;		
	  	if(tempValue>0.0)	
		{	
			gds.data.Energy.Forward_Active +=tempValue;
			gds.data.Energy.Total_Active +=tempValue;
		}
		else
		{
			gds.data.Energy.Reverse_Active +=tempValue;
			gds.data.Energy.Total_Active -=tempValue;
		}
	
		//handle the active energy pulse output	
		
		SET_CPU_IPL(6); 					//disable interrupt 		
		energy_integrate = energy_integrate+tempValue;
		SET_CPU_IPL(0); 					//enable interrupt		
		tempValue1 = energy_integrate + tempValue*1.5;				
		if(!flag.bits.HandleActPulse)
		{
			if((tempValue1>integrate_limitation)||(tempValue1<-integrate_limitation))
			{
				if(tempValue1>0) 
				{
					// step_cumulation = tempValue/DataNum_Cycle3				
					pulse_threshold = ((integrate_limitation - energy_integrate)*2.0*DataNum_Cycle3/tempValue); 
					flag.bits.ActPwrDir = FOREWARD;	
				}
				else
				{
					pulse_threshold = -((energy_integrate+integrate_limitation)*2.0*DataNum_Cycle3/tempValue);
					flag.bits.ActPwrDir = BACKWARD;
				}			
				
				SET_CPU_IPL(6); 					//disable interrupt 
				flag.bits.HandleActPulse = 1;										
				trigger_count = 2*(LeftDataNum-DataNum_Cycle3) + flag.bits.temp_flag;
				SET_CPU_IPL(0); 					//enable interrupt 					
			}
		}


//*************************** frequency measurement ************************************
	gds.data.Frequency = measure_freq();

//	gds.data.Power.PhasePwr[0].PowerFactor = DataStart;		

	//update buffer pointer	
	DataStart = DataStart + DataNum_Cycle3;	
	if(DataStart >= BUF_SIZE)				// loop back to the begin of cycle buffer
	  DataStart = DataStart - BUF_SIZE;

	SET_CPU_IPL(6); 					//disable interrupt from UART when update the data	
	LeftDataNum = LeftDataNum - DataNum_Cycle3;
	SET_CPU_IPL(0); 					//disable interrupt from UART when update the data	

	T2_PRD = Fcy/(gds.data.Frequency*16);
	Delta_F = Delta_F*Delta_F;
	DataNum_Cycle3 = smp_pnt*3;		
}

unsigned char detect_phase_order(int* pointer,	int page)
{
	float phi_A, phi_B, phi_C;
	//calculate Phase A~C angle
	copy_data(71, (int*)&data_copy[0], (int*)&voltage_sample[0][0],DataStart,(int*)&voltage_sample[0][BUF_SIZE]);
	DFT_Fundamental(smp_pnt,(int*)&data_copy[0], (int*)&DFTOut_V[0].real, pointer, page, 1); 	//select U channel voltage
	phi_A = calculate_angle(DFTOut_V[0].real, DFTOut_V[0].imag);

	copy_data(71, (int*)&data_copy[0], (int*)&voltage_sample[1][0],DataStart,(int*)&voltage_sample[1][BUF_SIZE]);
	DFT_Fundamental(smp_pnt,(int*)&data_copy[0], (int*)&DFTOut_V[0].real, pointer, page, 1); 	//select U channel voltage
	phi_B = calculate_angle(DFTOut_V[0].real, DFTOut_V[0].imag);

	copy_data(71, (int*)&data_copy[0], (int*)&voltage_sample[2][0],DataStart,(int*)&voltage_sample[2][BUF_SIZE]);
	DFT_Fundamental(smp_pnt,(int*)&data_copy[0], (int*)&DFTOut_V[0].real, pointer, page, 1); 	//select U channel voltage
	phi_C = calculate_angle(DFTOut_V[0].real, DFTOut_V[0].imag);	

//	if(((phi_A>phi_C)&&(phi_A>phi_B)&&(phi_B>phi_C)) ||((phi_A<phi_B)&&(phi_B>phi_C)&&(phi_A<phi_C))||((phi_A>phi_B)&&(phi_B<phi_C)&&(phi_A<phi_C)))
	if(((phi_A<phi_C)&&(phi_A<phi_B)&&(phi_B<phi_C)) ||((phi_A<phi_B)&&(phi_B>phi_C)&&(phi_A>phi_C))||((phi_A>phi_B)&&(phi_B<phi_C)&&(phi_A>phi_C)))
	  gds.data.PowerState.PhaseOrderVoltage = 0;
	else
	  gds.data.PowerState.PhaseOrderVoltage = 1;	

	//calculate Phase A~C angle
	copy_data(71, (int*)&data_copy[0], (int*)&voltage_sample[0][0],DataStart,(int*)&voltage_sample[0][BUF_SIZE]);
	DFT_Fundamental(smp_pnt,(int*)&data_copy[0], (int*)&DFTOut_V[0].real, pointer, page, 1); 	//select U channel voltage
	phi_A = calculate_angle(DFTOut_V[0].real, DFTOut_V[0].imag);

	copy_data(71, (int*)&data_copy[0], (int*)&voltage_sample[1][0],DataStart,(int*)&voltage_sample[1][BUF_SIZE]);
	DFT_Fundamental(smp_pnt,(int*)&data_copy[0], (int*)&DFTOut_V[0].real, pointer, page, 1); 	//select U channel voltage
	phi_B = calculate_angle(DFTOut_V[0].real, DFTOut_V[0].imag);

	copy_data(71, (int*)&data_copy[0], (int*)&voltage_sample[2][0],DataStart,(int*)&voltage_sample[2][BUF_SIZE]);

	DFT_Fundamental(smp_pnt,(int*)&data_copy[0], (int*)&DFTOut_V[0].real, pointer, page, 1); 	//select U channel voltage
	phi_C = calculate_angle(DFTOut_V[0].real, DFTOut_V[0].imag);	
	
//	if(((phi_A>phi_C)&&(phi_A>phi_B)&&(phi_B>phi_C)) ||((phi_A<phi_B)&&(phi_B>phi_C)&&(phi_A<phi_C))||((phi_A>phi_B)&&(phi_B<phi_C)&&(phi_A<phi_C)))
	if(((phi_A<phi_C)&&(phi_A<phi_B)&&(phi_B<phi_C)) ||((phi_A<phi_B)&&(phi_B>phi_C)&&(phi_A>phi_C))||((phi_A>phi_B)&&(phi_B<phi_C)&&(phi_A>phi_C)))
	  gds.data.PowerState.PhaseOrderCurrent = 0;
	else
	  gds.data.PowerState.PhaseOrderCurrent = 1;	
}



void ComputeNeutralCurrent(void)
{
  long amplitude;
  float NeutralCurrent;
  amplitude = ComputeNeutralAmplitude(&neutral_current_sample[0], 64);
  NeutralCurrent = (float)(amplitude);
  NeutralCurrent = sqrt(NeutralCurrent/64.0);
  NeutralCurrent *= CURRENT_N_COEF;
  gds.data.Rms.NeutralCurrent = NeutralCurrent;	
  
  AD1CON1bits.ADON = 1;
  IEC0bits.AD1IE = 1;    
}

float calculate_angle(int real, int imag)
{
	float temp, Theta;
	
	//calculate the angle
	if(real==0)
	{
		 if(imag > 0)
		  Theta = PI/2;
		 else
		  Theta = 3*PI/2;
	}
	else 
	{
		 temp = (float)(imag)/(float)real;
		 Theta = atanf(temp);

		 if(real < 0)
			   Theta = PI + Theta;
		 else
		{
			  if(imag<0)
			   Theta = 2*PI + Theta;
		}
	}
	
	return Theta;
	
}


float calculate_freq(int real_1, int imag_1, int real_2, int imag_2, unsigned char smp_pnt)
{
/*-----------------------------------------------------------------------
	Function Name: calculate_freq()
	this routine calculate the frequcy from two cycles signal input
	delta_f = delta_theta * target_freqency / 2*pi
    frequency_measurement = target_frequency - delta_f;

	input:
			real_1   ---  the real part of first cycle1 signal after DFT transform
			imag_1   ---  the image part of first cycle1 signal after DFT transform
			real_2   ---  the real part of first cycle2 signal after DFT transform
			imag_2   ---  the image part of first cycle2 signal after DFT transform
			smp_pnt  ---  sample points per cycle
	return:
			(float) frequency value

	Design By:					 Jemmey Huang  CADC
	Last modification:			 Sep 28 / 2006			
----------------------------------------------------------------------*/	
	float Theta_1, Theta_2, delta, delta_f, freq;
	float temp;
	unsigned char temp1;	

	//calculate the angle of first cycle
	Theta_1 = calculate_angle(real_1, imag_1);
	
	//calculate the angle of second cycle
	Theta_2 = calculate_angle(real_2, imag_2);

	//calculate the angle shifting
	delta = Theta_2 - Theta_1;

	//as the angle shifting value is very small, so abs(delta) shoule be in the range +/- PI
	//so if find data out of the range, that means two scenarios:
	//Scenario 1: Theta_2 in the first quadrant, and Theta_1 in the four quadrant, then the delta will be about -(3/2)PI, 
	//            but the actual should be about (1/2)PI, so we need to add 2*PI to adjust the value
	//Scenario 2: Theta_2 in the four quadrant, and Theta_2 in the first quadrant, then the delta will be about (3/2)PI,
	//            but the actual should be about -(1/2)PI, so we need to substract 2*PI to adjust the value
	if(delta<-PI)			
	 delta = delta + PI + PI;
	else if(delta>PI)
	 delta = delta - PI - PI;

// Feb 15th, 2007 by Jerry Gao
// to adapt to 50Hz&60Hz
/*
	switch (smp_pnt)
	{
		case 58:	temp = 55.1724;
					break;
		case 59:	temp = 54.2373;
					break;
		case 60:	temp = 53.3333;
					break;
		case 61:	temp = 52.459;
					break;
		case 62:	temp = 51.6129;
					break;
		case 63:	temp = 50.7937;
					break;
		case 65:	temp = 49.2308;
					break;
		case 66:	temp = 48.4849;
					break;
		case 67:	temp = 47.7612;
					break;
		case 68:	temp = 47.0588;
					break;												
		case 69:	temp = 46.3768;
					break;
		case 70:	temp = 45.7143;
					break;	
		case 71:	temp = 45.0704;
					break;									
		default:	temp = 50.0;														
	}
*/
	temp1 = smp_pnt;
	if(temp1 < 58)
	{
		temp1 = 58;
	}
	else if(temp1 > 71)
	{
		temp1 = 71;
	}
//	else
//	{
		temp = Point2Frequency[temp1 - 58];
//	}
// end - Feb 15th, by Jerry Gao

	//calculate the frequency
	delta_f = delta/(2*PI/temp);
	freq = temp - delta_f;

	Delta_F = delta_f;
	
	return freq;
}



float measure_freq()	
{	
/*-----------------------------------------------------------------------
	Function Name: measure_freq()
	this routine measure the frequency of input three phase voltage signal
	this routine will detect a valid input channel firstly, then calculate an approximate frequency value
	by using the 64 point table, according to the approximate value, the routine will calculate the frequency again if necessary

	input:
			none
	return:
			(float) frequency value

	Design By:					 Jemmey Huang  CADC
	Last modification:			 Oct 8 / 2006			
----------------------------------------------------------------------*/
	int* pointer;
	int page;
	float frequency;
	unsigned long temp;
	int i;


	//now calculate the frequency
	//get DFT transform of 1st order signal, data from the DataCopy
	//calculate two consequencious cycles, then store the value into DFTOut_V[0], DFTOut_V[1]
	if((gds.data.Frequency>=48)&&(gds.data.Frequency<=52))
	{
		pointer = (int*)__builtin_psvoffset(&cos_sin_64pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_64pt[0]);
		smp_pnt = 64;
	}
	else if(gds.data.Frequency<48)
	{
		pointer = (int*)__builtin_psvoffset(&cos_sin_68pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_68pt[0]);
		smp_pnt = 68;
	}
	else
	{
		pointer = (int*)__builtin_psvoffset(&cos_sin_60pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_60pt[0]);
		smp_pnt = 60;		
	}
	
	copy_data(144, (int*)&data_copy[0], (int*)&voltage_sample[0][0],DataStart,(int*)&voltage_sample[0][BUF_SIZE]);
	DFT_Fundamental(smp_pnt,(int*)&data_copy[0], (int*)&DFTOut_V[0].real, pointer, page, 2);			//select U channel voltage
	temp = (long)DFTOut_V[0].real*(long)DFTOut_V[0].real + (long)DFTOut_V[0].imag*(long)DFTOut_V[0].imag;
	if(temp < 0x100000)		//if voltage amplitude of channel U less than a limit, select Channel V
	{
		copy_data(144, (int*)&data_copy[0], (int*)&voltage_sample[1][0],DataStart,(int*)&voltage_sample[1][BUF_SIZE]);
		DFT_Fundamental(smp_pnt, (int*)&data_copy[0], (int*)&DFTOut_V[0].real, pointer, page, 2);		//select V channel voltage
		temp = (long)DFTOut_V[0].real*(long)DFTOut_V[0].real + (long)DFTOut_V[0].imag*(long)DFTOut_V[0].imag;
		if(temp < 0x100000) //if voltage amplitude of channel V less than a limit, select Channel W
		{
			copy_data(144, (int*)&data_copy[0], (int*)&voltage_sample[2][0],DataStart,(int*)&voltage_sample[2][BUF_SIZE]);
			DFT_Fundamental(smp_pnt, (int*)&data_copy[0], (int*)&DFTOut_V[0].real, pointer, page, 2); 	//select W channel voltage
			temp = (long)DFTOut_V[0].real*(long)DFTOut_V[0].real + (long)DFTOut_V[0].imag*(long)DFTOut_V[0].imag;
			if(temp<0x100000)
				flag.bits.NoPower = 1;
			else
				flag.bits.NoPower = 0;
		}
		else
			flag.bits.NoPower = 0;
	}
	else
		flag.bits.NoPower = 0;

	if(flag.bits.NoPower)
	{
	 gds.data.PowerState.PhaseA = 2;
	 gds.data.PowerState.PhaseB = 2;
	 gds.data.PowerState.PhaseC = 2;

	 smp_pnt = 64;
	 Delta_F = 0;
	 return 50;
	} 
	 
	//now calculate the frequency under 64 point condition 
	frequency = calculate_freq(DFTOut_V[0].real, DFTOut_V[0].imag, DFTOut_V[1].real, DFTOut_V[1].imag, smp_pnt);

	//after calculation, we get a approximate frequency value
	//according to this approximate value, calculate the frequency again to get a precise frequency value

// Feb 15th, 2007 by Jerry Gao
// the following change was made to adapt 50Hz@60Hz
	if((frequency<FREQ_OF_M0_5)&&(frequency>FREQ_OF_A0_5))
//	if((frequency<50.4)&&(frequency>49.6))
	{
		//if frequency  between 51.2 and 50.4HZ, we will use 63 point to calculate the frequency again
		smp_pnt = 64;
		pointer = (int*)__builtin_psvoffset(&cos_sin_64pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_64pt[0]);
	}
	else if(frequency>FREQ_OF_M5_5)
//	else if(frequency>54.7048)
	{
		smp_pnt = 58;
		pointer = (int*)__builtin_psvoffset(&cos_sin_58pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_58pt[0]);
	}
	else if(frequency>FREQ_OF_M4_5)		
//	else if(frequency>53.7853)
	{
		//if frequency  high than 52HZ, we will use 59 point to calculate the frequency again
		smp_pnt = 59;
		pointer = (int*)__builtin_psvoffset(&cos_sin_59pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_59pt[0]);
	}	
	else if(frequency>FREQ_OF_M3_5)
//	else if(frequency>52.8962)
	{
		//if frequency  high than 52HZ, we will use 60 point to calculate the frequency again
		smp_pnt = 60;
		pointer = (int*)__builtin_psvoffset(&cos_sin_60pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_60pt[0]);
	}
	else if(frequency>FREQ_OF_M2_5)
//	else if(frequency>52.036)
	{
		//if frequency  high than 52HZ, we will use 61 point to calculate the frequency again
		smp_pnt = 61;
		pointer = (int*)__builtin_psvoffset(&cos_sin_61pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_61pt[0]);
	}
	else if(frequency>FREQ_OF_M1_5)
//	else if(frequency>51.2033)
	{	//if frequency high than 51.2HZ, we will use 62 point to calculate the frequency again
		smp_pnt = 62;
		pointer = (int*)__builtin_psvoffset(&cos_sin_62pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_62pt[0]);
	}
	else if(frequency>FREQ_OF_M0_5)
//	else if(frequency>50.3969)
	{
		//if frequency  between 51.2 and 50.4HZ, we will use 63 point to calculate the frequency again
		smp_pnt = 63;
		pointer = (int*)__builtin_psvoffset(&cos_sin_63pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_63pt[0]);
	}
	else if(frequency<FREQ_OF_A6_5)
//	else if(frequency<45.3924)
	{
		smp_pnt = 71;
		pointer = (int*)__builtin_psvoffset(&cos_sin_71pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_71pt[0]);
	}
	else if(frequency<FREQ_OF_A5_5)		
//	else if(frequency<46.0456)
	{
		smp_pnt = 70;
		pointer = (int*)__builtin_psvoffset(&cos_sin_70pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_70pt[0]);
	}			
	else if(frequency<FREQ_OF_A4_5)
//	else if(frequency<46.7178)
	{//if frequency  low than 48.12HZ, we will use 69 point to calculate the frequency again
		smp_pnt = 69;
		pointer = (int*)__builtin_psvoffset(&cos_sin_69pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_69pt[0]);
	}
	else if(frequency<FREQ_OF_A3_5)
//	else if(frequency<47.4099)
	{//if frequency  low than 48.12HZ, we will use 68 point to calculate the frequency again
		smp_pnt = 68;
		pointer = (int*)__builtin_psvoffset(&cos_sin_68pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_68pt[0]);
	}
	else if(frequency<FREQ_OF_A2_5)
//	else if(frequency<48.1231)
	{//if frequency  low than 48.12HZ, we will use 67 point to calculate the frequency again
		smp_pnt = 67;
		pointer = (int*)__builtin_psvoffset(&cos_sin_67pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_67pt[0]);
	}
	else if(frequency<FREQ_OF_A1_5)
//	else if(frequency<48.8579)
	{ //if frequency  between 48.12 and 48.86HZ, we will use 66 point to calculate the frequency again
		smp_pnt = 66;
		pointer = (int*)__builtin_psvoffset(&cos_sin_66pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_66pt[0]);
	}
	else if(frequency<FREQ_OF_A0_5)
//	else if(frequency<49.6154)
	{	//if frequency  between 48.86 and 49.6HZ, we will use 65 point to calculate the frequency again
		smp_pnt = 65;
		pointer = (int*)__builtin_psvoffset(&cos_sin_65pt[0]);
		page = (int)__builtin_psvpage(&cos_sin_65pt[0]);
	}
	
	DFT_Fundamental(smp_pnt, (int*)&data_copy[0], (int*)&DFTOut_V[0].real, pointer, page, 2);	
	frequency = calculate_freq(DFTOut_V[0].real, DFTOut_V[0].imag, DFTOut_V[1].real, DFTOut_V[1].imag, smp_pnt);
	
	//re-adjust the sample point value to increase accurcy
	//smp_pnt is a global variable, it will be use in next calculation
	if((frequency < FREQ_OF_M0_5)&&(frequency > FREQ_OF_A0_5))
		smp_pnt = 64;
	else if(frequency > FREQ_OF_M5_5)
		smp_pnt = 58;
	else if(frequency > FREQ_OF_M4_5)
		smp_pnt = 59;
	else if(frequency > FREQ_OF_M3_5)
		smp_pnt = 60;
	else if(frequency > FREQ_OF_M2_5)
		smp_pnt = 61;
	else if(frequency > FREQ_OF_M1_5)
		smp_pnt = 62;
	else if(frequency > FREQ_OF_M0_5)
		smp_pnt = 63;
	else if(frequency < FREQ_OF_A6_5)
		smp_pnt = 71;
	else if(frequency < FREQ_OF_A5_5)
		smp_pnt = 70;
	else if(frequency < FREQ_OF_A4_5)
		smp_pnt = 69;
	else if(frequency < FREQ_OF_A3_5)
		smp_pnt = 68;
	else if(frequency < FREQ_OF_A2_5)
		smp_pnt = 67;
	else if(frequency < FREQ_OF_A1_5)
		smp_pnt = 66;
	else if(frequency < FREQ_OF_A0_5)
		smp_pnt = 65;

/*
	if((frequency<50.3969)&&(frequency>49.6154))
		smp_pnt = 64;
	else if(frequency>54.7048)
		smp_pnt = 58;
	else if(frequency>53.7853)
		smp_pnt = 59;
	else if(frequency>52.896)
		smp_pnt = 60;
	else if(frequency>52.036)
		smp_pnt = 61;
	else if(frequency>51.2033)
		smp_pnt = 62;
	else if(frequency>50.3969)
		smp_pnt = 63;
	else if(frequency<45.3924)
		smp_pnt = 71;
	else if(frequency<46.0456)
		smp_pnt = 70;		
	else if(frequency<46.7178)
		smp_pnt = 69;
	else if(frequency<47.4099)
		smp_pnt = 68;		
	else if(frequency<48.1231)
		smp_pnt = 67;
	else if(frequency<48.8579)
		smp_pnt = 66;
	else if(frequency<49.6154)
		smp_pnt = 65;
*/
// change end, Feb 15th, by Jerry Gao
	return frequency;
}




	

void Update_Gain(void)
{
	unsigned int temp_gain, temp_gain1;
	unsigned int cnt;
	
	for(cnt=0;cnt<3;cnt++)
	{	
		if(gds.data.Rms.PhaseCurrent[cnt]<GAIN_CTL_16)
			temp_gain=4;	//power(2,4) = 16, gain=16
		else
			temp_gain=0;	//power(2,0) = 1, gain=1		
		
		temp_gain1 = phase_gain[cnt];	
		if(temp_gain!=temp_gain1)
		{
			if(temp_gain>temp_gain1)
			{
				if(gds.data.Rms.PhaseCurrent[cnt]<GAIN_CTL_16_DN)
				temp_gain1	= temp_gain;					
			}
			else //temp_gain < phase_gain
			{
				if(gds.data.Rms.PhaseCurrent[cnt]>GAIN_CTL_16_UP)
					temp_gain1	= temp_gain;									
			}
	
			if(phase_gain[cnt]!= temp_gain1);
			{
				phase_gain[cnt]= temp_gain1;
				if(cnt==0)
					gain_control(PHASE_A, phase_gain[cnt]);
				else if(cnt==1)
					gain_control(PHASE_B, phase_gain[cnt]);
				else if(cnt==2)
					gain_control(PHASE_C, phase_gain[cnt]);
			}	
		}
	}	
}


