//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jerry Gao									 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *	File name:	   Calcu.h											 *
// * 	File description: header file for calcu.c				         *
// **********************************************************************/

#define _CALCULATE_H

#undef EXT
#undef LOCAL_GLOBLE
#ifdef _CALCULATE_C
  #define EXT
  #define LOCAL_GLOBLE
#else
  #define EXT extern
#endif


#ifdef LOCAL_GLOBLE
//===========================================================================
//-------------Local defines, variables  ------------------------------------
//===========================================================================

//------------------------------ DEFINES ------------------------------------
//this define the compensation ratio for the calculation 
//the error come from the sample point different to the regular condition - 64 point under 50HZ
#define RATIO64_58 (64.0/58.0)*(64.0/58.0)*(64.0/58.0)
#define RATIO64_59 (64.0/59.0)*(64.0/59.0)*(64.0/59.0)
#define RATIO64_60 (64.0/60.0)*(64.0/60.0)*(64.0/60.0)
#define RATIO64_61 (64.0/61.0)*(64.0/61.0)*(64.0/61.0)
#define RATIO64_62 (64.0/62.0)*(64.0/62.0)*(64.0/62.0)
#define RATIO64_63 (64.0/63.0)*(64.0/63.0)*(64.0/63.0)
#define RATIO64_65 (64.0/65.0)*(64.0/65.0)*(64.0/65.0)
#define RATIO64_66 (64.0/66.0)*(64.0/66.0)*(64.0/66.0)
#define RATIO64_67 (64.0/67.0)*(64.0/67.0)*(64.0/67.0)
#define RATIO64_68 (64.0/68.0)*(64.0/68.0)*(64.0/68.0)
#define RATIO64_69 (64.0/69.0)*(64.0/69.0)*(64.0/69.0)
#define RATIO64_70 (64.0/70.0)*(64.0/70.0)*(64.0/70.0)
#define RATIO64_71 (64.0/71.0)*(64.0/71.0)*(64.0/71.0)

// Feb 15th, 2007 by Jerry Gao
// Add defines and one array to adapt to 50hz&60Hz
#define STD_FREQ 	50.0
//#define SAMP_FREQ	3200.0	// for 64pnts@50Hz
//#define SAMP_FREQ	3840.0	// for 64pnts@60Hz
#define STD_PNTS_F	64.0
#define SAMP_FREQ	STD_FREQ*STD_PNTS_F	
//#define	FREQ_OF_STD	50.0

#define	FREQ_OF_M6	SAMP_FREQ/(STD_PNTS_F - 6.0)
#define	FREQ_OF_M5	SAMP_FREQ/(STD_PNTS_F - 5.0)
#define	FREQ_OF_M4	SAMP_FREQ/(STD_PNTS_F - 4.0)
#define	FREQ_OF_M3	SAMP_FREQ/(STD_PNTS_F - 3.0)
#define	FREQ_OF_M2	SAMP_FREQ/(STD_PNTS_F - 2.0)
#define	FREQ_OF_M1	SAMP_FREQ/(STD_PNTS_F - 1.0)
#define	FREQ_OF_A1	SAMP_FREQ/(STD_PNTS_F + 1.0)
#define	FREQ_OF_A2	SAMP_FREQ/(STD_PNTS_F + 2.0)
#define	FREQ_OF_A3	SAMP_FREQ/(STD_PNTS_F + 3.0)
#define	FREQ_OF_A4	SAMP_FREQ/(STD_PNTS_F + 4.0)
#define	FREQ_OF_A5	SAMP_FREQ/(STD_PNTS_F + 5.0)
#define	FREQ_OF_A6	SAMP_FREQ/(STD_PNTS_F + 6.0)
#define	FREQ_OF_A7	SAMP_FREQ/(STD_PNTS_F + 7.0)

#define	FREQ_OF_M5_5	SAMP_FREQ/(STD_PNTS_F - 5.5)
#define	FREQ_OF_M4_5	SAMP_FREQ/(STD_PNTS_F - 4.5)
#define	FREQ_OF_M3_5	SAMP_FREQ/(STD_PNTS_F - 3.5)
#define	FREQ_OF_M2_5	SAMP_FREQ/(STD_PNTS_F - 2.5)
#define	FREQ_OF_M1_5	SAMP_FREQ/(STD_PNTS_F - 1.5)
#define	FREQ_OF_M0_5	SAMP_FREQ/(STD_PNTS_F - 0.5)
#define	FREQ_OF_A0_5	SAMP_FREQ/(STD_PNTS_F + 0.5)
#define	FREQ_OF_A1_5	SAMP_FREQ/(STD_PNTS_F + 1.5)
#define	FREQ_OF_A2_5	SAMP_FREQ/(STD_PNTS_F + 2.5)
#define	FREQ_OF_A3_5	SAMP_FREQ/(STD_PNTS_F + 3.5)
#define	FREQ_OF_A4_5	SAMP_FREQ/(STD_PNTS_F + 4.5)
#define	FREQ_OF_A5_5	SAMP_FREQ/(STD_PNTS_F + 5.5)
#define	FREQ_OF_A6_5	SAMP_FREQ/(STD_PNTS_F + 6.5)

// the following defines and array are used for 50Hz
//#define	FREQ_OF_58	55.1724
//#define	FREQ_OF_59	54.2373
//#define	FREQ_OF_60	53.3333
//#define	FREQ_OF_61	52.459
//#define	FREQ_OF_62	51.6129
//#define	FREQ_OF_63	50.7937
//#define	FREQ_OF_64	50.0
//#define	FREQ_OF_65	49.2308
//#define	FREQ_OF_66	48.4849
//#define	FREQ_OF_67	47.7612
//#define	FREQ_OF_68	47.0588
//#define	FREQ_OF_69	46.3768
//#define	FREQ_OF_70	45.7143
//#define	FREQ_OF_71	45.0704
														
//float Point2Frequency[]	={55.1724, 54.2373, 53.3333, 52.459, 51.6129, 50.7937, 50.0,
//		49.2308, 48.4849, 47.7612, 47.0588, 46.3768, 45.7143, 45.0704};
//const Point2Frequency[] __attribute__ ((space(auto_psv), aligned (256)))=
float Point2Frequency[] =
		{FREQ_OF_M6, FREQ_OF_M5, FREQ_OF_M4, FREQ_OF_M3, FREQ_OF_M2, 
		FREQ_OF_M1, STD_FREQ, FREQ_OF_A1, FREQ_OF_A2, FREQ_OF_A3, FREQ_OF_A4,
		FREQ_OF_A5, FREQ_OF_A6, FREQ_OF_A7};
// end. Feb 15th, by Jerry Gao

//this coefficient got from MATLAB analysis, for current and voltage measurement
//to compensate the calculation error from the drift of frequency to the ceter frequency
//we used a parabola to compensate, which meaned that high deviation of frequency would
//get higher compensation 
#define RMS_ERROR_COMPENS 0.0003		//maximum compensation ratio for RMS measurement - about 0.03% from MATLAB analysis
#define PWR_ERROR_COMPENS 0.0006		//maximum compensation ratio for power measurement - about 0.07% from MATLAB analysis
//in different frequency area, the interval between two center point is different
#define RATIOF_P58	1/(0.4676*0.4676)	
#define RATIOF_P59	1/(0.452*0.452)
#define RATIOF_P60	1/(0.437*0.437)
#define RATIOF_P61	1/(0.423*0.423)
#define RATIOF_P62	1/(0.4095*0.4095)
#define RATIOF_P63	1/(0.397*0.397)
#define RATIOF_P64	1/(0.3845*0.3845)
#define RATIOF_P65	1/(0.373*0.373)
#define RATIOF_P66	1/(0.362*0.362)
#define RATIOF_P67	1/(0.3511*0.3511)
#define RATIOF_P68	1/(0.341*0.341)
#define RATIOF_P69	1/(0.3313*0.3313)
#define RATIOF_P70	1/(0.322*0.322)


//qusi-synchronous window 58*3
const window58[] __attribute__ ((space(auto_psv), aligned (256)))=
{
	1,  6,  18,  38,  66,  102,  146,  198,  258,  326,  402,  486,  578,  678,  786,  902,  1026,  1158,  1298,  1446,  1602,  1766,  1938,  2118,	  
	2306,  2502,  2706,  2918,  3138,  3366,  3602,  3846,  4098,  4358,  4626,  4902,  5186,  5478,  5778,  6086,  6402,  6726,  7058,  7398,  
	7746,  8102,  8466,  8838,  9218,  9606,  10002,  10406,  10818,  11238,  11666,  12102,  12546,  12998,  13455,  13908,  14348,  14772,  
	15180,  15572,  15948,  16308,  16652,  16980,  17292,  17588,  17868,  18132,  18380,  18612,  18828,  19028,  19212,  19380,  19532,  19668,  
	19788,  19892,  19980,  20052,  20108,  20148,  20172,  20180
};

//qusi-synchronous window 59*3
const window59[] __attribute__ ((space(auto_psv), aligned (256)))=
{
	1,  6,  18,  38,  66,  102,  146,  198,  258,  326,  402,  486,  578,  678,  786,  902,  1026,  1158,  1298,  1446,  1602,  1766,  1938,  2118,  
	2306,  2502,  2706,  2918,  3138,  3366,  3602,  3846,  4098,  4358,  4626,  4902,  5186,  5478,  5778,  6086,  6402,  6726,  7058,  7398,  7746,  
	8102,  8466,  8838,  9218,  9606,  10002,  10406,  10818,  11238,  11666,  12102,  12546,  12998,  13458,  13923,  14384,  14832,  15264,  15680,  
	16080,  16464,  16832,  17184,  17520,  17840,  18144,  18432,  18704,  18960,  19200,  19424,  19632,  19824,  20000,  20160,  20304,  20432,  20544,  
	20640,  20720,  20784,  20832,  20864,  20880
};
//qusi-synchronous window 60*3
const window60[] __attribute__ ((space(auto_psv), aligned (256)))=
{
		1,  6,  18,  38,  66,  102,  146,  198,  258,  326,  402,  486,  578,  678,  786,  902,  1026,  1158,  1298,  1446,  1602,  1766,  1938,
	  2118,  2306,  2502,  2706,  2918,  3138,  3366,  3602,  3846,  4098,  4358,  4626,  4902,  5186,  5478,  5778,  6086,  6402,  6726,  7058,  
	  7398,  7746,  8102,  8466,  8838,  9218,  9606,  10002,  10406,  10818,  11238,  11666,  12102,  12546,  12998,  13458,  13926,  14399,  14868,  
	  15324,  15764,  16188,  16596,  16988,  17364,  17724,  18068,  18396,  18708,  19004,  19284,  19548,  19796,  20028,  20244,  20444,  20628,  
	  20796,  20948,  21084,  21204,  21308,  21396,  21468,  21524,  21564,  21588,  21596
};
//qusi-synchronous window 61*3
const window61[] __attribute__ ((space(auto_psv), aligned (256)))=
{
	1,		6,		18,		38,		66,		102,	146,	198,	258,	326,	402,	486,	578,	678,	786,	902,	
	1026,	1158,	1298,	1446,	1602,	1766,	1938,	2118,	2306,	2502,	2706,	2918,	3138,	3366,	3602,	3846,	
	4098,	4358,	4626,	4902,	5186,	5478,	5778,	6086,	6402,	6726,	7058,	7398,	7746,	8102,	8466,	8838,	
	9218,	9606,	10002,	10406,	10818,	11238,	11666,	12102,	12546,	12998,	13458,	13926,	14402,	14883,	15360,	15824,	
	16272,	16704,	17120,	17520,	17904,	18272,	18624,	18960,	19280,	19584,	19872,	20144,	20400,	20640,	20864,	21072,	
	21264,	21440,	21600,	21744,	21872,	21984,	22080,	22160,	22224,	22272,	22304,	22320	
};

//qusi-synchronous window 62*3
const window62[] __attribute__ ((space(auto_psv), aligned (256)))=
{	
	1,		6,		18,		38,		66,		102,	146,	198,	258,	326 ,	402,	486,	578,	678,	786, 
	902,	1026 ,	1158,	1298,	1446,	1602,	1766,	1938,	2118,	2306,	2502,	2706,	2918,	3138,	3366,
	3602,	3846,	4098,	4358,	4626,	4902,	5186,	5478,	5778,	6086,	6402,	6726,	7058,	7398,	7746, 
	8102,	8466,	8838,	9218,	9606,	10002,	10406,	10818,	11238,	11666,	12102,	12546,	12998,	13458,	13926, 
	14402,	14886,	15375,	15860,	16332,	16788,	17228,	17652,	18060,	18452,	18828,	19188,	19532,	19860,	20172, 
	20468,	20748,	21012,	21260,	21492,	21708,	21908,	22092,	22260,	22412,	22548,	22668,	22772,	22860,	22932,
	22988,	23028,	23052,	23060
};

//qusi-synchronous window 63*3
const window63[] __attribute__ ((space(auto_psv), aligned (256)))=
{
	1,		6,		18,		38,		66,		102,	146,	198,	258,	326,	402,	486,	578,	678,	786,	902,
	1026,	1158,	1298,	1446,	1602,	1766,	1938,	2118,	2306,	2502,	2706,	2918,	3138,	3366,	3602,	3846,
	4098,	4358,	4626,	4902,	5186,	5478,	5778,	6086,	6402,	6726,	7058,	7398,	7746,	8102,	8466,	8838,
	9218,	9606,	10002,	10406,	10818,	11238,	11666,	12102,	12546,	12998,	13458,	13926,	14402,	14886,	15378,	15875,
	16368,	16848,	17312,	17760,	18192,	18608,	19008,	19392,	19760,	20112,	20448,	20768,	21072,	21360,	21632,	21888,
	22128,	22352,	22560,	22752,	22928,	23088,	23232,	23360,	23472,	23568,	23648,	23712,	23760,	23792,	23808
};

//qusi-synchronous window 64*3
const window64[] __attribute__ ((space(auto_psv), aligned (256)))=
{
	1,		6,		18	,	38,		66,		102,	146,	198,	258,	326,	402,	486,	578,	678,	786,
	 902,	1026,	1158,	1298,	1446,	1602,	1766,	1938,	2118,	2306,	2502,	2706,	2918,	3138,	3366,
	3602,	3846,	4098,	4358,	4626,	4902,	5186,	5478,	5778,	6086,	6402,	6726,	7058,	7398,	7746,
	8102,	8466,	8838,	9218,	9606,	10002,	10406,	10818,	11238,	11666,	12102,	12546,	12998,	13458,	13926,
	14402,	14886,	15378,	15878,	16383,	16884,	17372,	17844,	18300,	18740,	19164,	19572,	19964,	20340,	20700,
	21044,	21372,	21684,	21980,	22260,	22524,	22772,	23004,	23220,	23420,	23604,	23772,	23924,	24060,	24180,
	24284,	24372,	24444,	24500,	24540,	24564,	24572	
};

//qusi-synchronous window 65*3
const window65[] __attribute__ ((space(auto_psv), aligned (256)))=
{
	1,		6,		18,		38,		66,		102,	146,	198,	258,	326,	402,	486,	578,	678,	786,	902 ,
	1026,	1158,	1298,	1446,	1602,	1766,	1938,	2118,	2306,	2502,	2706,	2918,	3138,	3366,	3602,	3846,
	4098,	4358,	4626,	4902,	5186,	5478,	5778,	6086,	6402,	6726,	7058,	7398,	7746,	8102,	8466,	8838,
	9218,	9606,	10002,	10406,	10818,	11238,	11666,	12102,	12546,	12998,	13458,	13926,	14402,	14886,	15378,	15878,
	16386,	16899,	17408,	17904,	18384,	18848,	19296,	19728,	20144,	20544,	20928,	21296,	21648,	21984,	22304,	22608,
	22896,	23168,	23424,	23664,	23888,	24096,	24288,	24464,	24624,	24768,	24896,	25008,	25104,	25184,	25248,	25296,
	25328,	25344
};

//qusi-synchronous window 66*3
const window66[] __attribute__ ((space(auto_psv), aligned (256)))=
{
	1,		6,		18,		38,		66,		102,	146,	198,	258,	326,	402,	486,	578,	678,	786,
	902	,	1026,	1158,	1298,	1446,	1602,	1766,	1938,	2118,	2306,	2502,	2706,	2918,	3138,	3366,
	3602,	3846,	4098,	4358,	4626,	4902,	5186,	5478,	5778,	6086,	6402,	6726,	7058,	7398,	7746,
	8102,	8466,	8838,	9218,	9606,	10002,	10406,	10818,	11238,	11666,	12102,	12546,	12998,	13458,	13926,
	14402,	14886,	15378,	15878,	16386,	16902,	17423,	17940,	18444,	18932,	19404,	19860,	20300,	20724,	21132,
	21524,	21900,	22260,	22604,	22932,	23244,	23540,	23820,	24084,	24332,	24564,	24780,	24980,	25164,	25332,
	25484,	25620,	25740,	25844,	25932,	26004,	26060,	26100,	26124,	26132
};

//qusi-synchronous window 67*3
const window67[] __attribute__ ((space(auto_psv), aligned (256)))=
{	
	1,		6,		18,		38,		66,		102,	146,	198,	258,	326,	402,	486,	578,	678,	786,	902,
	1026,	1158,	1298,	1446,	1602,	1766,	1938,	2118,	2306,	2502,	2706,	2918,	3138,	3366,	3602,	3846,
	4098,	4358,	4626,	4902,	5186,	5478,	5778,	6086,	6402,	6726,	7058,	7398,	7746,	8102,	8466,	8838,	
	9218,	9606,	10002,	10406,	10818,	11238,	11666,	12102,	12546,	12998,	13458,	13926,	14402,	14886,	15378,	15878,	
	16386,	16902,	17426,	17955,	18480,	18992,	19488,	19968,	20432,	20880,	21312,	21728,	22128,	22512,	22880,	23232,	
	23568,	23888,	24192,	24480,	24752,	25008,	25248,	25472,	25680,	25872,	26048,	26208,	26352,	26480,	26592,	26688,	
	26768,	26832,	26880,	26912,	26928
};

//qusi-synchronous window 68*3
const window68[] __attribute__ ((space(auto_psv), aligned (256)))=
{
	   1, 	 6,   18, 	38,   66,  102,  146,  198,  258,  326,  402, 486,  578,  678,  786,  902,  1026, 1158, 1298, 1446, 1602, 
	1766, 1938, 2118, 2306, 2502, 2706, 2918, 3138, 3366, 3602, 3846, 4098, 4358, 4626, 4902, 5186, 5478, 5778, 6086, 6402, 6726, 
	7058, 7398, 7746, 8102, 8466, 8838, 9218, 9606, 10002, 10406, 10818, 11238, 11666, 12102, 12546, 12998, 13458, 13926, 14402, 
	14886, 15378, 15878, 16386, 16902, 17426, 17958, 18495, 19028, 19548, 20052, 20540, 21012, 21468, 21908, 22332, 22740, 23132, 
	23508, 23868, 24212, 24540, 24852, 25148, 25428, 25692, 25940, 26172, 26388, 26588, 26772, 26940, 27092, 27228, 27348, 27452,
	27540, 27612, 27668, 27708, 27732, 27740
};

//qusi-synchronous window 69*3
const window69[] __attribute__ ((space(auto_psv), aligned (256)))=
{
		1,  6,  18,  38,  66,  102,  146,  198,  258,  326,  402,  486,  578,  678,  786,  902,  1026,  1158,  1298,  1446,  1602,  
	1766,  1938,  2118,  2306,  2502,  2706,  2918,  3138,  3366,  3602,  3846,  4098,  4358,  4626,  4902,  5186,  5478,  5778,  
	6086,  6402,  6726,  7058,  7398,  7746,  8102,  8466,  8838,  9218,  9606,  10002,  10406,  10818,  11238,  11666,  12102,  
	12546,  12998,  13458,  13926,  14402,  14886,  15378,  15878,  16386,  16902,  17426,  17958,  18498,  19043,  19584,  20112,  
	20624,  21120,  21600,  22064,  22512,  22944,  23360,  23760,  24144,  24512,  24864,  25200,  25520,  25824,  26112,  26384,  
	26640,  26880,  27104,  27312,  27504,  27680,  27840,  27984,  28112,  28224,  28320,  28400,  28464,  28512,  28544,  28560
};

//qusi-synchronous window 70*3
const window70[] __attribute__ ((space(auto_psv), aligned (256)))=
{
  1, 6, 18, 38, 66, 102, 146, 198, 258, 326, 402, 486, 578, 678, 786, 902, 1026, 1158, 1298, 1446, 1602, 1766, 1938, 2118, 2306, 
  2502, 2706, 2918, 3138, 3366, 3602, 3846, 4098, 4358, 4626, 4902, 5186, 5478, 5778, 6086, 6402, 6726, 7058, 7398, 7746, 8102, 
  8466, 8838, 9218, 9606, 10002, 10406, 10818, 11238, 11666, 12102, 12546, 12998, 13458, 13926, 14402, 14886, 15378, 15878, 16386, 
  16902, 17426, 17958, 18498, 19046, 19599, 20148, 20684, 21204, 21708, 22196, 22668, 23124, 23564, 23988, 24396, 24788, 25164, 
  25524, 25868, 26196, 26508, 26804, 27084, 27348, 27596, 27828, 28044, 28244, 28428, 28596, 28748, 28884, 29004, 29108, 29196, 
  29268, 29324, 29364, 29388, 29396
 };

//qusi-synchronous window 71*3
const window71[] __attribute__ ((space(auto_psv), aligned (256)))=
{
	1, 6, 18, 38, 66, 102, 146, 198, 258, 326, 402, 486, 578, 678, 786, 902, 1026, 1158, 1298, 1446, 1602, 1766, 1938, 2118, 2306, 
	2502, 2706, 2918, 3138, 3366, 3602, 3846, 4098, 4358, 4626, 4902, 5186, 5478, 5778, 6086, 6402, 6726, 7058, 7398, 7746, 8102, 
	8466, 8838, 9218, 9606, 10002, 10406, 10818, 11238, 11666, 12102, 12546, 12998, 13458, 13926, 14402, 14886, 15378, 15878, 
	16386, 16902, 17426, 17958, 18498, 19046, 19602, 20163, 20720, 21264, 21792, 22304, 22800, 23280, 23744, 24192, 24624, 25040, 
	25440, 25824, 26192, 26544, 26880, 27200, 27504, 27792, 28064, 28320, 28560, 28784, 28992, 29184, 29360, 29520, 29664, 29792, 
	29904, 30000, 30080, 30144, 30192, 30224, 30240
};

const  cos_sin_58pt[] __attribute__ ((space(auto_psv), aligned (256)))=
{
	32767, 32575, 32001, 31052, 29739, 28077, 26086, 23789, 21213, 18388, 15348, 12128, 8766, 5301, 1774, -1774, -5301, -8766, 
	-12128, -15348, -18388, -21213, -23789, -26086, -28077, -29739, -31052, -32001, -32575, -32767, -32575, -32001, -31052, -29739, 
	-28077, -26086, -23789, -21213, -18388, -15348, -12128, -8766, -5301, -1774, 1774, 5301, 8766, 12128, 15348, 18388, 21213, 
	23789, 26086, 28077, 29739, 31052, 32001, 32575, 

	0, 3543, 7044, 10463, 13759, 16893, 19830, 22534, 24974, 27121, 28950, 30440, 31573, 32335, 32719, 32719, 32335, 31573, 30440, 
	28950, 27121, 24974, 22534, 19830, 16893, 13759, 10463, 7044, 3543, 0, -3543, -7044, -10463, -13759, -16893, -19830, -22534, 
	-24974, -27121, -28950, -30440, -31573, -32335, -32719, -32719, -32335, -31573, -30440, -28950, -27121, -24974, -22534, -19830, 
	-16893, -13759, -10463, -7044, -3543
};

const  cos_sin_59pt[] __attribute__ ((space(auto_psv), aligned (256)))=
{
  32767,  32581,  32027,  31109,  29839,  28231,  26302,  24076,  21577,  18834,  15877,  12741,  9460,  6071,  2614,  -872,  -4349,  
  -7776,  -11116,  -14329,  -17380,  -20234,  -22859,  -25225,  -27305,  -29076,  -30517,  -31613,  -32350,  -32721,  -32721,  -32350,  
  -31613,  -30517,  -29076,  -27305,  -25225,  -22859,  -20234,  -17380,  -14329,  -11116,  -7776,  -4349,  -872,  2614,  6071,  9460,  
  12741,  15877,  18834,  21577,  24076,  26302,  28231,  29839,  31109,  32027,  32581,
  
  0,  3483,  6926,  10291,  13540,  16635,  19541,  22226,  24659,  26813,  28663,  30189,  31372,  32200,  32663,  32755,  32477,  
  31831,  30824,  29468,  27778,  25773,  23476,  20913,  18114,  15109,  11932,  8621,  5212,  1744,  -1744,  -5212,  -8621,  -11932,  
  -15109,  -18114,  -20913,  -23476,  -25773,  -27778,  -29468,  -30824,  -31831,  -32477,  -32755,  -32663,  -32200,  -31372,  -30189,  
  -28663,  -26813,  -24659,  -22226,  -19541,  -16635,  -13540,  -10291,  -6926,  -3483
};

const  cos_sin_60pt[] __attribute__ ((space(auto_psv), aligned (256)))=
{
32767,  32587,  32051,  31163,  29934,  28377,  26509,  24351,  21925,  19260,  16384,  13328,  10126,  6813,  3425,  0,  -3425,  -6813,  
-10126,  -13328,  -16383,  -19260,  -21925,  -24351,  -26509,  -28377,  -29934,  -31163,  -32051,  -32587,  -32767,  -32587,  -32051,  
-31163,  -29934,  -28377,  -26509,  -24351,  -21925,  -19260,  -16383,  -13328,  -10126,  -6813,  -3425,  0,  3425,  6813,  10126,  
13328,  16384,  19260,  21925,  24351,  26509,  28377,  29934,  31163,  32051,  32587, 

0,  3425,  6813,  10126,  13328,  16383,  19260,  21925,  24351,  26509,  28377,  29934,  31163,  32051,  32587,  32767,  32587,  32051,  
31163,  29934,  28377,  26509,  24351,  21925,  19260,  16384,  13328,  10126,  6813,  3425,  0,  -3425,  -6813,  -10126,  -13328,  -16384,  
-19260,  -21925,  -24351,  -26509,  -28377,  -29934,  -31163,  -32051,  -32587,  -32767,  -32587,  -32051,  -31163,  -29934,  -28377,  
-26509,  -24351,  -21925,  -19260,  -16384,  -13328,  -10126,  -6813,  -3425
};

const  cos_sin_61pt[] __attribute__ ((space(auto_psv), aligned (256)))=
{
//61 point cos*32767
32767,	32593,	32074,	31215,	30025,	28517,	26706,	24612,	22258,	19667,	16868,	13890,	10765,	7526,	4207,	844,	-2529,	
-5874,	-9158,	-12344,	-15400,	-18292,	-20990,	-23466,	-25693,	-27648,	-29310,	-30661,	-31687,	-32377,	-32724,	-32724,	-32377,	-31687,
-30661,	-29310,	-27648,	-25693,	-23466,	-20990,	-18292,	-15400,	-12344,	-9158,	-5874,	-2529,	844,	4207,	7526,	10765,	13890,	
16868,	19667,	22258,	24612,	26706,	28517,	30025,	31215,	32074,	32593,
//61point sin * 32767
0,	3369,	6703,	9965,	13122,	16139,	18986,	21631,	24047,	26208,	28092,	29677,	30948,	31891,	32496,	32756,	32669,	
32236,	31461,	30353,	28923,	27186,	25161,	22870,	20336,	17586,	14650,	11559,	8345,	5043,	1687,	-1687,	-5043,	
-8345,	-11559,	-14650,	-17586,	-20336,	-22870,	-25161,	-27186,	-28923,	-30353,	-31461,	-32236,	-32669,	-32756,	-32496,	-31891,	
-30948,	-29677,	-28092,	-26208,	-24047,	-21631,	-18986,	-16139,	-13122,	-9965,	-6703,	-3369
};

const cos_sin_62pt[] __attribute__ ((space(auto_psv), aligned (256)))=
{
//62 point cos*32767
32767,	32599,	32096,	31264,	30111,	28650,	26894,	24862,	22575,	20057,	17333,	14430,	11380,	8213,	4962,	1660,
-1660,	-4962,	-8213,	-11380,	-14430,	-17333,	-20057,	-22575,	-24862,	-26894,	-28650,	-30111,	-31264,	-32096,	-32599,	-32767,	
-32599,	-32096,	-31264,	-30111,	-28650,	-26894,	-24862,	-22575,	-20057,	-17333,	-14430,	-11380,	-8213,	-4962,	-1660,	1660,	
4962,	8213,	11380,	14430,	17333,	20057,	22575,	24862,	26894,	28650,	30111,	31264,	32096,	32599,	
//62point sin * 32767
0,		3315,	6596,	9809,	12922,	15902,	18719,	21344,	23749,	25911,	27808,	29418,	30727,	31721,	32389,	32725,	
32725,	32389,	31721,	30727,	29418,	27808,	25911,	23749,	21344,	18719,	15902,	12922,	9809,	6596,	3315,	0,	
-3315,	-6596,	-9809,	-12922,	-15902,	-18719,	-21344,	-23749,	-25911,	-27808,	-29418,	-30727,	-31721,	-32389,	-32725,	-32725,	
-32389,	-31721,	-30727,	-29418,	-27808,	-25911,	-23749,	-21344,	-18719,	-15902,	-12922,	-9809,	-6596,	-3315
};

const  cos_sin_63pt[] __attribute__ ((space(auto_psv), aligned (256)))=
{
//63point cos * 32767
32767,	32604,	32117,	31311,	30194,	28777,	27073,	25101,	22879,	20430,	17778,	14949,	11971,	8875,	5690,	2449,	
-817,	-4074,	-7291,	-10436,	-13477,	-16384,	-19128,	-21681,	-24020,	-26120,	-27960,	-29522,	-30791,	-31754,	-32401,	-32726,	
-32726,	-32401,	-31754,	-30791,	-29522,	-27960,	-26120,	-24020,	-21681,	-19128,	-16384,	-13477,	-10436,	-7291,	-4074,	-817,	
2449,	5690,	8875,	11971,	14949,	17778,	20430,	22879,	25101,	27073,	28777,	30194,	31311,	32117,	32604,

//63point sin * 32767
0,		3263,	6493,	9658,	12728,	15671,	18458,	21062,	23457,	25618,	27525,	29158,	30502,	31542,	32269,	32675,	32757,	
32513,	31945,	31061,	29867,	28377,	26605,	24568,	22287,	19785,	17086,	14217,	11207,	8085,	4884,	1633,	-1633,	-4884,	
-8085,	-11207,	-14217,	-17086,	-19785,	-22287,	-24568,	-26605,	-28377,	-29867,	-31061,	-31945,	-32513,	-32757,	-32675,	-32269,	-31542,	
-30502,	-29158,	-27525,	-25618,	-23457,	-21062,	-18458,	-15671,	-12728,	-9658,	-6493,	-3263
};

const cos_sin_64pt[] __attribute__ ((space(auto_psv), aligned (256)))=
{	
//cos 
32767,	32609,	32137,	31356,	30273,	28898,	27245,	25329,	23170,	20787,	18204,	15446,	12539,	9512,	6393,	3212,
	0,	-3212,	-6393,	-9512,	-12539,	-15446,	-18204,	-20787,	-23170,	-25329,	-27245,	-28898,	-30273,	-31356,	-32137,	-32609,
-32767,	-32609,	-32137,	-31356,	-30273,	-28898,	-27245,	-25329,	-23170,	-20787,	-18204,	-15446,	-12539,	-9512,	-6393,	-3212,
	0,	3212,	6393,	9512,	12539,	15446,	18204,	20787,	23170,	25329,	27245,	28898,	30273,	31356,	32137,	32609,
// sin 
	0,	3212,	6393,	9512,	12539,	15446,	18204,	20787,	23170,	25329,	27245,	28898,	30273,	31356,	32137,	32609,
32767,	32609,	32137,	31356,	30273,	28898,	27245,	25329,	23170,	20787,	18204,	15446,	12539,	9512,	6393,	3212,
	0,	-3212,	-6393,	-9512,	-12539,	-15446,	-18204,	-20787,	-23170,	-25329,	-27245,	-28898,	-30273,	-31356,	-32137,	-32609,	
-32767,	-32609,	-32137,	-31356,	-30273,	-28898,	-27245,	-25329,	-23170,	-20787,	-18204,	-15446,	-12539,	-9512,	-6393,	-3212
};

const  cos_sin_65pt[] __attribute__ ((space(auto_psv), aligned (512)))=
{
//65point cos * 32767
32767,	32614,	32157,	31399,	30348,	29014,	27409,	25548,	23448,	21130,	18614,	15924,	13086,	10126,	7071,	3950,	
792,	-2373,	-5517,	-8608,	-11619,	-14522,	-17289,	-19895,	-22315,	-24526,	-26509,	-28244,	-29716,	-30909,	-31815,	-32423,	
-32729,	-32729,	-32423,	-31815,	-30909,	-29716,	-28244,	-26509,	-24526,	-22315,	-19895,	-17289,	-14522,	-11619,	-8608,	-5517,	
-2373,	792,	3950,	7071,	10126,	13086,	15924,	18614,	21130,	23448,	25548,	27409,	29014,	30348,	31399,	32157,	
32614,	

//65point sin * 32767
0,		3162,	6295,	9370,	12356,	15228,	17957,	20518,	22888,	25044,	26967,	28637,	30041,	31163,	31995,	32528,	
32757,	32681,	32299,	31616,	30638,	29373,	27835,	26036,	23994,	21729,	19260,	16612,	13808,	10876,	7842,	4734,	
1583,	-1583,	-4734,	-7842,	-10876,	-13808,	-16612,	-19260,	-21729,	-23994,	-26036,	-27835,	-29373,	-30638,	-31616,	-32299,	
-32681,	-32757,	-32528,	-31995,	-31163,	-30041,	-28637,	-26967,	-25044,	-22888,	-20518,	-17957,	-15228,	-12356,	-9370,	-6295,	
-3162
};

const  cos_sin_66pt[] __attribute__ ((space(auto_psv), aligned (512)))=
{
//cos	
32767,	32619,	32175,	31440,	30420,	29124,	27565,	25757,	23715,	21458,	19007,	16384,	13612,	10717,	7725,	4663,
1559,	-1559,	-4663,	-7725,	-10717,	-13612,	-16383,	-19007,	-21458,	-23715,	-25757,	-27565,	-29124,	-30420,	-31440,	-32175,	
-32619,	-32767,	-32619,	-32175,	-31440,	-30420,	-29124,	-27565,	-25757,	-23715,	-21458,	-19007,	-16383,	-13612,	-10717,	-7725,	
-4663,	-1559,	1559,	4663,	7725,	10717,	13612,	16384,	19007,	21458,	23715,	25757,	27565,	29124,	30420,	31440,	
32175,	32619,	
//sin 
0,		3115,	6201,	9232,	12178,	15015,	17715,	20255,	22612,	24764,	26691,	28377,	29806,	30965,	31843,	32433,	
32730,	32730,	32433,	31843,	30965,	29806,	28377,	26691,	24764,	22612,	20255,	17715,	15015,	12178,	9232,	6201,	
3115,	0,		-3115,	-6201,	-9232,	-12178,	-15015,	-17715,	-20255,	-22612,	-24764,	-26691,	-28377,	-29806,	-30965,	-31843,	
-32433,	-32730,	-32730,	-32433,	-31843,	-30965,	-29806,	-28377,	-26691,	-24764,	-22612,	-20255,	-17715,	-15015,	-12178,	-9232,	
-6201,	-3115
};

const  cos_sin_67pt[] __attribute__ ((space(auto_psv), aligned (512)))=
{
//67point cos * 32767
32767,	32623,	32192,	31479,	30489,	29230,	27715,	25957,	23970,	21773,	19384,	16825,	14118,	11287,	8357,	5353,	
2303,	-768,	-3832,	-6863,	-9833,	-12717,	-15489,	-18124,	-20601,	-22897,	-24991,	-26866,	-28504,	-29892,	-31018,	-31871,	
-32443,	-32731,	-32731,	-32443,	-31871,	-31018,	-29892,	-28504,	-26866,	-24991,	-22897,	-20601,	-18124,	-15489,	-12717,	-9833,	
-6863,	-3832,	-768,	2303,	5353,	8357,	11287,	14118,	16825,	19384,	21773,	23970,	25957,	27715,	29230,	30489,	
31479,	32192,	32623,

//67point sin * 32767
0,		3068,	6110,	9097,	12005,	14807,	17480,	19998,	22341,	24487,	26418,	28118,	29569,	30762,	31683,	32327,	
32686,	32758,	32542,	32040,	31257,	30199,	28875,	27298,	25481,	23440,	21193,	18759,	16161,	13421,	10563,	7612,	
4594,	1536,	-1536,	-4594,	-7612,	-10563,	-13421,	-16161,	-18759,	-21193,	-23440,	-25481,	-27298,	-28875,	-30199,	-31257,	
-32040,	-32542,	-32758,	-32686,	-32327,	-31683,	-30762,	-29569,	-28118,	-26418,	-24487,	-22341,	-19998,	-17480,	-14807,	-12005,	
-9097,	-6110,	-3068
};

const  cos_sin_68pt[] __attribute__ ((space(auto_psv), aligned (512)))=
{
32767,  32627,  32209,  31516,  30554,  29332,  27859,  26149,  24215,  22075,  19747,  17250,  14606,  11837,  8967,  6021,  
3023,  0,  -3023,  -6021,  -8967,  -11837,  -14606,  -17250,  -19747,  -22075,  -24215,  -26149,  -27859,  -29332,  -30554,  
-31516,  -32209,  -32627,  -32767,  -32627,  -32209,  -31516,  -30554,  -29332,  -27859,  -26149,  -24215,  -22075,  -19747,  
-17250,  -14606,  -11837,  -8967,  -6021,  -3023,  0,  3023,  6021,  8967,  11837,  14606,  17250,  19747,  22075,  24215,  
26149,  27859,  29332,  30554,  31516,  32209,  32627,

0,  3023,  6021,  8967,  11837,  14606,  17250,  19747,  22075,  24215,  26149,  27859,  29332,  30554,  31516,  32209,  32627,  
32767,  32627,  32209,  31516,  30554,  29332,  27859,  26149,  24215,  22075,  19747,  17250,  14606,  11837,  8967,  6021,  
3023,  0,  -3023,  -6021,  -8967,  -11837,  -14606,  -17250,  -19747,  -22075,  -24215,  -26149,  -27859,  -29332,  -30554,  
-31516,  -32209,  -32627,  -32767,  -32627,  -32209,  -31516,  -30554,  -29332,  -27859,  -26149,  -24215,  -22075,  -19747,  
-17250,  -14606,  -11837,  -8967,  -6021,  -3023
};

const  cos_sin_69pt[] __attribute__ ((space(auto_psv), aligned (512)))=
{
32767,  32631,  32225,  31552,  30617,  29429,  27997,  26333,  24450,  22365,  20095,  17658,  15075,  12367,  9556,  6667,  
3722,  746,  -2236,  -5200,  -8120,  -10973,  -13735,  -16383,  -18896,  -21252,  -23432,  -25418,  -27193,  -28743,  -30054,  
-31117,  -31922,  -32462,  -32733,  -32733,  -32462,  -31922,  -31117,  -30054,  -28743,  -27193,  -25418,  -23432,  -21252,  
-18896,  -16383,  -13735,  -10973,  -8120,  -5200,  -2236,  746,  3722,  6667,  9556,  12367,  15075,  17658,  20095,  22365,  
24450,  26333,  27997,  29429,  30617,  31552,  32225,  32631,
0,  2980,  5935,  8840,  11673,  14409,  17025,  19501,  21814,  23947,  25882,  27602,  29093,  30344,  31342,  32082,  32555,  
32759,  32691,  32352,  31745,  30875,  29749,  28377,  26770,  24940,  22905,  20679,  18282,  15733,  13054,  10267,  7395,  
4462,  1491,  -1491,  -4462,  -7395,  -10267,  -13054,  -15733,  -18282,  -20679,  -22905,  -24940,  -26770,  -28377,  -29749,  
-30875,  -31745,  -32352,  -32691,  -32759,  -32555,  -32082,  -31342,  -30344,  -29093,  -27602,  -25882,  -23947,  -21814,  
-19501,  -17025,  -14409,  -11673,  -8840,  -5935,  -2980
};

const  cos_sin_70pt[] __attribute__ ((space(auto_psv), aligned (512)))=
{
32767, 32635, 32240, 31586, 30678, 29522, 28129, 26509, 24676, 22644, 20430, 18051, 15527, 12878, 10126, 7291, 4398, 1470, -1470, 
-4398, -7291, -10126, -12878, -15527, -18051, -20430, -22644, -24676, -26509, -28129, -29522, -30678, -31586, -32240, -32635, 
-32767, -32635, -32240, -31586, -30678, -29522, -28129, -26509, -24676, -22644, -20430, -18051, -15527, -12878, -10126, -7291, 
-4398, -1470, 1470, 4398, 7291, 10126, 12878, 15527, 18051, 20430, 22644, 24676, 26509, 28129, 29522, 30678, 31586, 32240, 32635,

0, 2937, 5851, 8717, 11513, 14217, 16806, 19260, 21559, 23684, 25618, 27346, 28854, 30130, 31163, 31945, 32470, 32734, 32734, 
32470, 31945, 31163, 30130, 28854, 27346, 25618, 23684, 21559, 19260, 16806, 14217, 11513, 8717, 5851, 2937, 0, -2937, -5851, 
-8717, -11513, -14217, -16806, -19260, -21559, -23684, -25618, -27346, -28854, -30130, -31163, -31945, -32470, -32734, -32734, 
-32470, -31945, -31163, -30130, -28854, -27346, -25618, -23684, -21559, -19260, -16806, -14217, -11513, -8717, -5851, -2937	
};

const  cos_sin_71pt[] __attribute__ ((space(auto_psv), aligned (512)))=
{
32767, 32639, 32255, 31619, 30735, 29611, 28255, 26678, 24893, 22912, 20752, 18430, 15963, 13372, 10676, 7896, 5054, 2173, 
-725, -3617, -6481, -9295, -12035, -14682, -17213, -19610, -21853, -23926, -25811, -27494, -28962, -30203, -31208, -31968, 
-32479, -32735, -32735, -32479, -31968, -31208, -30203, -28962, -27494, -25811, -23926, -21853, -19610, -17213, -14682, 
-12035, -9295, -6481, -3617, -725, 2173, 5054, 7896, 10676, 13372, 15963, 18430, 20752, 22912, 24893, 26678, 28255, 29611, 
30735, 31619, 32255, 32639,
0, 2896, 5769, 8597, 11358, 14030, 16592, 19025, 21308, 23425, 25358, 27093, 28616, 29914, 30979, 31801, 32375, 32695, 
32759, 32567, 32120, 31421, 30477, 29294, 27881, 26251, 24415, 22388, 20186, 17826, 15326, 12707, 9988, 7190, 4337, 1449, 
-1449, -4337, -7190, -9988, -12707, -15326, -17826, -20186, -22388, -24415, -26251, -27881, -29294, -30477, -31421, -32120, 
-32567, -32759, -32695, -32375, -31801, -30979, -29914, -28616, -27093, -25358, -23425, -21308, -19025, -16592, -14030, 
-11358, -8597, -5769, -2896 
};

/*
const float P_C[14][3] __attribute__ ((space(auto_psv), aligned (4))) = {
		  0.4937,  0.0004, 0.0042, 0.4614,  0.0024, 0.0039, 0.4446,  0.0065, 0.0081, 0.4588, 0.0124, 0.0066,
	      0.3936, -0.0025, 0.0098, 0.3590,  0.0125, 0.0094, 0.3862, -0.0217, 0.0086, 0.3966,-0.0204, 0.0065,
	      0.4153, -0.0238, 0.0048, 0.3489, -0.0079, 0.0099, 0.2914,  0.0014, 0.0032, 0.2936, 0.0091, 0.0142,
	      0.3725, -0.0027,-0.0011, 0.3659,  0.0264, 0.0016};

const float U_C[14][3] __attribute__ ((space(auto_psv), aligned (4))) = {
		  0.2788, -0.0026, 0.0031, 0.2581, 0.0015, 0.0038, 0.2715, -0.0022, 0.0025,
	      0.2522,  0.0016, 0.0030, 0.2256, 0.0020, 0.0040, 0.2380, -0.0075, 0.0027,
	      0.2074,  0.0018, 0.0036, 0.2215, -0.0010, 0.0037, 0.2247, -0.0005, 0.0021, 
	      0.1956,  0.0002, 0.0038, 0.2067, -0.0021, 0.0020, 0.2059, -0.0010, 0.0023, 
	      0.1852, -0.0049, 0.0033, 0.1729,  0.0036, 0.0040};
*/
typedef struct _COMPLEX
{
	int real;
	int imag;
}COMPLEX;

COMPLEX DFTOut_V[32] __attribute__ ((section (".xbss"), aligned (16)));
COMPLEX DFTOut_I[32] __attribute__((section (".ybss"), aligned (16)));
//COMPLEX DFTOut_I[34] __attribute__((section (".xbss"), aligned (16)));;


unsigned long DFTMagnitude[33];

float Delta_F;

float calculate_angle(int real, int imag);
unsigned char detect_phase_order(int* pointer,	int page);
void data_pre_processing(unsigned int length, int* buffer);
float measure_freq(void);
float calculate_freq(int real_1, int imag_1, int real_2, int imag_2, unsigned char smp_pnt);

#endif
#undef LOCAL_GLOBLE

//===========================================================================
//-----------------------Globle functions  -----------------------------------
//===========================================================================


EXT void Update_Gain(void);
EXT void Calculation(void);
EXT long ComputeNeutralAmplitude(int*, int);


#undef _CALCULATE_H



