#include <p33FJ128GP206.h>
#include	<i2c.h>
//#include "I2CSubs.h"


#define		REPORT_NACK			{	\
									IFS1bits.MI2C1IF = 0 ; \
									StopI2C1( ) ; \
									while ( I2C1CONbits.PEN ) ;	\
									return -1 ; \
								} 

unsigned char  I2C_ACKPolling(unsigned char CMD)
{
		unsigned char ACK_Result ;
		IdleI2C1( ) ;
		StartI2C1( ) ;

		while ( I2C1CONbits.SEN) ;				// Send START bit ! SEN will be clear automatically once START bits completed 

		IFS1bits.MI2C1IF = 0 ;
		MasterWriteI2C1(CMD & 0xFE) ;
		while(! IFS1bits.MI2C1IF ) ;				// MI2CIF will be clear after data transmitted completely !

			if ( I2C1STATbits.ACKSTAT ) 		ACK_Result =  1 ;
			else							ACK_Result =  0 ;

		IFS1bits.MI2C1IF = 0 ;
		StopI2C1( ) ;
		while ( I2C1CONbits.PEN ) ;	
		IFS1bits.MI2C1IF = 0 ;
		return		ACK_Result ;
}

void	Init_I2C(void)
{
	unsigned int 	config1 , config2 ;

	TRISGbits.TRISG2=1;
	TRISGbits.TRISG3=1;
	config2 = 0x12b;		//baud rate
	config1 =	 I2C1_ON & I2C1_IDLE_STOP&I2C1_CLK_REL
				& I2C1_IPMI_DIS & I2C1_7BIT_ADD
				& I2C1_SLW_DIS & I2C1_SM_DIS 
				& I2C1_GCALL_DIS & I2C1_STR_DIS
				& I2C1_NACK & I2C1_ACK_DIS & I2C1_RCV_DIS 
				& I2C1_STOP_DIS & I2C1_RESTART_DIS
				& I2C1_START_DIS ;
				

				ConfigIntI2C1(MI2C1_INT_OFF & MI2C1_INT_PRI_0 ) ;
				OpenI2C1(config1,config2) ;
				
}

unsigned char E2prom_WritePage(unsigned char CMD , unsigned char BLK_Addr, unsigned char Addr , unsigned char *Data_Buf)
{
	unsigned char datain;
	unsigned char command;
	unsigned char i;
	command = CMD|(BLK_Addr<<1);
		
	IdleI2C1( ) ;
	StartI2C1( ) ;
	while ( I2C1CONbits.SEN) ;				// Send START bit ! SEN will be clear automatically once START bits completed 
	
	IFS1bits.MI2C1IF = 0 ;
	MasterWriteI2C1(command& 0xFE) ;
	while(! IFS1bits.MI2C1IF ) ;				// MI2CIF will be clear after data transmitted completely !
	
		if ( I2C1STATbits.ACKSTAT ) 			
			REPORT_NACK
	
	
	IFS1bits.MI2C1IF = 0 ;
	MasterWriteI2C1(Addr) ;
	while(! IFS1bits.MI2C1IF ) ;
	
		if ( I2C1STATbits.ACKSTAT ) 			
		
			REPORT_NACK
	
	
	for(i=0;i<8;i++)
	{
		IFS1bits.MI2C1IF = 0 ;
		MasterWriteI2C1(*Data_Buf) ;
		while(! IFS1bits.MI2C1IF ) ;
			if ( I2C1STATbits.ACKSTAT ) 			
				REPORT_NACK		
		Data_Buf++;
	}	
	
	IFS1bits.MI2C1IF = 0 ;

	StopI2C1( ) ;
	while ( I2C1CONbits.PEN ) ;	
	IFS1bits.MI2C1IF = 0 ;
	return 0 ;
}
int		EEPROM_ByteWrite(unsigned char CMD ,unsigned char BLK_Addr, unsigned char Addr , unsigned char Data ) 
{
		unsigned char command;
		command = CMD|(BLK_Addr<<1);
		IdleI2C1( ) ;
		StartI2C1( ) ;

		while ( I2C1CONbits.SEN) ;				// Send START bit ! SEN will be clear automatically once START bits completed 

		IFS1bits.MI2C1IF = 0 ;
		MasterWriteI2C1((command & 0xFE)) ;
		while(! IFS1bits.MI2C1IF ) ;				// MI2CIF will be clear after data transmitted completely !

			if ( I2C1STATbits.ACKSTAT ) 			
				REPORT_NACK


		IFS1bits.MI2C1IF = 0 ;
		MasterWriteI2C1(Addr) ;
		while(! IFS1bits.MI2C1IF ) ;

			if ( I2C1STATbits.ACKSTAT ) 			
				REPORT_NACK


		IFS1bits.MI2C1IF = 0 ;
		MasterWriteI2C1(Data) ;
		while(! IFS1bits.MI2C1IF ) ;

			if ( I2C1STATbits.ACKSTAT ) 			
				REPORT_NACK		


		IFS1bits.MI2C1IF = 0 ;
		StopI2C1( ) ;
		while ( I2C1CONbits.PEN ) ;	
		IFS1bits.MI2C1IF = 0 ;
				return 0 ;

}



unsigned char EEPROM_ReadBytes(unsigned char CMD ,unsigned char BLK_Addr, unsigned char Addr, unsigned char number, unsigned  char *Data_Buf)
{
	unsigned char  i;
	unsigned char command;
	
	command = CMD|(BLK_Addr<<1);
	
	IdleI2C1( ) ;
	StartI2C1( ) ;
	while ( I2C1CONbits.SEN) ;
	
	IFS1bits.MI2C1IF = 0 ;
	MasterWriteI2C1((command & 0xFE)) ;
	while(! IFS1bits.MI2C1IF ) ;
	
	if ( I2C1STATbits.ACKSTAT ) 			
		REPORT_NACK
	
	IFS1bits.MI2C1IF = 0 ;
	MasterWriteI2C1(Addr) ;
	while(! IFS1bits.MI2C1IF ) ;
	
	if ( I2C1STATbits.ACKSTAT ) 			
		REPORT_NACK
	
	IFS1bits.MI2C1IF = 0 ;

	IdleI2C1();	
	RestartI2C1( ) ;
	while ( I2C1CONbits.RSEN) ;
	
	IFS1bits.MI2C1IF = 0 ;
	MasterWriteI2C1((command | 0x01)) ;					// Set bit 0 for "Read" command
	while(! IFS1bits.MI2C1IF ) ;
	
	if ( I2C1STATbits.ACKSTAT ) 			
		REPORT_NACK
	
	IFS1bits.MI2C1IF = 0 ;

	for(i=0;i<number-1;i++)
	{
		
   	*Data_Buf = MasterReadI2C1( );
	while(! IFS1bits.MI2C1IF ) ;
	IFS1bits.MI2C1IF = 0 ;
	AckI2C1();			//send ack 	
	while(! IFS1bits.MI2C1IF ) ;
	IFS1bits.MI2C1IF = 0 ;
	Data_Buf++;
	
	}

	*Data_Buf = MasterReadI2C1( );
	NotAckI2C1( ) ;
	while(! IFS1bits.MI2C1IF ) ;
	IFS1bits.MI2C1IF = 0 ;
	
	StopI2C1( ) ;
	while ( I2C1CONbits.PEN ) ;	
	IFS1bits.MI2C1IF = 0 ;
	return  0;
}


unsigned char EEPROM_ByteRead(unsigned char CMD ,unsigned char BLK_Addr, unsigned char Addr  )
{
		unsigned char command;	
		unsigned char Temp_Buffer ;
		unsigned		ReadDelay ;
		
		command = CMD|(BLK_Addr<<1);
		IdleI2C1( ) ;
		StartI2C1( ) ;
		while (I2C1CONbits.SEN) ;

		IFS1bits.MI2C1IF = 0 ;
		MasterWriteI2C1((command & 0xFE)) ;				// Mask bit 0 -> Write command 
		while(! IFS1bits.MI2C1IF ) ;

			if ( I2C1STATbits.ACKSTAT ) 			
				REPORT_NACK

		IFS1bits.MI2C1IF = 0 ;
		MasterWriteI2C1(Addr) ;
		while(! IFS1bits.MI2C1IF ) ;

			if ( I2C1STATbits.ACKSTAT ) 			
				REPORT_NACK

		IFS1bits.MI2C1IF = 0 ;
		
		IdleI2C1( ) ;
		RestartI2C1( ) ;
		while ( I2C1CONbits.RSEN) ;

		IFS1bits.MI2C1IF = 0 ;
		MasterWriteI2C1((command | 0x01)) ;					// Set bit 0 for "Read" command
		while(! IFS1bits.MI2C1IF ) ;

			if ( I2C1STATbits.ACKSTAT ) 			
				REPORT_NACK

		IFS1bits.MI2C1IF = 0 ;

		Temp_Buffer  = MasterReadI2C1( ) ;
		while(! IFS1bits.MI2C1IF ) ;

		IFS1bits.MI2C1IF = 0 ;
		NotAckI2C1( ) ;
		while(! IFS1bits.MI2C1IF ) ;
		IFS1bits.MI2C1IF = 0 ;

		StopI2C1( ) ;
		while ( I2C1CONbits.PEN ) ;	
		IFS1bits.MI2C1IF = 0 ;
		return (char)Temp_Buffer ;

}


