//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jerry Gao, Jemmey Huang					 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *   File name:	MCP390x.h											 *
// *   Description: head file for MCP390x.h								 *
// **********************************************************************/

#define _MCP390X_H

#undef EXT
#undef LOCAL_GLOBLE
#ifdef _MCP390X_C
  #define EXT
  #define LOCAL_GLOBLE
#else
  #define EXT extern
#endif


#ifdef LOCAL_GLOBLE
//===========================================================================
//-------------Local defines, variables  ------------------------------------
//===========================================================================

//------------------------------ TYPEDEF ------------------------------------

//------------------------------ DEFINES ------------------------------------
#define MCP390X_CS_PRT	LATB
#define PA_CS			0XFFFB
#define PB_CS			0XFFFD
#define PC_CS			0XFFFE
#define PABC_CS			0XFFF8
#define PABC_NCS		0X0007
#define MCP390X_PA_CS	LATBbits.LATB2
#define MCP390X_PB_CS	LATBbits.LATB1
#define MCP390X_PC_CS	LATBbits.LATB0
#define MCP390X_MCLR	LATGbits.LATG0

#define  G0C LATBbits.LATB3
#define  G1C LATBbits.LATB4
#define  G0B LATCbits.LATC1
#define  G1B LATCbits.LATC2
#define  G0A LATGbits.LATG14
#define  G1A LATGbits.LATG15


//unsigned int tempValue;
unsigned int spi_temp;

//===========================================================================
//-----------------------Local functions  -----------------------------------
//===========================================================================



#endif
#undef LOCAL_GLOBLE

#define PHASE_A 1
#define PHASE_B 2
#define PHASE_C 3

//===========================================================================
//------------- Globle defines, variables  ----------------------------------
//===========================================================================

//===========================================================================
//-----------------------Globle functions  -----------------------------------
//===========================================================================

//EXT void ConfigIntSPI1(unsigned int config); 
EXT void WrittingSPI(unsigned int data_out);    
EXT int ReadingSPI(void);                           
EXT void InitSPI(void);
EXT void InitMCP390x(void);
EXT void ReadMCP390x(void);
EXT int ZeroValueCh[6];

EXT int phase_gain[3];

EXT void Delay(int cnt); 

#undef _MCP390X_H
