//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jerry Gao, Jemmey Huang					 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *   File name:	MCP390x.c											 *
// *   Description: Initialize MCP3905/6 and read data from MCP3905/6	 *
// **********************************************************************/

#define _MCP390X_C
#include <spi.h> 
#include "global.h"
#include "mcp390x.h"
#undef _MCP390X_C

extern long Multiply16x16(int, int);



unsigned int pointer=0;
unsigned int pointer1=10;


int voltage_signal[128] = //__attribute__ ((space(auto_psv), aligned (16))) = 
{
	/*
13000,12984,12937,12859,12750,12610,12440,12240,12010,11752,11465,11150,10809,10442,10049,
9632,9192,8730,8247,7744,7222,6683,6128,5558,4975,4380,3774,3159,2536,1907,1274,638,0,-638,
-1274,-1907,-2536,-3159,-3774,-4380,-4975,-5558,-6128,-6683,-7222,-7744,-8247,-8730,-9192,
-9632,-10049,-10442,-10809,-11150,-11465,-11752,-12010,-12240,-12440,-12610,-12750,-12859,
-12937,-12984,-13000,-12984,-12937,-12859,-12750,-12610,-12440,-12240,-12010,-11752,-11465,
-11150,-10809,-10442,-10049,-9632,-9192,-8730,-8247,-7744,-7222,-6683,-6128,-5558,-4975,
-4380,-3774,-3159,-2536,-1907,-1274,-638,0,638,1274,1907,2536,3159,3774,4380,4975,5558,
6128,6683,7222,7744,8247,8730,9192,9632,10049,10442,10809,11150,11465,11752,12010,12240,
12440,12610,12750,12859,12937,12984

14133, 13261, 12281, 11198, 10019, 8755, 7417, 6017, 4571, 3091, 1594, 94, -1394, -2858, -4284, 
-5660, -6979, -8230, -9408, -10508, -11527, -12463, -13316, -14087, -14778, -15392, -15934, -16408, 
-16818, -17171, -17472, -17726, -17939, -18114, -18258, -18373, -18463, -18531, -18578, -18606, 
-18614, -18603, -18571, -18517, -18437, -18330, -18193, -18022, -17815, -17569, -17281, -16950, 
-16575, -16154, -15689, -15179, -14626, -14032, -13400, -12731, -12029, -11298, -10538, -9755, 
-8949, -8123, -7279, -6418, -5542, -4651, -3747, -2829, -1900, -961, -13, 941, 1900, 2859, 3815, 4763, 
5699, 6617, 7512, 8379, 9212, 10006, 10756, 11457, 12108, 12704, 13243, 13726, 14151, 14520, 14835, 
15099, 15315, 15487, 15621, 15722, 15796, 15849, 15888, 15917, 15944, 15974, 16011, 16059, 16122, 
16201, 16297, 16409, 16535, 16671, 16812, 16951, 17080, 17190, 17269, 17309, 17296, 17220, 17070, 
16835, 16507, 16077, 15540, 14893


10011, 9175, 8300, 7390, 6450, 5483, 4497, 3498, 2490, 1481, 476, -521, -1503, -2469, -3414, -4338, -5239, 
-6117, -6972, -7805, -8617, -9409, -10181, -10935, -11669, -12383, -13076, -13746, -14391, -15007, -15592, 
-16142, -16652, -17121, -17544, -17919, -18243, -18516, -18736, -18903, -19017, -19081, -19095, -19062, 
-18985, -18864, -18705, -18507, -18275, -18009, -17710, -17380, -17019, -16626, -16201, -15744, -15252, 
-14724, -14160, -13558, -12917, -12237, -11517, -10758, -9960, -9126, -8258, -7358, -6430, -5478, -4507, 
-3522, -2526, -1526, -526, 470, 1456, 2429, 3386, 4323, 5239, 6132, 7001, 7845, 8665, 9460, 10232, 10980, 
11705, 12407, 13086, 13741, 14371, 14975, 15549, 16093, 16601, 17072, 17501, 17886, 18224, 18511, 18746, 
18927, 19054, 19126, 19145, 19113, 19032, 18904, 18733, 18522, 18275, 17994, 17682, 17340, 16971, 16575, 
16151, 15698, 15216, 14700, 14150, 13563, 12937, 12270, 11560, 10807
*/

12226, 11260, 10060, 8656, 7095, 5438, 3750, 2099, 549, -847, -2050, -3040, -3815, -4393, -4809, -5112, 
-5360, -5614, -5933, -6369, -6961, -7731, -8683, -9801, -11052, -12388, -13752, -15078, -16304, -17373, 
-18237, -18867, -19248, -19387, -19308, -19050, -18667, -18217, -17762, -17358, -17055, -16887, -16871, 
-17007, -17276, -17645, -18064, -18477, -18824, -19048, -19098, -18938, -18545, -17915, -17062, -16018, 
-14827, -13546, -12233, -10949, -9747, -8670, -7746, -6986, -6383, -5914, -5539, -5211, -4873, -4469, 
-3948, -3270, -2407, -1348, -102, 1307, 2837, 4434, 6038, 7587, 9020, 10287, 11350, 12188, 12800, 13200, 
13422, 13511, 13525, 13522, 13562, 13696, 13963, 14387, 14974, 15710, 16566, 17495, 18440, 19340, 20132, 
20758, 21172, 21344, 21259, 20924, 20363, 19618, 18742, 17798, 16851, 15961, 15181, 14550, 14088, 13798, 
13663, 13648, 13705, 13773, 13789, 13691, 13424, 12944, 12226, 11260, 10060, 8656


};

int current_signal[128] = 
{
/*	
104, 104, 103, 103, 102, 101, 100, 98, 96, 94, 92, 89, 86, 84, 80, 77, 74, 70, 66, 62, 58, 
53, 49, 44, 40, 35, 30, 25, 20, 15, 10, 5, 0, -5, -10, -15, -20, -25, -30, -35, -40, -44, 
-49, -53, -58, -62, -66, -70, -74, -77, -80, -84, -86, -89, -92, -94, -96, -98, -100, -101, 
-102, -103, -103, -104, -104, -104, -103, -103, -102, -101, -100, -98, -96, -94, -92, -89, 
-86, -84, -80, -77, -74, -70, -66, -62, -58, -53, -49, -44, -40, -35, -30, -25, -20, -15, 
-10, -5, 0, 5, 10, 15, 20, 25, 30, 35, 40, 44, 49, 53, 58, 62, 66, 70, 74, 77, 80, 84, 86, 
89, 92, 94, 96, 98, 100, 101, 102, 103, 103, 104
*/
10752, 10732, 10672, 10573, 10437, 10267, 10063, 9831, 9572, 9291, 8989, 8672, 8341, 7998, 
7646, 7287, 6921, 6549, 6171, 5787, 5397, 4998, 4592, 4177, 3752, 3316, 2870, 2414, 1947, 
1471, 987, 496, 0, -499, -998, -1497, -1991, -2480, -2962, -3435, -3896, -4347, -4784, -5209, 
-5620, -6017, -6400, -6770, -7126, -7468, -7796, -8109, -8407, -8689, -8954, -9201, -9427, 
-9633, -9815, -9972, -10103, -10207, -10282, -10327, -10342, -10327, -10282, -10207, -10103, 
-9972, -9815, -9633, -9427, -9201, -8954, -8689, -8407, -8109, -7796, -7468, -7126, -6770, 
-6400, -6017, -5620, -5209, -4784, -4347, -3896, -3435, -2962, -2480, -1991, -1497, -998, 
-499, 0, 496, 987, 1471, 1947, 2414, 2870, 3316, 3752, 4177, 4592, 4998, 5397, 5787, 6171, 
6549, 6921, 7287, 7646, 7998, 8341, 8672, 8989, 9291, 9572, 9831, 10063, 10267, 10437, 10573, 
10672, 10732
};

//-----------------------------------------------------------------------
//  Function name: InitSPI()
//	Description:   initialize SPI module, call by main fuction
//  Author:			CADC
//  Create date:
//  Last modify:	3/10/06 by Jerry Gao	
//-----------------------------------------------------------------------
void InitSPI(void)
{    
//   ConfigIntSPI2(0x000f);  
   SPI2STATbits.SPIEN = 0;		// Enable SPI
   SPI2BUF = 0;  
   SPI2CON1bits.MSTEN = 1;		// Master mode
   SPI2CON2bits.FRMEN = 0;		// Frame support
   SPI2CON2bits.SPIFSD = 0;		 
   SPI2CON1bits.DISSDO = 0;
   SPI2CON1bits.MODE16 = 0;		// 16bits mode
   SPI2CON1bits.SMP = 0;
   SPI2CON1bits.CKE = 0;		// edge selection, requires by MCP3909
   SPI2CON1bits.CKP = 0;		// polar selection, requires by the MCP3909
   SPI2CON1bits.SSEN = 0;		// SSx pin not used by module.

	//clock setting
	//for Fcy = 29.4912M, the SPI clock is about 3.75M
   SPI2CON1bits.PPRE = 3;		// primary prescale: 1:1
   SPI2CON1bits.SPRE = 3;		// secondary prescale: 1:5

   SPI2STATbits.SPIROV = 0;  	// clear SPI recieve overflow flag
   SPI2STATbits.SPIEN = 1;		// Enable SPI
//	data_1[0] = SPI2BUF;		// Clear RBF flag
}



//********************************************************/
//  Function name: WrittingSPI()
//	Description:   
//  Author:			CADC
//  Create date:
//  Last modify:	1/11/06 	
//********************************************************/
void WrittingSPI(unsigned int data_out)
{   
    if (SPI2CON1bits.MODE16) 
    {        
        SPI2BUF = data_out;  /*word write*/ 
	}    
    else 
    {
        SPI2BUF = data_out & 0xff; /*byte write*/ 
    }

    while(SPI2STATbits.SPITBF == 1) 
    {
	}   
} 
/********************************************************/
 int ReadingSPI(void)
{         
    /* Check for Receive buffer full status bit of status register*/ 

    if (SPI2STATbits.SPIRBF)
    {  
           SPI2STATbits.SPIROV = 0; 
           return SPI2BUF;           /* return word read */
       
    }
    return -1;                  		/* RBF bit is not set return error*/
}  

//-----------------------------------------------------------------------
//  Function name: void InitMCP390x(void)
//	Description:   reset MCP3905/6 and enter test mode 4 
//  Author:			CADC
//  Create date:	
//  Last modify:	3/10/06 	
//-----------------------------------------------------------------------
void InitMCP390x(void)
{
  unsigned int k;

    MCP390X_MCLR = 0;			// reset MCP3905 first
	SPI2CON1bits.MODE16 = 0;	// 0/1 ->8bits/16bits

	ZeroValueCh[0] = 0;
	ZeroValueCh[1] = 0;
	ZeroValueCh[2] = 0;
	ZeroValueCh[3] = 0;
	ZeroValueCh[4] = 0;
	ZeroValueCh[5] = 0;
		
	Delay(10000);
	//select all three phase
	MCP390X_CS_PRT = MCP390X_CS_PRT & PABC_CS;
	MCP390X_MCLR = 1;

	Delay(18);					// wait for at least 4 MCP3905 CLK

	// send cmd for test mode 4 to 3905 within 32 clk
	//WrittingSPI(0xa4);		// in this mode, HPF is off							
	WrittingSPI(0xac);			// in this mode, HPF is on

	Delay(50);
	
	// select 3909 of phase A (wait for data ready pulse)
	MCP390X_CS_PRT = MCP390X_CS_PRT | PABC_NCS;
	MCP390X_CS_PRT = MCP390X_CS_PRT & PA_CS;

	Delay(2000);			

	SPI2STATbits.SPIEN = 0;		// Enable SPI
    SPI2CON1bits.MODE16 = 1;	// 0/1 ->8bits/16bits
	SPI2STATbits.SPIEN = 1;		// Enable SPI
}

//-----------------------------------------------------------------------
//  Function name: void ReadMCP390x(void)
//	Description:   read AD data from MCP3905/6  
//  Author:			Jerry Gao / CADC
//  Create date:	3/10/06 by Jerry Gao	
//  Last modify:	12/19/06 by Jemmey Huang	
//-----------------------------------------------------------------------
void ReadMCP390x(void)	
{	
	long temp_energy;
	int temp01, temp02, temp03;
	
	MCP390X_CS_PRT = MCP390X_CS_PRT | PABC_NCS;
	MCP390X_CS_PRT = MCP390X_CS_PRT & PA_CS;		// Select Phase A AD(3909)

	spi_temp = SPI2BUF;								// clear spi flag
	SPI2STATbits.SPIROV = 0;
	// read data from MCP3905 of phase A
	SPI2BUF = 0; 									// send data/produce clock


/*
	temp01 = voltage_signal[pointer++];
	temp02 = current_signal[pointer1++];
	
	if(pointer>=124)
	 pointer = 0;
	 
	if(pointer1>=124)
	 pointer1 = 0;
*/

	if(!flag.bits.temp_flag)
	{
		flag.bits.temp_flag = 1;
		while(!SPI2STATbits.SPIRBF)			 
		{}			
		//temp03 = SPI2BUF;								// voltage channel
		temp01 = SPI2BUF;								// voltage channel
		SPI2STATbits.SPIROV = 0;						// clear receive flag
		SPI2BUF = 0; 									// send data/produce clock
		while(!SPI2STATbits.SPIRBF)			 
		{}
		//temp03 = SPI2BUF;								// voltage channel	
		temp02 = SPI2BUF;								// current channel
		SPI2STATbits.SPIROV = 0;						// Clear flag
		
		// read data from MCP3905 of phase B
		MCP390X_CS_PRT = MCP390X_CS_PRT | PABC_NCS;		// Select Phase B AD(3909)
		MCP390X_CS_PRT = MCP390X_CS_PRT & PB_CS;
		asm("nop");
		
	    SPI2BUF = 0; 									// send data/produce clock
	    temp_energy = Multiply16x16(temp01, temp02);  
		while(!SPI2STATbits.SPIRBF)			
		{}
		temp01 = SPI2BUF;
		SPI2STATbits.SPIROV = 0;
		SPI2BUF = 0; 
		cycle_energy_buf[0] = cycle_energy_buf[0] + temp_energy;
		while(!SPI2STATbits.SPIRBF)			
		{}
		temp02 = SPI2BUF;
		SPI2STATbits.SPIROV = 0;
		
		// read data from MCP3905 of phase C
		MCP390X_CS_PRT = MCP390X_CS_PRT | PABC_NCS;		// Select Phase C AD(3909)
		MCP390X_CS_PRT = MCP390X_CS_PRT & PC_CS;
		asm("nop");
		
		SPI2BUF = 0; 
	    temp_energy = Multiply16x16(temp01, temp02);  
		while(!SPI2STATbits.SPIRBF)		
		{}
		temp01 = SPI2BUF;
		SPI2STATbits.SPIROV = 0;
		SPI2BUF = 0; 
		cycle_energy_buf[1] = cycle_energy_buf[1] + temp_energy;
		while(!SPI2STATbits.SPIRBF)		
		{}
		temp02 = SPI2BUF;	
	    temp_energy = Multiply16x16(temp01, temp02);  
		cycle_energy_buf[2] = cycle_energy_buf[2] + temp_energy;
	}
	else
	{
		flag.bits.temp_flag = 0;
		while(!SPI2STATbits.SPIRBF)			 
		{}
		//voltage_sample[0][DataNum] = temp01;	
		//temp01 = SPI2BUF;		
		voltage_sample[0][DataNum] = SPI2BUF; //temp01;				// voltage channel
		//	voltage_sample[0][DataNum] -= ZeroValueCh[0]; 		// not needed in mode 0xac
		SPI2STATbits.SPIROV = 0;						// clear receive flag
		SPI2BUF = 0; 									// send data/produce clock
		while(!SPI2STATbits.SPIRBF)			 
		{}
		//current_sample[0][DataNum] = temp02; //temp02; 
		//temp02 = SPI2BUF;			// current channel		
		current_sample[0][DataNum] = SPI2BUF; //temp02; 
		//	current_sample[0][DataNum] -= ZeroValueCh[1]; 
		SPI2STATbits.SPIROV = 0;						// Clear flag
		
		// read data from MCP3905 of phase B
		MCP390X_CS_PRT = MCP390X_CS_PRT | PABC_NCS;		// Select Phase B AD(3909)
		MCP390X_CS_PRT = MCP390X_CS_PRT & PB_CS;
		asm("nop");
		
	    SPI2BUF = 0; 									// send data/produce clock
	    temp_energy = Multiply16x16(current_sample[0][DataNum], voltage_sample[0][DataNum]);  
		while(!SPI2STATbits.SPIRBF)			
		{}
		voltage_sample[1][DataNum] = SPI2BUF;
		//	voltage_sample[1][DataNum] -= ZeroValueCh[2]; 
		SPI2STATbits.SPIROV = 0;
		SPI2BUF = 0; 
		cycle_energy_buf[0] = cycle_energy_buf[0] + temp_energy;
		while(!SPI2STATbits.SPIRBF)			
		{}
		current_sample[1][DataNum] = SPI2BUF;
		//	current_sample[1][DataNum] -= ZeroValueCh[3]; 
		SPI2STATbits.SPIROV = 0;
		
		// read data from MCP3905 of phase C
		MCP390X_CS_PRT = MCP390X_CS_PRT | PABC_NCS;		// Select Phase C AD(3909)
		MCP390X_CS_PRT = MCP390X_CS_PRT & PC_CS;
		asm("nop");
		
		SPI2BUF = 0; 
	    temp_energy = Multiply16x16(current_sample[1][DataNum], voltage_sample[1][DataNum]);  
		while(!SPI2STATbits.SPIRBF)		
		{}
		voltage_sample[2][DataNum] = SPI2BUF;
		//	voltage_sample[2][DataNum] -= ZeroValueCh[4];
		SPI2STATbits.SPIROV = 0;
		SPI2BUF = 0; 
		cycle_energy_buf[1] = cycle_energy_buf[1] + temp_energy;
		while(!SPI2STATbits.SPIRBF)		
		{}
		current_sample[2][DataNum] = SPI2BUF;
		//	current_sample[2][DataNum] -= ZeroValueCh[5]; 
		
	    temp_energy = Multiply16x16(current_sample[2][DataNum], voltage_sample[2][DataNum]);  
		cycle_energy_buf[2] = cycle_energy_buf[2] + temp_energy;
			
		DataNum++;							// wait for the next data
		if(DataNum >= BUF_SIZE)				// loop back to the begin of cycle buffer
		 DataNum = 0;
	
		LeftDataNum++;
		if((LeftDataNum >= DataNum_Cycle3)&&(!flag.bits.DataReady2Cal))			// complete sampling
		{
			 flag.bits.DataReady2Cal = 1;
			 cycle_energy[0] = cycle_energy_buf[0];
			 cycle_energy[1] = cycle_energy_buf[1];
			 cycle_energy[2] = cycle_energy_buf[2];
			 cycle_energy_buf[0]=0;
			 cycle_energy_buf[1]=0;
			 cycle_energy_buf[2]=0;
			 		 
		}
	}
	
	SPI2STATbits.SPIROV = 0;
	MCP390X_CS_PRT = MCP390X_CS_PRT | PABC_NCS;
	MCP390X_CS_PRT = MCP390X_CS_PRT & PA_CS;			 
}




void gain_control(int phase, int gain)
{
/*
	this routine change the Gain of current channel
	input:
			phase - 1: select phase A, 2: select phase B, 3: select phase C
			gain - 0: Gain = 1; 1: Gain = 2; 3: Gain = 8; 4: Gain = 16;
*/	
	if(phase == PHASE_A)
	{
		if(gain==0)
		{
			G0A = 0;
			G1A = 0;			
		}
		else if(gain==1)
		{
			G0A = 1;
			G1A = 0;			
		}
		else if(gain==3)
		{
			G0A = 0;
			G1A = 1;			
		}
		else if(gain==4)
		{
			G0A = 1;
			G1A = 1;			
		}
		ZeroValueCh[0] = 0;
		ZeroValueCh[1] = 0;			
	}
	else if(phase == PHASE_B)
	{
		if(gain==0)
		{
			G0B = 0;
			G1B = 0;			
		}
		else if(gain==1)
		{
			G0B = 1;
			G1B = 0;			
		}
		else if(gain==3)
		{
			G0B = 0;
			G1B = 1;			
		}	
		else if(gain==4)
		{
			G0B = 1;
			G1B = 1;			
		}
		ZeroValueCh[2] = 0;
		ZeroValueCh[3] = 0;				
	}
	else if(phase == PHASE_C)
	{
		if(gain==0)
		{
			G0C = 0;
			G1C = 0;			
		}
		else if(gain==1)
		{
			G0C = 1;
			G1C = 0;			
		}
		else if(gain==3)
		{
			G0C = 0;
			G1C = 1;			
		}
		else if(gain==4)
		{
			G0C = 1;
			G1C = 1;			
		}
		ZeroValueCh[4] = 0;
		ZeroValueCh[5] = 0;			
	}	
}



