//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jemmey Huang								 *
// *				   CAE	  Gloria Xie								 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *	File name:	   uart.c											 *
// * 	File description: uart communication with host PC		 		 *
// **********************************************************************/

#define _UART_C
#include <math.h>
#include <dsp.h>
#include "global.h"
#include "MCP390x.h"
#include "calcu.h"
#include "uart_comm.h"
#include <uart.h>
#undef _UART_C 

/***********************************************************
/*
/* constant for uart baudrate setting   */
//#define  	BRGH_9K6_32M		207
//#define  	BRGH_4K8_8M		26
/* constant for uart data frame  */
// frame header 
#define	FRAME_HEADER_HEAD0	0xff
#define	FRAME_HEADER_HEAD1	0x00

#define	EOF		0xe0

//frame length
#define	FRAME_FrmLth_FRAME0	0x00
#define	FRAME_FrmLth_FRAME1	0x00
#define	FRAME_FrmLth_FRAME2	0x00
#define	FRAME_FrmLth_FRAME3	0x00
#define	FRAME_FrmLth_FRAME4	0x00
#define	FRAME_FrmLth_FRAME5	0x00
#define	FRAME_FrmLth_FRAME6	0x00
#define	FRAME_FrmLth_FRAME7	0x00
#define	FRAME_FrmLth_FRAME8	0x00

#define	FRAME_FrmLth_FRAME9	 7
#define	FRAME_FrmLth_FRAME10 6
#define	FRAME_FrmLth_FRAME11 6
#define	FRAME_FrmLth_FRAME12 2
#define	FRAME_FrmLth_FRAME13 4
#define	FRAME_FrmLth_FRAME14 2
#define	FRAME_FrmLth_FRAME15 2

// frame command from PC to object board
#define	FRAME_CMD_FRAME0	'A'
#define	FRAME_CMD_FRAME1	'B'
#define	FRAME_CMD_FRAME2	'C'
#define	FRAME_CMD_FRAME3	'D'
#define	FRAME_CMD_FRAME4	'E'
#define	FRAME_CMD_FRAME5	'F'
#define	FRAME_CMD_FRAME6	'G'
#define	FRAME_CMD_FRAME7	'H'
#define	FRAME_CMD_FRAME8	'I'

#define	FRAME_CMD_FRAME9	'b'
#define	FRAME_CMD_FRAME10	'c'
#define	FRAME_CMD_FRAME11	'd'
#define	FRAME_CMD_FRAME12	'e'
#define	FRAME_CMD_FRAME13	'f'
#define	FRAME_CMD_FRAME14	'g'
#define	FRAME_CMD_FRAME15	'h'

// max length of a frame
#define	FRAME_Max_Length		0xA0

//*****************************************
/* define following variable in data memory  */
//***************************************** 

	unsigned char Rec_Data;
	unsigned char Command_ID;		// Command type of current receiving frame  
	unsigned char Data_Len_Count;	// Length of current receiving frame  
	unsigned char Check_Sum=0;		// Current Checksum(receiving process)
	unsigned char Tx_Count;			// transmit byte counter
	unsigned char *Tx_Ptr;				// transmit buffer pointer
	unsigned char UART_Rx_Timer;	// timer to count when every frame receiving begining 

	volatile union
{
	unsigned char BYTE;
	struct
	{
		unsigned	Head0:	1;		// flag of got Header0	 		-----	00
		unsigned	Head1:	1;		// flag of got Header1	 		-----	00
    	unsigned 	CMD:	1;		// flag of got Data ID  		
   	 	unsigned  	FrmLth:	1;		// flag of got Frame Length 	
  	  	unsigned	DtFld:	1;		// flag of got Data Field	 
    	unsigned 	Chksum:	1;		// flag of got Checksum
   	 	unsigned 	End:	1;		// flag of got the End of the frame
   	 	unsigned	Frame:	1;		// flag of successfully received a frame, this flag is shared
									// in other application,here it's the same as Rec_Flag.End
    	}; 
  }Rec_Flag;		

	unsigned char uart_buf[15];	//receiving buffer,0xa0 is the max length of a frame  
   

//********************************************************
void InitUart(void) 
{  
	//
	U1MODE = 0x8800 ;

	U1STA = 0x2400 ;
	U1BRG =0X5F ;				// Baud-Rate = 19200 when Fcy = 16M , BRGH = 0 

	Ctrl_U1RX = INPUT ;
	Ctrl_U1TX = OUTPUT ;

	IFS0bits.U1RXIF = 0;  
	IFS0bits.U1TXIF = 0; 
	IPC2bits.U1RXIP = 2;		//RXIP
	IPC3bits.U1TXIP = 2; 		//TXIP
	IEC0bits.U1RXIE = 1;		//enable Rx interrupt
	IEC0bits.U1TXIE = 0;		//disable TX interrupt


}


/***** Pls place the text of next routine into the main ISR  *****/
//UART receive ISR
//**********************************************************
void UART_Receive(void)
	{
		Rec_Data = U1RXREG;		//ReadUART1();					// Get RS-232 data; clear RCIF
		uart_buf[Rx_Count] = Rec_Data;
		Rx_Count++;

		if(Rx_Count > 15)
		{
			Rx_Count = 0;
			Rec_Flag.BYTE = 0;				// The data being received is not header1, back to non-receive status
			Check_Sum = 0;
			UART_Rx_Timer =0;
			return;
		}

		Check_Sum ^= Rec_Data;					// Count the checksum whenever new data received
		if(!Rec_Flag.Head0)						// Not got header0 --- 0x00
		{
			if(Rec_Data == FRAME_HEADER_HEAD0)
			{
				Rec_Flag.Head0 = 1;				// Indicating header0 got	
				Check_Sum = 0;
			}

			UART_Rx_Timer = 0;				
		}
		else if(!Rec_Flag.Head1)				// Not got header1--- 0xff
		{
			if(Rec_Data == FRAME_HEADER_HEAD1)
				Rec_Flag.Head1 = 1;				// Indicating header1 got
			else
			{
				Rec_Flag.BYTE = 0;				// The data being received is not header1, back to non-receive status
				Check_Sum = 0;
				UART_Rx_Timer =0;
				Rx_Count = 0;
			}
		}
		else if(!Rec_Flag.CMD)						// Not got ID
		{											// aaudge the ID legality here
			Rec_Flag.CMD = 1;
			UART_Rx_Timer =1;
			switch(Rec_Data)
			{
				case (FRAME_CMD_FRAME0):					//frame0?
					Command_ID = FRAME_CMD_FRAME0;
					Data_Len_Count = FRAME_FrmLth_FRAME0;						// the next receive data byte will be frame length
					break;

				case (FRAME_CMD_FRAME1):					//frame1?
					Command_ID = FRAME_CMD_FRAME1;
					Data_Len_Count = FRAME_FrmLth_FRAME1;						// the next receive data byte will be frame length
					break;

				case (FRAME_CMD_FRAME2):					//frame2?
					Command_ID = FRAME_CMD_FRAME2;
					Data_Len_Count = FRAME_FrmLth_FRAME2;						// the next receive data byte will be frame length
					break;

				case (FRAME_CMD_FRAME3):					//frame3?
					Command_ID = FRAME_CMD_FRAME3;
					Data_Len_Count = FRAME_FrmLth_FRAME3;						// the next receive data byte will be frame length
					break;

				case (FRAME_CMD_FRAME4):					//frame4?
					Command_ID = FRAME_CMD_FRAME4;
					Data_Len_Count = FRAME_FrmLth_FRAME4;						// the next receive data byte will be frame length
					break;

				case (FRAME_CMD_FRAME5):					//frame5?
					Command_ID = FRAME_CMD_FRAME5;
					Data_Len_Count = FRAME_FrmLth_FRAME5;
					break;

				case (FRAME_CMD_FRAME6):					//frame6?
					Command_ID = FRAME_CMD_FRAME6;
					Data_Len_Count = FRAME_FrmLth_FRAME6;
					break;							
				
				case (FRAME_CMD_FRAME7):					//frame7?
					Command_ID = FRAME_CMD_FRAME7;
					Data_Len_Count = FRAME_FrmLth_FRAME7;						// the next receive data byte will be frame length
					break;
					
	/*			case (FRAME_CMD_FRAME8):					//frame8?
					Command_ID = FRAME_CMD_FRAME8;
					Data_Len_Count = FRAME_FrmLth_FRAME8;
					break;
	*/		
				case (FRAME_CMD_FRAME8):					//frame11?
					Command_ID = FRAME_CMD_FRAME8;
					Data_Len_Count = FRAME_FrmLth_FRAME8;
					break;	
	
			
				case (FRAME_CMD_FRAME9):					//frame9?
					Command_ID = FRAME_CMD_FRAME9;
					Data_Len_Count = FRAME_FrmLth_FRAME9;
					break;							

				case (FRAME_CMD_FRAME10):					//frame10?
					Command_ID = FRAME_CMD_FRAME10;
					Data_Len_Count = FRAME_FrmLth_FRAME10;
					break;
					

				case (FRAME_CMD_FRAME11):					//frame11?
					Command_ID = FRAME_CMD_FRAME11;
					Data_Len_Count = FRAME_FrmLth_FRAME11;
					break;
					
				case (FRAME_CMD_FRAME12):					//frame12?
					Command_ID = FRAME_CMD_FRAME12;
					Data_Len_Count = FRAME_FrmLth_FRAME12;
					break;

				case (FRAME_CMD_FRAME13):					//frame13?
					Command_ID = FRAME_CMD_FRAME13;
					Data_Len_Count = FRAME_FrmLth_FRAME13;
					break;
					
				case (FRAME_CMD_FRAME14):					//frame14?
					Command_ID = FRAME_CMD_FRAME14;
					Data_Len_Count = FRAME_FrmLth_FRAME14;
					break;
					
				case (FRAME_CMD_FRAME15):					//frame14?
					Command_ID = FRAME_CMD_FRAME15;
					Data_Len_Count = FRAME_FrmLth_FRAME15;
					break;	
																													
				default:
					Rec_Flag.BYTE = 0;				// The data being received is not header1, back to non-receive status
					Check_Sum = 0;
					UART_Rx_Timer = 0;
					Rx_Count = 0;
					break;				
			}
		}
		else if(!Rec_Flag.FrmLth)	
		{
			if(Rec_Data == Data_Len_Count )
			{
				Rec_Flag.FrmLth = 1;
				UART_Rx_Timer = 1;								//******************************************
	//			Data_Len_Count = Data_Len_Count - 6;				// next will receive Data_Len_Count bytes of data filed
				Data_Len_Count = Data_Len_Count ;
				if(Data_Len_Count==0)
				{	Rec_Flag.DtFld=1;}
			}
			else
			{
				Rec_Flag.BYTE = 0;				
				Check_Sum = 0;
				Rx_Count = 0;
				UART_Rx_Timer =0;
			}
		}
		else if(!Rec_Flag.DtFld)
		{
			Data_Len_Count--;								// still receiving data field
			if(!Data_Len_Count)								// this is the last byte of data field
			{
				Rec_Flag.DtFld = 1;						// all data filed received, set the flag
			}			
		}
		else if(!Rec_Flag.Chksum)
		{
			if(Check_Sum ==0 )							// Check_Sum has aaust xored with the received checksum
			{
				Rec_Flag.Chksum = 1;
			}
			else
			{
				Rec_Flag.BYTE = 0;				// The data being received is not header1, back to non-receive status
				Check_Sum = 0;
				UART_Rx_Timer =0;
				Rx_Count = 0;
			}			
		}
		else if(!Rec_Flag.End)
		{
			
			if(Rec_Data == EOF)
			{
				Rec_Flag.BYTE = 0;				// The data being received is not header1, back to non-receive status
				Rec_Flag.End = 1;	
				Rec_Flag.Frame = 1;				// marking a frame's been  successfully received
				IEC0bits.U1RXIE=0;				// Disable RxD Interrupt
			//	U1MODEbits.UARTEN = 0;
			}
			else
			{
				Rec_Flag.BYTE = 0;				// The data being received is not header1, back to non-receive status
				Check_Sum = 0;
				Rx_Count = 0;
			}

			UART_Rx_Timer =0;				
		}		
	}

/*********************************************************************
Function Name:	UART_HandleRightFrame
Function Use:	Handle a successfully received frame
Parameter in:		The data ID of the frame
Parameter out:	none
//*********************************************************************/
void UART_HandleRightFrame(unsigned char ucDt)
{		
unsigned char i;
unsigned char para1, para2, para3;
unsigned int para4;

	uart_buf[0] = 0xff;								//header0
	uart_buf[1] = 0x00;								//header1
	Check_Sum = 0;

		switch(ucDt)
		{
			case FRAME_CMD_FRAME0:
				Tx_Count=	9 ;
				uart_buf[2] = 'B';								//data ID
				uart_buf[3] = 2;
				uart_buf[4] = 0x5a;
				uart_buf[5] = 0xa5;
				Data_Len_Count = Tx_Count;
				Tx_Ptr = &uart_buf[4];
				break;

			case FRAME_CMD_FRAME1:				//frame1, to send back  the 76byte data
				Tx_Count=	105;
				uart_buf[2] = 'C';								//data ID
				uart_buf[3] = 98;
				Data_Len_Count = Tx_Count;
				Tx_Ptr = &gds.data.Frequency;
				break;	
		
			case FRAME_CMD_FRAME2:				//frame2, to send back phase A harmonic paramenters
				Tx_Count=	135;
				uart_buf[2] = 'D';								//data ID
				uart_buf[3] = 128;
				Data_Len_Count = Tx_Count;
				Tx_Ptr = &harmonicMag[0][0];
				break;

			case FRAME_CMD_FRAME3:				//frame3, to send back  phase B harmonic paramenters			
				Tx_Count=	135;
				uart_buf[2] = 'E';								//
				uart_buf[3] = 128;
				Data_Len_Count = Tx_Count;
				Tx_Ptr =  &harmonicMag[2][0];//.array[0];	//Phase B data
				break;

			case FRAME_CMD_FRAME4:				//frame4, to send back  phase C harmonic paramenters			
				Tx_Count=	135;
				uart_buf[2] = 'F';								//data ID
				uart_buf[3] = 128;
				Data_Len_Count = Tx_Count;
				Tx_Ptr =  &harmonicMag[4][0];//.array[0];
				break;
				
			case FRAME_CMD_FRAME5:					//frame5, to send back the distortioin wave parameter			
				Tx_Count=	31;
				uart_buf[2] = 'G';								//
				uart_buf[3] = 24;
				Data_Len_Count = Tx_Count;
				Tx_Ptr =  &gds.data.TotalHarmonic.voltage[0];												//
				break;	

			case FRAME_CMD_FRAME6:					//frame6, to send back the energy data 			
				Tx_Count=	43;
				uart_buf[2] = 'H';								//
				uart_buf[3] = 36;
				Data_Len_Count = Tx_Count;
				Tx_Ptr = &gds.data.Energy.Q1;//		
				break;

			case FRAME_CMD_FRAME7:				//frame7, to send back ACK
				Tx_Count=	7;
				uart_buf[2] = 'I';				//
				uart_buf[3] =  0;
				Data_Len_Count = Tx_Count;				

				gds.data.Energy.Q1 =0;
				gds.data.Energy.Q2 =0;
				gds.data.Energy.Q3 =0; 
				gds.data.Energy.Q4 =0;
				
				gds.data.Energy.Total_Active =0;		
				gds.data.Energy.Forward_Active =0;
				gds.data.Energy.Reverse_Active =0;
				gds.data.Energy.Forward_ReActive =0;				
				gds.data.Energy.Reverse_ReActive = 0;
				
				break;


			case FRAME_CMD_FRAME8:					//frame8, to send back the harmonic power data 			
				Tx_Count=	55;
				uart_buf[2] = 'J';								//
				uart_buf[3] = 48;
				Data_Len_Count = Tx_Count;
				Tx_Ptr = &gds.data.Power.Fundemental_ActPwr[0];//		
				break;
				

			case FRAME_CMD_FRAME9:						//frame9, to send back the ack	
				for(i=0;i<4;i++)
				{
					trans.byte_array[i] = uart_buf[7+i];
				}
				para1 = uart_buf[4];
				para2 = uart_buf[5];
				para3 = uart_buf[6];			
						
				Tx_Count = 7;
				uart_buf[2] = 'c';								//
				uart_buf[3] =  0;
				Data_Len_Count = Tx_Count;	
				
				CalibrateLinear(para1, para2, para3, trans.float_data);						
				break;	

			case FRAME_CMD_FRAME10:						//frame10, to send back the ack	

				for(i=0;i<4;i++)
				{
					trans.byte_array[i] = uart_buf[6+i];
				}
				para1 = uart_buf[4];
				para2 = uart_buf[5];
				
				Tx_Count = 7;
				uart_buf[2] = 'd';								//
				uart_buf[3] =  0;
				Data_Len_Count = Tx_Count;
				
				CalibratePhase(para1, para2, trans.float_data);
				
				break;	
				
			case FRAME_CMD_FRAME11:						//frame11, to send back the ack	

				for(i=0;i<4;i++)
				{
					trans.byte_array[i] = uart_buf[6+i];
				}
				para1 = uart_buf[4];
				para2 = uart_buf[5];
								
				Tx_Count = 7;
				uart_buf[2] = 'e';								//
				uart_buf[3] =  0;
				Data_Len_Count = Tx_Count;

				CalibratePower(para1, para2, trans.float_data);
				
				break;	
				
			case FRAME_CMD_FRAME12:						//frame12\, to send back the ack	

				if((uart_buf[4]<4)&&(uart_buf[5]<2))
				{
					pulse_generator.EnergyCumulateChannel = uart_buf[4];
					pulse_generator.EnergyCumulateMode = uart_buf[5];
					
					flag.bits.ResetEnergy = 1;		
				}	
			
				Tx_Count = 7;
				uart_buf[2] = 'f';								//
				uart_buf[3] =  0;
				Data_Len_Count = Tx_Count;
				
				break;
					
			case FRAME_CMD_FRAME13:						//frame12\, to send back the ack	
				
				para1 = uart_buf[4];
				para2 = uart_buf[5];
				para3 = uart_buf[6];
							
				Tx_Count = 7;
				uart_buf[2] = 'g';								//
				uart_buf[3] =  0;
				Data_Len_Count = Tx_Count;
				
				Reset_Calibration(para1, para2, para3);
				
				break;	
				
			case FRAME_CMD_FRAME14:							
				
				para1 = uart_buf[4];
				para2 = uart_buf[5];				
				para4 = uart_buf[4]+uart_buf[5]*256;
							
				Tx_Count = 7;
				uart_buf[2] = 'h';								//
				uart_buf[3] =  0;
				Data_Len_Count = Tx_Count;
				
				integrate_limitation = 1000.0/para4;
				pulse_const = para4;
				//EEPROM_ByteWrite(0xa0, 0, 240, para1);
				//EEPROM_ByteWrite(0xa0, 0, 241, para2);
				while(I2C_ACKPolling(0xa0))
				{		
				}			
				E2prom_WritePage(0xa0, 0, 240, &uart_buf[4]);
				break;	
								
			case FRAME_CMD_FRAME15:			//set work mode				
						
				Tx_Count = 7;
				uart_buf[2] = 'i';								//
				uart_buf[3] =  0;
				Data_Len_Count = Tx_Count;

				while(I2C_ACKPolling(0xa0))
				{		
				}			
				E2prom_WritePage(0xa0, 0, 248, &uart_buf[4]);
				
				work_mode = uart_buf[4];
				break;					
										

			default:
				break;

	}
		U1STAbits.UTXEN = 0;
		asm("nop");
		asm("nop");
		U1STAbits.UTXEN = 1;
		UART_Transmit();
		IEC0bits.U1TXIE = 1;		//enable TX interrupt
}
//**********************************************

void UART_Transmit(void)
{
	if(Tx_Count)	//if transmit buffer has data to send, send it out
	{
		asm("nop");
		asm("nop");

//		if(U1STAbits.TRMT)
		{
			if(Tx_Count >  Data_Len_Count -4)
			{	
				Check_Sum^=uart_buf[Data_Len_Count-Tx_Count];
				WriteUART1(uart_buf[Data_Len_Count-Tx_Count]);
			}
			else if(Tx_Count > 3)
		 	{
				 Check_Sum^= *Tx_Ptr;
			 	WriteUART1(*Tx_Ptr++);
		 	}
			else if(Tx_Count ==3)
			{
						 WriteUART1(Check_Sum)	;
			}
			else if(Tx_Count == 2)
			{
				WriteUART1(EOF);
			}
			else if(Tx_Count == 1)
			{
			 	 Tx_Ptr = 0;
				 IEC0bits.U1TXIE = 0;		// Disable TXD interrupt
				 IFS0bits.U1RXIF = 0; 
				 IEC0bits.U1RXIE = 1;		// Enable RxD Interrupt
			}	
		
			Tx_Count--;					
		}
	}	
}

//*************************************************
// this routine to be called by main
//*************************************************
void process_UART( void)
{
	if(Tx_Count)		
		IEC0bits.U1TXIE = 1;		//enable TX interrupt
	else
		IEC0bits.U1TXIE = 0;		//enable TX interrupt
		
	if(UART_Rx_Timer>10)		//frame receiving overtime 
	{
		Rec_Flag.BYTE = 0;	//reset state
		Check_Sum = 0;
		Rx_Count = 0;
		UART_Rx_Timer = 0;		
	}

	if(Rec_Flag.Frame)	// if successfully received a frame?
	{
		Rec_Flag.BYTE = 0;
		Check_Sum = 0;
		Rx_Count = 0;
		UART_HandleRightFrame(Command_ID);		// pass the Data ID of the frame so as to be able to receive next frame  while handling current frame
	}

	if(U1STAbits.FERR)
	{
		U1STAbits.FERR = 0;

		Rec_Flag.BYTE = 0;
		Check_Sum = 0;
		Rx_Count = 0;
	}
	
	if(U1STAbits.OERR)
	{
		U1STAbits.OERR = 0;

		IEC0bits.U1RXIE = 1;						// Enable RxD Interrupt
	//	RCSTAbits.CREN=1;
		Rec_Flag.BYTE = 0;
		Check_Sum = 0;
		Rx_Count = 0;
	}
}
 
