#include <p33FJ128GP206.h>
#include "global.h"
#include "mcp390x.h"
#include "interrupt.h"

unsigned char ADCount=0;


/*---------------------------------------------------------------------
  Function Name: Init_ADC
  Description:   Initialize ADC module
  Inputs:        None
  Returns:       None
-----------------------------------------------------------------------*/
void Init_ADC( void )
{
	ADCount=0;
/* set port configuration here */ 		
 	AD1PCFGLbits.PCFG12 = 0;         // ensure AN12/RB12 is analog (Temp Sensor)
 
 	/* set channel scanning here, auto sampling and convert,   with default read-format mode */
	AD1CON1 = 0b0000000001000100; //SSRC=111, auto convert; ASAM=1, auto sample
	/* select 12-bit, 1 channel ADC operation */
	AD1CON1bits.AD12B = 1;
	
	/* enable DMA mode (ADC module sends all results 
	   to ADBUF0 and interrupts on each result */
	AD1CON2 = 0x0000;		// SMPI=0 per interrupt
	/* Set Samples and bit conversion time */
	AD1CON3 = 0x1F3F; 	//ԶʱSAMC=31Tad,  ADCS/ADתʱ=64Tcy

	AD1CON4 = 0x0000;        	
	/* set channel scanning here for AN4 and AN5 */
	AD1CSSL = 0x0000;
	AD1CSSH = 0x0000;
	
	AD1CHS123 = 0x000;
	
	AD1CHS0 = 0x0c;
//	/* channel select AN12 */

	/* reset ADC interrupt flag */
	IFS0bits.AD1IF = 0;           
	/*set AD1 interrupt level =7;*/
	
	IPC3bits.AD1IP=2;
	/* enable ADC interrupts, disable this interrupt if the DMA is enabled */	  
	IEC0bits.AD1IE = 1;       

	/* turn on ADC module */
	AD1CON1bits.ADON = 1;          	
}

/*---------------------------------------------------------------------
  Function Name: 	ADC_Calc();
  Description:   Accumulate ADC values and set flages if  count 64 samples
  Inputs:        None
  Returns:       None
-----------------------------------------------------------------------*/
void	ADC_Calc(void)
{
	long amplitude;
	neutral_current_sample[ADCount++]=ADC1BUF0;
	if(ADCount==64)
	{
		ADCount = 0;
		flag.bits.ADCReadyFlag = 1;
		PR3 = T2_PRD;	
		AD1CON1bits.ADON = 0;
		IEC0bits.AD1IE = 0;       		        	
	}
//	LED = 0;
	

}


