
//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jemmey huang								 *
// *    Date:          11/29/06                                          *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p33fj64gp206.gld   								 *
// *                                                                     *
// *	File name:	   Calibrate.c										 *
// * 	File description: header file for calcu.c				         *
// **********************************************************************/

#define _CALIBRATE_C
	#include <math.h>
	#include <dsp.h>
	#include "global.h"
	#include "MCP390x.h"
	#include "uart_comm.h"
	#include "interrupt.h"
	#include "calibrate.h"
#undef _CALIBRATE_C  


void update_LNR_Coeff()
{
	unsigned char i;
	
  	//	LED = !LED;
	
	Coeff.data.linear.checksum = 0;
	for(i=0;i<18;i++)		//calculate the check sum
	Coeff.data.linear.checksum += Coeff.array[i];
	
	Coeff.data.linear.checksum = ~Coeff.data.linear.checksum;
			
	for(i=0;i<5;i++)
	{
		while(I2C_ACKPolling(0xa0))
		{		
		}		
		E2prom_WritePage(0xa0, 0, i*8, &Coeff.array[i*4]);
	}	
}

void update_Region_Coeff(unsigned char i)
{
	unsigned int j,k;

  	//	LED = !LED;
	k = (i+1)*19;	//start address in memory
	
  	Coeff.data.region[i].checksum = 0;
 	for(j=0;j<18;j++)		//calculate the check sum,totally 12 words
 		Coeff.data.region[i].checksum += Coeff.array[j+k];	//(i+1)*13 is the start address of phase_lag[i]

	Coeff.data.region[i].checksum = ~Coeff.data.region[i].checksum;
	if(i<5)	
	{
		for(j=0;j<5;j++)
		{
			while(I2C_ACKPolling(0xa0))
			{		
			}		
			E2prom_WritePage(0xa0, 0, ((i+1)*40)+j*8, &Coeff.array[j*4+k]);
		}
	}
	else
	{
		for(j=0;j<5;j++)
		{
			while(I2C_ACKPolling(0xa0))
			{		
			}		
			E2prom_WritePage(0xa0, 1, ((i-5)*40)+j*8, &Coeff.array[j*4+k]);
		}		
	}		
}


void CalibrateLinear(unsigned char phase_num, unsigned char IRegion, unsigned char channel, float reference_value)
{
//-----------------------------------------------------------------------/
//  Function name: void CalibrateLinear(void)
//	Description:   calibrate the system  
//  Author:			CADC
//  Create date:	3/27/06 	
//  Last modify:	12/07/06 by Jemmey Huang
//-----------------------------------------------------------------------/

   unsigned char i,j,error; 
   float Out, temp00;
   unsigned char calibarte_type;
   
   i= phase_num-1;
 
   error = 0;
   if(channel==1)
   {
	  	 Out = gds.data.Rms.PhaseVoltage[i];
	  	 temp00 = Coeff.data.linear.V_channel[i]*((float)(reference_value))/Out;
//	  	 if((temp00>VOTAGE_CH_COEF*2)||(temp00<VOTAGE_CH_COEF/2))
//	  	 error = 1;
   }	  	 
   else
   {
	     Out = gds.data.Rms.PhaseCurrent[i];
	     if(IRegion==2)
	     temp00 = Coeff.data.linear.C_channel[1][i]*((float)(reference_value))/Out;
	     else
	     temp00 = Coeff.data.linear.C_channel[0][i]*((float)(reference_value))/Out;
	     
//	  	 if((temp00>CURRENT_CH_COEF*2)||(temp00<CURRENT_CH_COEF/2))
//	  	 error = 1;	     
	}     
  
   if(!error)
   {
   	  if(channel&1)//voltage
			Coeff.data.linear.V_channel[i] = temp00; // calculate new kc				
	  else
	  {
		   calibarte_type = CALIBRATE_LINEAR_POINT;
		   if(calibarte_type==2)
		   {
			   if(IRegion==2)
				 Coeff.data.linear.C_channel[1][i] = temp00; // calculate new kc
			   else if(IRegion==1)
				 Coeff.data.linear.C_channel[0][i] = temp00; // calculate new kc
			}
			else
			{
				Coeff.data.linear.C_channel[1][i] = temp00; // calculate new kc
				Coeff.data.linear.C_channel[0][i] = temp00;
			}  
		}
	   update_LNR_Coeff(); 
	}	    
}

void CalibratePower(unsigned char phase_num, unsigned char IRegion, float error)
{
	/*
			err = (P'-P)/P, so P = P'/(1+err)
			err<0, means measurement value small than real value
			err>0, means measurement value large than real value	
	*/
   unsigned char calibarte_type, i;

	if((error>50)||(error<-50))
	  return;
	  
	if(gds.data.Power.TotalPwrFactor<0.99)
	 return;	  

	if(gds.data.Rms.PhaseCurrent[0]>0.005*Ib)
	 phase_num = 1;
	else if(gds.data.Rms.PhaseCurrent[1]>0.005*Ib)
	 phase_num = 2;
	else if(gds.data.Rms.PhaseCurrent[2]>0.005*Ib)
	 phase_num = 3;
	else
	 return;
	 	 
	if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN01)
	 IRegion = 1;
	else if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN12)
	 IRegion = 2;
	else if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN23)
	 IRegion = 3;	
	else if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN34)
	 IRegion = 4;
	else if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN45)
	 IRegion = 5;
	else if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN56)
	 IRegion = 6;	 	 		 	 	
	else
	 IRegion = 7;
	 
	 	
    calibarte_type = CALIBRATE_PHASE_POINT;
	if(calibarte_type==5)////five points calibration for phase lag
	{
		Coeff.data.region[IRegion-1].KP[phase_num-1] = Coeff.data.region[IRegion-1].KP[phase_num-1]*100.0/(error+100.0);
	}
	else if(calibarte_type==2)//two points calibration for phase lag
	{
		if((IRegion>0)&&(IRegion<4))
		{
			for(i=0;i<2;i++)
				Coeff.data.region[i].KP[phase_num-1] = Coeff.data.region[i].KP[phase_num-1]*100.0/(error+100.0);
		}
		else
		{
			for(i=2;i<5;i++)
				Coeff.data.region[i].KP[phase_num-1] = Coeff.data.region[i].KP[phase_num-1]*100.0/(error+100.0);
		}		
	}
	
	update_Region_Coeff(IRegion-1);
}

void CalibratePhase(unsigned char phase_num, unsigned char IRegion, float error)
{
//-----------------------------------------------------------------------/
//  Function name: void CalibratePhase(void)
//	Description:   calibrate phase angle error 
//  input:		IRegion - the current zone, range = 0~4
//				phase_num - phase A or phase B or phase C, range = 0~2
//				error - the error of measurement, value = (P' - P)/P, 
//						where P' is the measurement value, and P is the true value 
//  Author:			CADC
//  Create date:	11/29/06 	by Jemmey huang
//-----------------------------------------------------------------------/	
	unsigned char i;
    unsigned char calibarte_type;	
	float temp1, temp2;
	float delta_phi, sin_phi, cos_phi;// tan_phi;

	if((error>10)||(error<-10))
	  return;
	
	if((gds.data.Power.TotalPwrFactor>0.515)||(gds.data.Power.TotalPwrFactor<0.485))
	 return;

	if(gds.data.Rms.PhaseCurrent[0]>0.005*Ib)
	 phase_num = 1;
	else if(gds.data.Rms.PhaseCurrent[1]>0.005*Ib)
	 phase_num = 2;
	else if(gds.data.Rms.PhaseCurrent[2]>0.005*Ib)
	 phase_num = 3;
	else
	 return;
	 
	if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN01)
	 IRegion = 1;
	else if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN12)
	 IRegion = 2;
	else if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN23)
	 IRegion = 3;	
	else if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN34)
	 IRegion = 4;
	else if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN45)
	 IRegion = 5;
	else if(gds.data.Rms.PhaseCurrent[phase_num-1]<IRN56)
	 IRegion = 6;	 	 		 	 	
	else
	 IRegion = 7;
	 
	//error = error/100.0;
	//temp1 = (1+error)*0.5
	temp1 = (error+100.0)/200.0;
	delta_phi = acos(temp1)- PI_3;
	
	sin_phi = sin(delta_phi);
	cos_phi = cos(delta_phi);
	
    calibarte_type = CALIBRATE_PHASE_POINT;
    temp1 = Coeff.data.region[IRegion-1].K1[phase_num-1];
    temp2 = Coeff.data.region[IRegion-1].K2[phase_num-1];
	Coeff.data.region[IRegion-1].K1[phase_num-1] = cos_phi*temp1-sin_phi*temp2;
	Coeff.data.region[IRegion-1].K2[phase_num-1] = sin_phi*temp1+cos_phi*temp2;
	temp1 = Coeff.data.region[IRegion-1].K1[phase_num-1];
	temp2 = Coeff.data.region[IRegion-1].K2[phase_num-1];
    
	if(calibarte_type==2)//two points calibration for phase lag
	{
		if((IRegion>0)&&(IRegion<3))
		{
			for(i=0;i<2;i++)
			{
				Coeff.data.region[i].K1[phase_num-1] = temp1;
				Coeff.data.region[i].K2[phase_num-1] = temp2;			
			}
		}
		else
		{
			for(i=2;i<7;i++)
			{
				Coeff.data.region[i].K1[phase_num-1] = temp1;
				Coeff.data.region[i].K2[phase_num-1] = temp2;			
			}		
		}		
	}
	else if(calibarte_type==1)//one point calibration for phase lag
	{
		for(i=0;i<7;i++)
		{
			Coeff.data.region[i].K1[phase_num-1] = temp1;
			Coeff.data.region[i].K2[phase_num-1] = temp2;			
		}	
	}
	
	update_Region_Coeff(IRegion-1);
}


void InitCoefficents(void)
{
//-----------------------------------------------------------------------/
//  Function name: void InitCoefficents(void)
//	Description:   calibrate the system  
//  Author:			CADC
//  Create date:	3/27/06 	
//  Last modify:	12/07/06 by Jemmey Huang	
//-----------------------------------------------------------------------/
	
	unsigned char i,j;
	unsigned char bytes[2];
	unsigned int temp_word;
	unsigned int array_addr, e2prom_addr;	
	float temp1, temp2;
	
	//get pulse constant value
	while(I2C_ACKPolling(0xa0));
	EEPROM_ReadBytes(0xa0, 0, 240, 2, &Coeff.array[0]);	
	temp1 = Coeff.array[0];
	
	if((temp1>100)&&(temp1<64000))
	{
		integrate_limitation = 1000.0/temp1;	
		pulse_const = temp1;
	}
	else
	{
		integrate_limitation = 1000.0/((float)(PULSE_CONSTANT));
		pulse_const = PULSE_CONSTANT;
	}
	
	//get pulse constant value
	while(I2C_ACKPolling(0xa0));
	EEPROM_ReadBytes(0xa0, 0, 248, 2, &work_mode);	

	if(work_mode)
	work_mode = 1;
		
	//get voltage and current linearity coefficient
	while(I2C_ACKPolling(0xa0));	
	EEPROM_ReadBytes(0xa0, 0, 0, 38, &Coeff.array[0]);	

	// read linear coefficients from FLASH memory
	temp_word = 0;
	for(j=0;j<18;j++)
	 temp_word +=Coeff.array[j];
	
	if(temp_word!=(~Coeff.data.linear.checksum)) //if check sum error, then use the default value
	{
		for(j=0;j<3;j++)
		{
			Coeff.data.linear.V_channel[j] = VOTAGE_CH_COEF;
			Coeff.data.linear.C_channel[0][j] = CURRENT_CH_COEF;
			Coeff.data.linear.C_channel[1][j] = CURRENT_CH_COEF;				
		}
	}
	else	
	{
		for(j=0;j<3;j++)
		{
			if(Coeff.data.linear.V_channel[j]==0)
			   Coeff.data.linear.V_channel[j] = VOTAGE_CH_COEF;
				
			if(Coeff.data.linear.C_channel[0][j]==0)		
			   Coeff.data.linear.C_channel[0][j] = CURRENT_CH_COEF;
	
			if(Coeff.data.linear.C_channel[1][j]==0)		
			   Coeff.data.linear.C_channel[1][j] = CURRENT_CH_COEF;					
		}	
	}
	
	
	array_addr = 19;
	e2prom_addr = 40;	
		
	// read phase lag coefficient from FLASH memory for phase angle correction
	for(i=0;i<7;i++) //total 5 diffierent current range from small to large
	{				 //phase lag coefficients stored from second to six rows

		while(I2C_ACKPolling(0xa0));

		if(i<5)
			EEPROM_ReadBytes(0xa0, 0, e2prom_addr, 38, &Coeff.array[array_addr]);
		else
			EEPROM_ReadBytes(0xa0, 1, e2prom_addr, 38, &Coeff.array[array_addr]);

		array_addr += 19;
		e2prom_addr += 40;	
		if(i==4)
		e2prom_addr = 0;
		
		temp_word = 0;		
		for(j=0;j<18;j++)//calculate check sum
		 temp_word +=Coeff.array[(i+1)*19+j];
		 		 
		if(temp_word!= (~Coeff.data.region[i].checksum))//if check sum error	
		for(j=0;j<3;j++)
		{
			Coeff.data.region[i].KP[j] = POWER_CH_COEFF;

			Coeff.data.region[i].K1[j] = 1;
			Coeff.data.region[i].K2[j] = 0;
		}		
	}
}



void Reset_Calibration(unsigned char mode, unsigned char phase, unsigned char iregion)
{
/*
	reset all the calibration data to initial value
*/	
unsigned char i, j;

 if(mode==0x55)
 {
	 for(j=0;j<3;j++)
	 {
		Coeff.data.linear.V_channel[j] = VOTAGE_CH_COEF;
		Coeff.data.linear.C_channel[0][j] = CURRENT_CH_COEF;
		Coeff.data.linear.C_channel[1][j] = CURRENT_CH_COEF;
	 }	 
 
 	for(i=0;i<7;i++) //total 7 diffierent current range from small to large
	for(j=0;j<3;j++)
	{
		if(i<2)
		Coeff.data.region[i].KP[j] = POWER_CH_COEFF;
		else
		Coeff.data.region[i].KP[j] = POWER_CH_COEFF;

		Coeff.data.region[i].K1[j] = 1;
		Coeff.data.region[i].K2[j] = 0;				
	}
	
    update_LNR_Coeff(); 
	for(i=0;i<7;i++)
		update_Region_Coeff(i);
  }
  else
  {
	 if(mode==0xa1)
	 {	
		 for(j=0;j<3;j++)
		 {
			Coeff.data.linear.V_channel[j] = VOTAGE_CH_COEF;
			Coeff.data.linear.C_channel[0][j] = CURRENT_CH_COEF;
		 }
		 update_LNR_Coeff();
	 }
	 else if(mode==0xa2)
	 {
		if((iregion>0xa0)&&(iregion<0xa8))
		{
			if((phase>0xa0)&&(phase<0xa4))
			{
				iregion = iregion&7;
				phase = phase&3;
				Coeff.data.region[iregion-1].KP[phase-1] = POWER_CH_COEFF;
				update_Region_Coeff(iregion-1);		
			}	
		}				 
	 }
	 else if(mode==0xa3)
	 {
		if((iregion>0xa0)&&(iregion<0xa8))
		{
			if((phase>0xa0)&&(phase<0xa4))
			{
				iregion = iregion&7;
				phase = phase&3;
				Coeff.data.region[iregion-1].K1[phase-1] = 1;
				Coeff.data.region[iregion-1].K2[phase-1] = 0;
				update_Region_Coeff(iregion-1);		
			}	
		}
		else if(iregion==0x55)
		{
		 	for(i=0;i<7;i++) //total 7 diffierent current range from small to large
			{
				for(j=0;j<3;j++)
				{
					Coeff.data.region[i].K1[j] = 1;
					Coeff.data.region[i].K2[j] = 0;				
				}
			
		//    update_LNR_Coeff(); 
				update_Region_Coeff(i);
			}				
		}						 
	 }	  
  }		
}
