//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jemmey huang								 *
// *    Date:          11/29/06                                          *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p33fj64gp206.gld   								 *
// *                                                                     *
// *	File name:	   Calibrate.h										 *
// * 	File description: header file for calcu.c				         *
// **********************************************************************/

#define _CALIBRATE_H

#undef EXT
#undef LOCAL_GLOBLE
#ifdef _CALIBRATE_C
  #define EXT
  #define LOCAL_GLOBLE
#else
  #define EXT extern
#endif


#ifdef LOCAL_GLOBLE
//===========================================================================
//-------------Local defines, variables  ------------------------------------
//===========================================================================

//------------------------------ TYPEDEF ------------------------------------


//------------------------------ DEFINES ------------------------------------


//===========================================================================
//-----------------------Local functions  -----------------------------------
//===========================================================================


#endif
#undef LOCAL_GLOBLE

//===========================================================================
//------------- Globle defines, variables  ----------------------------------
//===========================================================================

#define CALIBRATE_PHASE_POINT 5		//indicate the calibarte piont for phase lag compensation
									//value could be 1, 2 and 5
									//if single point or 2 points calibration could meet your requirement
									//you can modify the value to 1 or 2 here
									//if use single point calibration, all five calibration value will be same
									//if use two point calibration, IRegion1 and IRegion2 will be same, while
									//IRegion3,4,and 5 will be same 
#define CALIBRATE_LINEAR_POINT 2	//Indicate the calibration point for linear
									//value could be 1 or 2
									//if use single point calibration, all two calibration value will be same									

#define PI_3 3.14159265/3.0

#define NEUTRAL_IRES   510.0		//define the neutral line current sampling resistor value
#define CT_RATIO_N     2000.0		// 2000:1 (IN/OUT), spec of CT in this application
#define FULL_CUR_N 	   3.3			// Full scale of voltage channel input, Refer to datasheet

#define VRES_IN 		150000.0		// ohm, sample resistor on priminary of PT 
#define VRES_OUT 		200.0			// ohm, sample resistors on secondary of PT 
#define PT_RATIO		1.0				// 1:1 (IN/OUT), spec of PT in this application
#define FULL_VOLT_CH	1.0				// Full scale of voltage channel input, Refer to datasheet

#define IRES_OUT 		40.0			// ohm, sample resistors on secondary of CT 
#define CT_RATIO		2000.0			// 2000:1 (IN/OUT), spec of CT in this application
//#define CT_RATIO		300.0			// 2000:1 (IN/OUT), spec of CT in this application
#define FULL_CUR_CH		0.7133			// Full scale of voltage channel input, Refer to datasheet
	
#define sqrt_2			1.4142136		//sqrt(2) 
#define VOTAGE_CH_COEF  (VRES_IN*PT_RATIO*FULL_VOLT_CH/VRES_OUT)/32768.0/sqrt_2
#define CURRENT_CH_COEF (FULL_CUR_CH*CT_RATIO/IRES_OUT)/32768.0/sqrt_2
#define POWER_CH_COEFF  VOTAGE_CH_COEF*CURRENT_CH_COEF*2
#define CURRENT_N_COEF  (FULL_CUR_N*CT_RATIO_N/NEUTRAL_IRES)/4096.0

	
typedef struct _LNR_COFF{
		float V_channel[3];			//voltage adjustment coefficients, we only use one point calibration
		float C_channel[2][3];		//current adjustment coefficients, 2 point calibration in the range 0~0.2Ib and 0.2Ib~4.0Ib
		unsigned int checksum;
}LNR_COFF;
		
typedef struct _PWR_COFF{
		float KP[3];				//power adjustment coefficients
		float K1[3];				//k1 for phase A,B,C	
		float K2[3];				//k2 for phase A,B,C		
		unsigned int checksum;
}PWR_COFF;
		
typedef union _COEFF{
	struct 
	{
		LNR_COFF linear;
		PWR_COFF region[7];
	}data;
	unsigned int array[114];
}COEFF;

EXT COEFF Coeff;


EXT void CalibrateLinear(unsigned char phase_num, unsigned char mode, unsigned char channel, float reference_value);
EXT void CalibratePhase(unsigned char phase_num, unsigned char IRegion, float error);
EXT void CalibratePower(unsigned char phase_num, unsigned char IRegion, float error);
EXT void Reset_Calibration(unsigned char mode, unsigned char phase, unsigned char iregion);
EXT void InitCoefficents(void);

#undef _CALIBRATE_H
