//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jerry Gao									 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *	File name:	  global.c											 *
// * 	File description: declare and initialize global variables   	 *
// **********************************************************************/


#define _GLOBAL_C
#include "global.h"
#include "calcu.h"
#include "mcp390x.h"
#include "calibrate.h"
#include "calcu.h"
#include "uart_comm.h"
#undef _GLOBAL_C


void InitGlobal(void)
{
	phase_gain[0] = 0;
	phase_gain[1] = 0;
	phase_gain[2] = 0;
	
	pulse_generator.EnergyCumulateMode = 0; //accumulate active energy
	pulse_generator.EnergyCumulateChannel = 0; //accumulate all three phase energy

	integrate_limitation = 1000.0/((float)(PULSE_CONSTANT));
	half_limitation = integrate_limitation/2;
	flag.bits.ResetEnergy = 1;
	pulse_const = PULSE_CONSTANT;
	coeff_freq = COEFF_FREQ;	
	LeftDataNum = 0;
	DataStart = 0;
	DataNum = 0;
	
	Rx_Count = 0;
	
	gds.data.Frequency = 50.0;
	smp_pnt = 64;
	DataNum_Cycle3 = smp_pnt*3;
	
	cycle_energy_buf[0] = 0;
	cycle_energy_buf[1] = 0;
	cycle_energy_buf[2] = 0;

	flag.bits.temp_flag = 0;	
	cycles_count = 0;

	
}

