//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jerry Gao									 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *	File name:	  global.h											 *
// * 	File description: declare the global variables   				 *
// **********************************************************************/

#define _GLOBAL_H
#include <dsp.h> 
#include <p33FJ128GP206.h>
//#include <p33FJ256GP710.h>


#undef EXT
#undef LOCAL_GLOBLE
#ifdef _GLOBAL_C
  #define EXT
  #define LOCAL_GLOBLE
#else
  #define EXT extern
#endif


#ifdef LOCAL_GLOBLE
//===========================================================================
//-------------Local defines, variables  ------------------------------------
//===========================================================================

//------------------------------ TYPEDEF ------------------------------------


//------------------------------ DEFINES ------------------------------------


//===========================================================================
//-----------------------Local functions  -----------------------------------
//===========================================================================


#endif
#undef LOCAL_GLOBLE

//===========================================================================
//------------- Globle defines, variables  ----------------------------------
//===========================================================================
#define LED				LATCbits.LATC13
#define LED1			LATCbits.LATC14
#define PULSE_PIN		LATDbits.LATD1
#define PULSE_PIN1		LATDbits.LATD2
#define PULSE_PIN2		LATDbits.LATD3

#define	INPUT 	1
#define	OUTPUT	0

#define PULSE_CONSTANT	3200		//The constant for energy output pulse
#define HIGH_FRQ_TIMES  4			//high frequency times to the pulse 

#define COEFF_FREQ  -0.0003

/*
#define Ib				5			//Ib = 5.0A
#define IRegion0		Ib*0.06
#define IRegion1		Ib*0.25
#define IRegion2		Ib*0.75
#define IRegion3		Ib*1.5
//#define IRegion5		Ib*2.5

#define Cal_IValue1		Ib*0.03
#define Cal_IValue2		Ib*0.10
#define Cal_IValue3		Ib*0.50
#define Cal_IValue4		Ib*1.0
#define Cal_IValue5		Ib*2.0

*/

#define Ib				5			//Ib = 5.0A
#define IRegion0		Ib*0.02
#define IRegion1		Ib*0.05
#define IRegion2		Ib*0.10
#define IRegion3		Ib*0.20
#define IRegion4		Ib*0.50
#define IRegion5		Ib*1.0
#define IRegion6		Ib*2.0

#define IRN01			Ib*0.03
#define IRN12			Ib*0.07
#define IRN23			Ib*0.15
#define IRN34			Ib*0.30
#define IRN45			Ib*0.75
#define IRN56			Ib*1.50

#define GAIN_CTL_16		Ib*0.27
#define GAIN_CTL_16_DN	Ib*0.28
#define GAIN_CTL_16_UP	Ib*0.29

#define START_UP_CURRENT 0.0045		//start up current 4.5mA, about 0.1% Ib
#define START_UP_POWER	START_UP_CURRENT*220.0
#define LOST_PHASE_VOTAGE 20.0		//if votage low than 20V, then indicate lost phase status
#define LOW_VOLTAGE_LIMIT 120.0		//if votage low than 120V, then indicate low voltage status


#define Fcy 29491200	//29.4912MHZ of Fcy
#define Fcy_64 Fcy/64	//460.8KHZ - Fcy with 1:64 prescale
#define Fcy_8  Fcy/8

#define SAMPLE_CLK		3200.0
#define SAMPLE_PERIOD	1.0/SAMPLE_CLK
#define SAMPLE_PERIOD_2 SAMPLE_PERIOD/2
#define ENGY_MULTIPLIER SAMPLE_PERIOD/3600.0	//For 1 hour
#define ENGY_MULTIPLIER2 ENGY_MULTIPLIER/2	//For 1 hour


#define SAMPLES_NUM		214			//(71 samples/per cycle) * 3
#define BUF_SIZE   		280

#define BACKWARD		0
#define FOREWARD		1

#define nop() __asm__{volatile(nop)}; 

//------------------------------ TYPEDEF ------------------------------------

typedef union _FLAG
{
	struct _BITS
	{
	unsigned DataReady2Cal			:1;	
	unsigned DataReady2Copy			:1;			
	unsigned CalculationCompleted	:1;
	unsigned NoPower				:1;			//mark that no power apply to the system
	unsigned T2_overflow			:1;			//mark the overflow of Timer5
	unsigned ADCReadyFlag			:1;	
	unsigned ResetEnergy			:1;
	unsigned HandleActPulse			:1;
	unsigned HandleActPulseDN		:1;
	unsigned HandleReactPulse		:1;
	unsigned HandleReactPulseDN		:1;	
	unsigned ActPwrDir				:1;
	unsigned ReactPwrDir			:1;	
	unsigned temp_flag				:1;
	}bits;
	unsigned char byt;
}FLAG;


typedef struct _PULSE_GENERATER
{
	unsigned int EnergyCumulateChannel;	//=00: all three phase, 01: phase A, 02:phase B, 03: phase C
	unsigned int EnergyCumulateMode;	//=0: active power output pulse; =1: apparent power output pulse
	unsigned char ActiveEnergyDirection;
	unsigned char ReActiveEnergyDirection;	
}PULSE_GENERATER;



typedef struct _RMS_VALUE				// valtage&current rms value
{
		float PhaseVoltage[3];
		float PhaseCurrent[3];
		float NeutralCurrent;	
}RMS_VALUE;


typedef struct _POWER_STATE
{
		unsigned PhaseA		: 2;
		unsigned PhaseB		: 2;
		unsigned PhaseC		: 2;
		unsigned PhaseOrderVoltage 	: 1; 	
		unsigned PhaseOrderCurrent 	: 1; 	
}POWER_STATE;


typedef struct _PHASE_PWR				// active and reactive power value
{
		float ActPwr;					// active power
		float ReactPwr;					// reactive power
		float ApparentPwr;			// Phase apparent power	
		float PowerFactor;					// Phase Power factor									
}PHASE_PWR;

typedef struct _POWER_DATA
{
		PHASE_PWR PhasePwr[3];				// Phase active&reactive power
		float TotalActivePwr;				// Total active power
		float TotalReactivePwr;				// Total inavtive power
		float TotalApparentPwr;				// Total apparent power		
		float TotalPwrFactor;
		
		float Fundemental_ActPwr[3];		// Phase A, B, C fundemental active power
		float Fundemental_ReactPwr[3];		// Phase A, B, C fundemental reactive power
		float Harmonic_ActPwr[3];			// Phase A, B, C harmonic active power						
		float Harmonic_ReactPwr[3];			// Phase A, B, C harmonic reactive power
		
}POWER_DATA;


typedef struct _DISTORTION
{
		float PhaseA;
		float PhaseB;
		float PhaseC;
}DISTORTION;

typedef struct _ENERGY				// forward/reverse energy
{
		float Q1;					// Four Quadrants reactive power
		float Q2;
		float Q3;
		float Q4;	
	
		float Forward_ReActive;		// forward inactive energy	= Q1 Inactive power + Q2 Inactive power
		float Reverse_ReActive;		// forward inactive energy  = Q3 Inactive power + Q3 Inactive power
		float Forward_Active;		// forward active energy	= Q1 active power + Q4 active power
		float Reverse_Active;		// reverse active energy	= Q2 active power + Q3 active power
		float Total_Active;			// total active energy = forward + reverse
}ENERGY;

typedef struct _THD
{
		float voltage[3];
		float current[3];
}THD;

typedef union _GLOBAL_DATA
{
	struct 
	{
		float Frequency;
		POWER_STATE PowerState;				// phase A~C power state: 0 normal, 1 low voltage , 2 no power 	
		RMS_VALUE Rms;
		POWER_DATA Power;
		THD TotalHarmonic;				
		ENERGY Energy;
	}data;
	unsigned int array[76];
}GLOBAL_DATA;

//------------------------------ variables ------------------------------------
EXT typeof(GLOBAL_DATA) gds;
EXT int voltage_sample[3][BUF_SIZE] __attribute__ ((address(0x880)));
EXT int current_sample[3][BUF_SIZE] __attribute__ ((section (".xbss"), aligned (2)));
//EXT int current_sample1[3][DATA_BUF_SIZE] __attribute__ ((section (".xbss"), aligned (2)));
//EXT int voltage_sample1[3][DATA_BUF_SIZE] __attribute__ ((section (".xbss"), aligned (2)));

EXT int harmonicMag[6][32];		//to record the permillage of harmonic
EXT int neutral_current_sample[64];

EXT int data_copy[SAMPLES_NUM] __attribute__ ((section (".ybss"), aligned (2)));

EXT typeof(FLAG) flag;
EXT typeof(PULSE_GENERATER) pulse_generator;

EXT unsigned char smp_pnt;			//to record how many points the MCU samples per cycle
EXT unsigned int DataNum_Cycle3;
EXT unsigned int DataNum;  
EXT unsigned int LeftDataNum;
EXT unsigned int DataStart;           


//for pulse generation
EXT float integrate_limitation;			//=1000/(PulseConstant)
EXT float half_limitation;				//=integrate_limitation/2
EXT float energy_integrate;				//integrate value of power
EXT float reactive_energy_integrate;	//integrate value of power
EXT int cnt_pulse;						//counter for the lasting time of pulse
EXT int cnt_pulse1;						//counter for the lasting time of pulse
EXT unsigned int pulse_threshold, trigger_count;
EXT unsigned int pulse_threshold1, trigger_count1;
EXT unsigned int cycles_count;

EXT float cycle_energy[3], 	cycle_energy_buf[3];

EXT unsigned int pulse_const;

EXT unsigned int work_mode;				//1 = normal measurement, 0 = calibration
EXT float coeff_freq;					//coefficient of the active power vs 1HZ frequency change


EXT union _trans_data
{ 
	float float_data;  
	unsigned char byte_array[4];
	unsigned int word_array[2];
}trans;


//===========================================================================
//-----------------------Globle functions  ----------------------------------
//===========================================================================
EXT void InitGlobal(void);
EXT void gain_control(int phase, int gain);

#undef _GLOBAL_H
