//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jemmey Huang								 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *	File name:	  interrupt.c										 *
// * 	File description: the ISR rountine							  	 *
// **********************************************************************/


#define _INTERRUPT_C
#include "global.h"
#include "interrupt.h"
#include "uart_comm.h"
#include "MCP390x.h"
#include "calibrate.h"
#include "calcu.h"
#include "adc.h"
#undef _INTERRUPT_C

extern 	unsigned char UART_Rx_Timer;	// timer to count when every frame receiving begining 

//-----------------------------------------------------------------------
//  Function name: void InitT2_T3(void)
//
//	Description:    initialize timer2 under 16bit mode, free running and 1:64 prescale
//					timer3 under 16bit mode, about 10ms period for system clock
//  Author:			CADC
//  Create date:	
//  Last modify:	10/19/2006 by Jemmey Huang
//-----------------------------------------------------------------------
void InitTimers(void)
{
	TMR2=0;                
	T2CONbits.T32 = 0;		//	16bit mode
	T2CONbits.TCS = 0; 		//	internal Fcy
	T2CONbits.TCKPS = 1;	// 	1:8 prescale
	PR2 = 0x9000;			//	10ms
	IPC1bits.T2IP = 1;	
	T2CONbits.TON = 1;  
 	IEC0bits.T2IE = 1;

	TMR3=0;					//  this timer use to drive the ADC to sampling Neutral line current
	T3CONbits.TCS = 0; 		//	internal Fcy
	T3CONbits.TCKPS = 0;	// 	1:64 prescale
	PR3 = 0x9000;			//	1.25ms period, free running; period value will update according to measurement frequency value
	IPC2bits.T3IP = 0;	
	T3CONbits.TON = 1;  	//	always runs
 	IEC0bits.T3IE = 0;		//  no interrupt
 	
}

//-----------------------------------------------------------------------
//  Function name: void InitExtInt(void)
//	Description:    
//  Author:			CADC
//  Create date:	
//  Last modify:	3/10/06 by Jerry Gao	
//-----------------------------------------------------------------------
void InitIC1(void)
{ 	
// IC1  
    IPC0bits.IC1IP = 5;  
 	IC1CON = 0x0022;		// Input capture every edge and interrupt in the second capture
	IFS0bits.IC1IF = 0;		// Clear interrupt flag
   	IEC0bits.IC1IE = 1;		// Enable interrupts on IC7
}




//********************************************************/
void __attribute__((__interrupt__)) _SPI1Interrupt(void)
{   // not used  
	SPI1STATbits.SPIROV = 0;  
   	IFS0bits.SPI1IF = 0;  
}



void __attribute__((__interrupt__)) _MathError(void)
{
	asm("nop");
	asm("nop");
	asm("nop");
}

void __attribute__((__interrupt__)) _StackError(void)
{
	asm("nop");
	asm("nop");
	asm("nop");
}

void __attribute__((__interrupt__)) _AddressError(void)
{
	asm("nop");
	asm("nop");
	asm("nop");
}



//-----------------------------------------------------------------------
//  Function name: 
//	Description:    
//  Author:			CADC
//  Create date:	12/14/2006 by Jemmey Huang	
//-----------------------------------------------------------------------

void __attribute__((__interrupt__)) _IC1Interrupt (void)
{
//	LED = 0;
  	IEC0bits.IC1IE = 0;		// Disable interrupts on IC7
  	
   	ReadMCP390x();
	
	IC1BUF;
	IC1BUF;
	IC1BUF;
	IC1BUF;

//	if(!flag.bits.temp_flag)
	{
		//LED = 0;
		//now processing the energy pulse output
		if(flag.bits.HandleActPulseDN)
		{
			cnt_pulse++;
			if(cnt_pulse>=512)
			{
				PULSE_PIN = 1;
				LED = 1;
				flag.bits.HandleActPulseDN = 0;		
			}		
		}		
		else if(flag.bits.HandleActPulse)
		{
			trigger_count++;
			if(trigger_count >=	pulse_threshold)
			{
				PULSE_PIN = 0;	
				LED = 0;
				flag.bits.HandleActPulse = 0;
				flag.bits.HandleActPulseDN = 1;
				if(flag.bits.ActPwrDir==FOREWARD)
					energy_integrate = energy_integrate-integrate_limitation;
				else
					energy_integrate = energy_integrate+integrate_limitation;
					
				cnt_pulse=0;			
			}
		}
		
		
		if(flag.bits.HandleReactPulseDN)
		{
			cnt_pulse1++;
			if(cnt_pulse1>=512)
			{
				PULSE_PIN1 = 1;
			//	LED1 = 1;
				flag.bits.HandleReactPulseDN = 0;		
			}		
		}		
		else if(flag.bits.HandleReactPulse)
		{
			trigger_count1++;
			if(trigger_count1 >=pulse_threshold1)
			{
				PULSE_PIN1 = 0;	
			//	LED1 = 0;
				flag.bits.HandleReactPulse = 0;
				flag.bits.HandleReactPulseDN = 1;
				if(flag.bits.ReactPwrDir==FOREWARD)
					reactive_energy_integrate = reactive_energy_integrate-integrate_limitation;
				else
					reactive_energy_integrate = reactive_energy_integrate+integrate_limitation;
					
				cnt_pulse1=0;			
			}
		}
			
	 //	LED = 1;			
	}
	IFS0bits.IC1IF = 0;		// Clear interrupt flag
  	IEC0bits.IC1IE = 1;		// Enable interrupts on IC1 for reading data 

	return;
}






//-----------------------------------------------------------------------
//  Function name: 
//	Description:    timer5 for system clock, with about 10ms period
//  Author:			CADC
//  Create date:	
//  design by:	3/10/06 by Jerry Gao
//	Last modify: 10/24/2006 by Jemmey Huang	
//-----------------------------------------------------------------------
void __attribute__((__interrupt__)) _T2Interrupt(void)
{ 
	flag.bits.T2_overflow = 1;
	
//	if(UART_Rx_Timer)
	if(UART_Rx_Timer||Rx_Count)
		UART_Rx_Timer++;

	IFS0bits.T2IF = 0;
}



//********************************************************/
void __attribute__((__interrupt__)) _U1TXInterrupt(void)
{   
	UART_Transmit();
    IFS0bits.U1TXIF = 0 ; 
}

//********************************************************/
void __attribute__((__interrupt__)) _U1RXInterrupt(void)
{   
	
	IFS0bits.U1RXIF = 0 ; 
	UART_Receive();
}




//*******************************************************/
void __attribute__((__interrupt__)) _ADC1Interrupt(void)
{   
	
	IFS0bits.AD1IF = 0;           

	ADC_Calc();
}




#undef _INTERRUPT_C
