//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jerry Gao									 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *	File name:	  interrupt.h										 *
// * 	File description: head file for interrupt.c					  	 *
// **********************************************************************/


#define _INTERRUPT_H

#undef EXT
#undef LOCAL_GLOBLE
#ifdef _INTERRUPT_C
  #define EXT
  #define LOCAL_GLOBLE
#else
  #define EXT extern
#endif


#ifdef LOCAL_GLOBLE
//===========================================================================
//-------------Local defines, variables  ------------------------------------
//===========================================================================
//------------------------------ DEFINES ------------------------------------
unsigned char MCP3909_count;	//fetch only one in every four MCP3909 samples 

//===========================================================================
//-----------------------Local functions  -----------------------------------
//===========================================================================
void __attribute__((__interrupt__)) _SPI1Interrupt(void); 
void __attribute__((__interrupt__)) _INT2Interrupt(void); 
void __attribute__((__interrupt__)) _INT3Interrupt(void);
void __attribute__((__interrupt__)) _U1TXInterrupt(void);
void __attribute__((__interrupt__)) _U1RXInterrupt(void);

#endif
#undef LOCAL_GLOBLE

//===========================================================================
//------------- Globle defines, variables  ----------------------------------
//===========================================================================

//===========================================================================
//-----------------------Globle functions  -----------------------------------
//===========================================================================

EXT unsigned int T2_PRD;
EXT void InitExtInt(void); 
EXT void InitTimers(void);
#undef _INTERRUPT_H
