//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jemmey Huang								 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *	File name:	   main.c											 *
// * 	File description: main function 								 *
// **********************************************************************/

#define _MAIN_C

#include "Calcu.h"
#include "global.h"
#include "uart_comm.h"
#include "MCP390x.h"
#include "interrupt.h"
#include "main.h"



extern unsigned char uart_buf[15];
extern unsigned char Tx_Count;

// External Oscillator
_FOSCSEL(FNOSC_PRIPLL);			// Primary (XT, HS, EC) Oscillator with PLL
_FOSC(FCKSM_CSDCMD & OSCIOFNC_OFF  & POSCMD_XT);  
								// Clock Switching and Fail Safe Clock Monitor is disabled
								// OSC2 Pin Function: OSC2 is Clock Output
								// Primary Oscillator Mode: XT Crystanl

// Internal FRC Oscillator
//_FOSCSEL(FNOSC_FRCPLL );		// FRC Oscillator with PLL
//_FOSC(FCKSM_CSDCMD & OSCIOFNC_OFF  & POSCMD_NONE); 
								// Clock Switching and Fail Safe Clock Monitor is disabled
								// OSC2 Pin Function: OSC2 is Clock Output
								// Primary Oscillator Mode: Disabled


_FWDT(FWDTEN_ON);              // Watchdog Timer Enabled/disabled by user software
								// (LPRC can be disabled by clearing SWDTEN bit in RCON register
//_FPOR(PWRTEN_OFF);   			// Turn off the power-up timers.
//_FGS(GCP_OFF);            		// Disable Code Protection



/*------------------------------------------------------------------
	Function Name:  main()
	main function

	Design By:					 Jemmey Huang  CADC
	Last modification:			 Oct 20 / 2006
------------------------------------------------------------------*/
int main (void)
{  
	unsigned int i, j;
		
	InitSystemClock();	
	InitGlobal();	// Initialize global variable
	InitIO();		// I/O port
	Init_I2C();	
	InitCoefficents();	// read out coefficients of measurement from Flash memory
    InitTimers();
    InitUart(); 	// UART
    InitSPI();  	// Initialize SPI
	InitIC1();	// interrupt
	Init_ADC();
	
	InitMCP390x(); 	// MCP3909
	
	LED = 0;
	
	i=0;
	while(i<200)
	{
		Delay(10000);
		asm("CLRWDT");
		i++;
	}
	LED = 1;		
	
    while(1)  
	{  
		asm("CLRWDT");

		//transmit data to backend mcu or PC
		process_UART();

		//do calculate         
		if(flag.bits.DataReady2Cal)//if data collection finish
		{
//			LED = 0;
			Calculation();						//do the calculation		
			flag.bits.DataReady2Cal = 0;
			Update_Gain();						//change the gain of current channels
			
							
//			LED = 1;
			LED1 = !LED1;
		} 
		
		if(flag.bits.ADCReadyFlag)
		{
			flag.bits.ADCReadyFlag = 0;
			ComputeNeutralCurrent();
		}
		
//		refresh important registers
    }      
}


/*------------------------------------------------------------------
	Function Name:  InitIO()
	set up the I/O port according the the function requirement by the schematic

	Design By:					 Jemmey Huang  CADC
	Last modification:			 Oct 20 / 2006
------------------------------------------------------------------*/
void InitIO(void)
{
    CORCON = 0x00f0;  

	//all port as digital port
	AD1PCFGH = 0XFFFF;
	AD1PCFGL = 0XFFFF;

	// set MCP3909 selection
	LATB = 7;
	
	//MCP3909 chip selection
    TRISBbits.TRISB0 = OUTPUT;	// AD(390x) Phase C Chip select
    TRISBbits.TRISB1 = OUTPUT;	// AD(390x) Phase B chip select
    TRISBbits.TRISB2 = OUTPUT;	// AD(390x) Phase C chip select

	//MCP3909 MCLR
    TRISGbits.TRISG0 = OUTPUT;   // 390x MCLR


	//MCP3909 Gain control pin
    TRISBbits.TRISB3 = OUTPUT;	// G0C
    TRISBbits.TRISB4 = OUTPUT;	// G1C
    TRISCbits.TRISC1 = OUTPUT;	// G0B
    TRISCbits.TRISC2 = OUTPUT;	// G1B
    TRISCbits.TRISC13 = OUTPUT;	// G0B
    TRISCbits.TRISC14 = OUTPUT;	// G1B    
    TRISGbits.TRISG14 = OUTPUT;	// G0A
    TRISGbits.TRISG15 = OUTPUT;	// G1A

	//INT1 for MCP3909 ADC conversion finish flag 
	TRISDbits.TRISD8 = INPUT;

	//UART I/F
   	TRISFbits.TRISF2 = INPUT;   // UART - U1RX
   	TRISFbits.TRISF3 = OUTPUT;   // UART - U1TX

 	// LED driver & Pulse output
    TRISDbits.TRISD1 = OUTPUT;   
    TRISDbits.TRISD2 = OUTPUT;    
    TRISDbits.TRISD3 = OUTPUT;   
    TRISDbits.TRISD4 = OUTPUT;   
    TRISDbits.TRISD5 = OUTPUT;   

	PULSE_PIN = 1;
	PULSE_PIN1 = 1;
	LED = 1;
	             
	//set gain = 1
    LATBbits.LATB3 = 0;	// G0C
    LATBbits.LATB4 = 0;	// G1C
    LATCbits.LATC1 = 0;	// G0B
    LATCbits.LATC2 = 0;	// G1B
    LATGbits.LATG14 = 0;// G0A
    LATGbits.LATG15 = 0;// G1A

	//I2C I/F
    TRISGbits.TRISG2 = OUTPUT;	
    TRISGbits.TRISG3 = OUTPUT;	

/*
	//Use in synchronization sampling mode
    TRISGbits.TRISG12 = OUTPUT;  // ZC source/ 4051 channel select
    TRISGbits.TRISG13 = OUTPUT;  // ZC source/ 4051 channel select
    TRISGbits.TRISG9 = INPUT;	// Sample clock

	//PLL Relate
    TRISDbits.TRISD10 = OUTPUT;  // reference output to PLL 
    TRISGbits.TRISG1 = OUTPUT;   // AD CLK divider output to PLL
	//INT4 for 50HZ_IN
    TRISBbits.TRISB7 = OUTPUT;   // PLL input
*/	

//	TRISC = ;
//	TRISD = ;
	flag.byt = 0x08;
}


/*------------------------------------------------------------------
	Function Name:  InitClock()
	set up the system clock and wait until it is stable

	Design By:					 Jemmey Huang  CADC
	Last modification:			 Oct 20 / 2006
------------------------------------------------------------------*/
void InitSystemClock()
{
// Configure Oscillator to operate the device at 29.4912Mhz
// Fosc= Fin*M/(N1*N2), Fcy=Fosc/2
// Fosc= 7.3728M*32/(2*2)=58.9824Mhz 
	PLLFBD=30;					// M=32
	CLKDIVbits.PLLPOST=0;		// N1=2
	CLKDIVbits.PLLPRE=0;		// N2=2
	OSCTUN=0;					// Tune FRC oscillator, if FRC is used

// Disable Watch Dog Timer
    RCONbits.SWDTEN=0;

// Wait for PLL to lock

	while(OSCCONbits.LOCK!=1) 
	{};
}

#undef _MAIN_C
