//**********************************************************************
// *                                                                     *
// *                        Software License Agreement                   *
// *                                                                     *
// *    The software supplied herewith by Microchip Technology           *
// *    Incorporated (the "Company") for its dsPIC controller            *
// *    is intended and supplied to you, the Company's customer,         *
// *    for use solely and exclusively on Microchip dsPIC                *
// *    products. The software is owned by the Company and/or its        *
// *    supplier, and is protected under applicable copyright laws. All  *
// *    rights are reserved. Any use in violation of the foregoing       *
// *    restrictions may subject the user to criminal sanctions under    *
// *    applicable laws, as well as to civil liability for the breach of *
// *    the terms and conditions of this license.                        *
// *                                                                     *
// *    THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
// *    WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
// *    BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
// *    FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
// *    COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
// *    INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
// *                                                                     *
//  **********************************************************************/

//**********************************************************************
// *    Project:       Front-end of tri-phase power meter                *
// *    Author: 	   CADC   Jemmey Huang								 *
// *				   CAE	  Gloria Xie								 *
// *    Date:          6/11/06                                           *
// *    File Version:  ver1.0											 *
// *    Tools used:    MPLAB C30 Compiler v 1.32                         *
// *    Linker File:   p30f3013.gld   									 *
// *                                                                     *
// *	File name:	   uart.h											 *
// * 	File description: head file for uart.c					 		 *
// **********************************************************************/

#define _UART_H

#undef EXT
#undef LOCAL_GLOBLE
#ifdef _UART_C
  #define EXT
  #define LOCAL_GLOBLE
#else
  #define EXT extern
#endif

#define		Ctrl_U1RX 	TRISFbits.TRISF2 
#define		Ctrl_U1TX 	TRISFbits.TRISF3 

#ifdef LOCAL_GLOBLE
//===========================================================================
//-------------Local defines, variables  ------------------------------------
//===========================================================================

//------------------------------ TYPEDEF ------------------------------------

//------------------------------ DEFINES ------------------------------------

unsigned char receive[6],rec_num,trans_num;  


//===========================================================================
//-----------------------Local functions  -----------------------------------
//===========================================================================

#endif
#undef LOCAL_GLOBLE

//===========================================================================
//------------- Globle defines, variables  ----------------------------------
//===========================================================================
//EXT unsigned char  Max_flag,Zero_flag,crc_buf;; 
//EXT unsigned char  answer_flag,four_var_flag; 

EXT unsigned char Rx_Count;			// Received byte counter


//===========================================================================
//-----------------------Globle functions  -----------------------------------
//===========================================================================
EXT void InitUART(void);
EXT void UART_HandleRightFrame(unsigned char);
EXT void process_UART(void);
EXT void UART_Receive(void);
EXT void UART_Transmit(void);

#undef _UART_H
