/******************************************************************************
*   Filename:       dtm.c
*   Revised:        $Date: 2014-06-26 12:57:28 +0200 (to, 26 jun 2014) $
*   Revision:       $Revision: 122 $
*
*   Description:    Direct Test Mode (DTM) application for miniBLE.
*
*
*  Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/
*
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
******************************************************************************/


/*******************************************************************************
* INCLUDES
*/
#include "dtm.h"
#include "miniBLE_dtm.h"
#include "hal_timer2.h"
#include "miniBLE_defs.h"
#include "clock.h"
#include "hal_mcu.h"
#if(SMARTRF05EB)
#include "hal_board.h"
#include "hal_button.h"
#include "hal_led.h"
#include "util_lcd.h"
#endif


/*******************************************************************************
* GLOBAL VARIABLES
*/
/*******************************************************************************
* LOCAL FUNCTIONS
*/
/*******************************************************************************
* @fn          main
*
* @brief       Main program
*
* @param       void
*
* @return      void
*/
void main(void) {
#if(SMARTRF05EB)
    /*  Initialize system clock source to 32 MHz Xtal.
    *   Initialize low speed (sleep timer) clock source to 32 kHz RCOSC.
    *   Set I/O ports and pheripherals(LCD). */
    halBoardInit();
    halLedSet(1);  // Turn on LED1 ( green ).
    halLcdClear();
    halLcdWriteLine(1, "Direct Test Mode");
    halLcdWriteLine(2, " TI miniBLE ");
    halLcdWriteLine(3, "Start -> B1 (S1)");
    // Wait for user to press S1 to start BLE broadcast.
    while(halButtonPushed() != HAL_BUTTON_1);
    halLcdWriteLine(3, "**** ACTIVE ****");
#else
    /*  Initialize system clock source to 32 MHz Xtal.
    *   Initialize low speed (sleep timer) clock source to 32 kHz RCOSC. */
    halMcuInit();
#endif

    miniBleDtmSetupTestPort();
    miniBleDtmStart();
    while(1);
}