//*****************************************************************************
//
// PLC_Main.c - This file contains the Base board and daughter card
// initialization Code for Smart IO project based on Tiva MCU
//
// Copyright (c) 2012-2013 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
//
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
//
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
//
//*****************************************************************************


#ifndef PLC_main_H_
#define PLC_main_H_
/*********************************************************************************/
/************************
 * INCLUDES
 ************************/
/* Add Library Header Files */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <stdbool.h>
/* Processor Header/Library Files */
#include "inc/hw_ints.h"
//#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "inc/hw_nvic.h"
#include "inc/hw_ssi.h"
#include "inc/hw_gpio.h"
#include "inc/hw_uart.h"
#include "inc/hw_sysctl.h"
#include "driverlib/debug.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/interrupt.h"
//#include "driverlib/adc.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/timer.h"
//#include "driverlib/uart.h"
#include "driverlib/rom.h"
#include "driverlib/i2c.h"
//#include "driverlib/udma.h"
#include "driverlib/ssi.h"
//#include "driverlib/usb.h"
#include "usblib/usblib.h"
#include "usblib/usbcdc.h"
#include "usblib/usb-ids.h"
#include "usblib/device/usbdevice.h"
#include "usblib/device/usbdbulk.h"
#include "utils/ustdlib.h"
#include "utils/uartstdio.h"
#include <stdio.h>


void InitAnalogInputSlot1 (void);
void InitAnalogOutputSlot1(void);
void InitAnalogInputSlot2(void);
void InitAnalogOutputSlot2(void);
void InitDigitalInputSlot1(void);
void InitDigitalInputSlot2(void);
void wait(unsigned int time);
void msecWait(unsigned int time);
void SysClockInit(void);
#endif /* PLC_main_H_ */

/*EOF*/
