/******************************************************************************/
//
// Software License Agreement
//
// CODE OWNERSHIP AND DISCLAIMER OF LIABILITY
// Microchip Technology Incorporated ("Microchip") retains
// all ownership and intellectual property rights in the code
// accompanying this message and in all derivatives hereto.
// You may use this code, and any derivatives created by any
// person or entity by or on your behalf, exclusively with
// Microchips proprietary products. Your acceptance and/or
// use of this code constitutes agreement to the terms and
// conditions of this notice.
// CODE ACCOMPANYING THIS MESSAGE IS SUPPLIED BY MICROCHIP "AS IS".
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,
// BUT NOT LIMITED TO, IMPLIED WARRANTIES OF NON-INFRINGEMENT,
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO
// THIS CODE, ITS INTERACTION WITH MICROCHIPS PRODUCTS, COMBINATION
// WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION.
// YOU ACKNOWLEDGE AND AGREE THAT, IN NO EVENT, SHALL MICROCHIP BE
// LIABLE, WHETHER IN CONTRACT, WARRANTY, TORT (INCLUDING NEGLIGENCE
// OR BREACH OF STATUTORY DUTY), STRICT LIABILITY, INDEMNITY, CONTRIBUTION,
// OR OTHERWISE, FOR ANY INDIRECT, SPECIAL, PUNITIVE, EXEMPLARY, INCIDENTAL
// OR CONSEQUENTIAL LOSS, DAMAGE, FOR COST OR EXPENSE OF ANY KIND WHATSOEVER
// RELATED TO THE CODE, HOWSOEVER CAUSED, EVEN IF MICROCHIP HAS BEEN ADVISED
// OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE FULLEST EXTENT
// ALLOWABLE BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN ANY WAY
// RELATED TO THIS CODE, SHALL NOT EXCEED THE PRICE YOU PAID DIRECTLY TO
// MICROCHIP SPECIFICALLY TO HAVE THIS CODE DEVELOPED.
// You agree that you are solely responsible for testing the code and
// determining its suitability. Microchip has no obligation to modify,
// test, certify, or support the code.
/*****************************************************************************/
// File: dsPIC33EP256MC504 UART configuration for 9600 Baud Half Duplex 1 Start/Stop 8 Data.
//
// Microchip Technology Inc
//
/*****************************************************************************/
//
// Revision History
//
// 06/27/14 --  Initial release taken from dsPIC33FJ32MC204 application.
/*****************************************************************************/

/********************* Include Files *****************************************/
#include "MCP802X.h"        // must be first include for FCY
#include <xc.h>
#include <dsp.h>
#include "uart.h"
#include "string.h"
#include <libpic30.h>

/********************* UART Functions ****************************************/
void UARTInit(void)
{
// MCP802x Validation Board.  DE2 communications via RP7 (RX) and RP9 (TX)

 /* select the UART for all stdin and stdout read() and write() functions */
__C30_UART=1;

  // _TRISB9 = 0;  // WT32 CTS output
  // _LATB9 = 0;   // WT32 CTS set to 0
  // _TRISB8 = 1;  // WT32 RTS floating
  // _TRISB9 = '1';
  _RP41R = 1;      //RPOR3.RP41R<5:0> Set RP41 to Tx (0x01) (RB9, pin 1)
//  _U1CTSR = 0x1F;  // Set /CTS to VSS
  _U1RXR = 39;     // RPINR18 Set Rx on RP39 (RB7, pin 43)

  /*  U1MODE: UART1 Mode Register Bit Selections */
  U1MODEbits.USIDL = 0;     // Bit 13 Continue module operation in Idle mode
  U1MODEbits.IREN = 0;      // Bit 12 IrDA encoder and decoder disabled
  U1MODEbits.RTSMD = 0;     // Bit 11 UxRTS pin in Flow Control mode
  U1MODEbits.UEN = 0b00;    // Bit 9-8 UxTX and UxRX pins are enabled and used; UxCTS and UxRTS/UxBCLK pins controlled by port latches
  U1MODEbits.WAKE = 1;      // Bit 7 Wake-up enabled
  U1MODEbits.LPBACK = 0;    // Bit 6 Loopback mode is disabled
  U1MODEbits.ABAUD = 0;     // Bit 5 Auto Baud rate measurement disabled or completed
  U1MODEbits.URXINV = 0;    // Bit 4 UxRX Receive Polarity Inversion Bit, UxRX Idle State is a '1'
  U1MODEbits.BRGH = 0;      // Bit 3 High Baud Rate Enable, BRG generates 16 clocks per bit period (16x baud clock, Standard mode)
  U1MODEbits.PDSEL = 0b00;  // Bit 2-1 Parity and Data Selection, 8-bit data, no parity
  U1MODEbits.STSEL = 0;     // Bit 0 One Stop bit
  /*  End U1MODE: UART1 Mode Register Bit Selections */

  /* calculate BAUD Rate
   * Fcy = Fosc/2
   * U1BRG = (Fcy/(16 * Baud Rate)) - 1
   */
  U1BRG = ((FCY / ( 16 * BAUD_RATE_UL)) -1);

  /* Enable the UART */
  U1MODEbits.UARTEN = 1; // bit 15 enable UART

  _UTXBRK = 0; // Sync Break transmission disabled or completed
  _UTXEN = 1; // Transmit enabled, UxTX pin controlled by UARTx
  //27 sept. Commented interrupt activation, if removed, ISR definition is mandatory
  //_URXISEL = 0; // RX interrut mode : interrupt at each reiceived char
  //_U1RXIE = 1; // enable RX interrupt
  //_U1RXIP = 6; // Priority 6
  //AD1PCFGbits.PCFG4 = 1; // disable ADC input on RX pin (datasheet error)
  _OERR = 0; // clear RX overflow flag

__delay_us(5);

}

void writeUART1(char data)
{
  while(_UTXBF);
  while(!_TRMT);
  U1TXREG = data;
}

void sendstr(char *str)
{
  int i;
  for(i=0; i<strlen(str); i++)
  {
    if (str[i] !=  0x00)
    {
      writeUART1(str[i]);
    }
  }
}

#if (DE2_SERIAL_RECEIVE == ENABLED)
  void ClearCommunicationsPort(void)
  {
    U1STAbits.OERR = 0; /* reset error flag and clear buffer */
  }

  char readUART1(unsigned char *temp)
  {
    char rc = 0;  /* assume no character is available */

    if (U1STAbits.FERR)
    {
      /* Framing error - trash bad character */
    }
    else
    {
      if (U1STAbits.PERR)
      {
        /* Parity error - trash bad character */
      }
      else
      {
        if (U1STAbits.URXDA)
        {
          /* buffer not empty */
          /* return character available flag */
          /* always read the character from the FIFO */
          *temp = U1RXREG;
          rc = 1;
        }

        if (!U1STAbits.URXDA)
        {
          /* no more data in buffer, see if we had an overrun previously */
          if (U1STAbits.OERR)      /* check for FIFO Overrun errors */
          {
            /* FIFO overrun, last (5th) character was lost, buffer is now empty */
            U1STAbits.OERR = 0; /* reset error flag and clear buffer */
          }
        }
      } // if (_PERR)
    } // if (_FERR)
    return rc;
  }
#endif
