;***** VARIABLE DEFINITIONS
		; ***********************************************************************			
		; * Register definitions						*
		; ***********************************************************************
		cblock
			TEMP1, TEMP2	; temporary registers
			RXTX_REG	; receive register
			MESSAGE_COUNTER	; Countes number of bytes to receive or transmit
			ID_TEMP		; Register for ID byte
			TEMP_TRANSFER	; Data transfer register
			Error_Byte	; holds the accumulated error of the current frame
			DATAPOINTER:10	; address of data byte buffer
		endc
		; ***********************************************************************
		; * Other definitions							*
		; ***********************************************************************
		#define RXMODE		0		; Receive mode
		#define TXMODE		1		; Transmit mode
		#define CRC_ERROR	4		; CRC_ERROR occured
		#define CRC_OK		0		; No CRC_ERROR occured
		#define PARITY_OK	0		; No Parity error occcured
		#define PARITY_ERROR_P0	1		; Parity error on P0 occured
		#define PARITY_ERROR_P1 2		; Parity error on P1 occured
		
	#define ReceiveData	0x80
	#define TransmitData	0x40

; ***********************************************************************************************
; Function ID bit definitions
;   7 6 5 4 3 2 1 0
;   | | |_________|___ Identifier
;   |_|_______________ Parity bits
;
; First Data Byte
;   7 6 5 4 3 2 1 0
;   |_____________|___ Operation Code
;
; ***********************************************************************************************


