// 99cpu interface.cpp
// Program the AT24C01 EEPROM

#include <iostream>
#include <conio.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys\types.h>
void write_eeprom();
#include <sys\stat.h>
void change_data();
void save_data();
void read_custom_file();
void read_eeprom();
void verify_eeprom();
void program_default();
void delay();
using namespace std;

#define SDA	0x378	//x--- ---- pin 9 (_output)
#define SCL 0x37a	//---- -x-- pin 16 (_output)
#define ACK 0x379	//-x-- ---- pin 10 (input) pin 2 and pin 10 connected by a diode 
FILE *gold_file;

unsigned char gold_data[128];
unsigned char compare[128];
int i;
unsigned char c; 
char space_bar;
char choice;
int address;
unsigned long a;
unsigned char verify;
int main()


{
	if ((gold_file = fopen("99.dat", "rb")) == NULL)
	{
			printf("file open failed. \n");
			exit (0);
	}
	
	printf("                       MICREL/KENDIN OPERATION\n");
	printf("                       Sunnyvale, California\n");  

	printf("                        KS8999 CPU INTERFACE\n\n");
	printf("Connect a DB25 cable from parallel printer port to KS8999 demo board.\n");
	printf("Set printer port to NORMAL mode.\n\n\n");
	printf("Push ENTER to continue.\n");
	scanf("%c", &space_bar);
	printf("Contents of default data:\n");
	printf(" #  data #  data #  data #  data #  data #  data #  data #  data #  data #  data\n");
	for (i=-1; i<128;i++)
	{
		gold_data[i]=c;
		c=fgetc(gold_file);
	if (i == -1)
		{}
	else
	printf("%3d %3x ", i,gold_data[i]);
	}
	fclose(gold_file);
	start: printf("\n");
	printf("\nEnter Option:\n");
	printf("1. Write KS8999 REGISTERS\n");
	printf("2. Change buffer data\n");
	printf("3. Save buffer to file (Enter file name)\n");
	printf("4. Read custom file\n");
	printf("5. Program default values\n");
	printf("6. Exit\n");
	
	scanf("%d",&choice);
	switch(choice)

	{
	case 1: write_eeprom();
			goto start;
	case 2: change_data();
			goto start;
	case 3: save_data();
			goto start;
	case 4: read_custom_file();
			goto start;

	case 5: program_default();
			goto start;
	case 6: exit(0);

	default: 
	
	exit (0);
	}
}

//-----------------------------------------------------------------------------------------
void write_eeprom()


{
	_outp(SCL, 0x04);delay();	
printf("Press RESET button on board.\n");
	

	unsigned char data= gold_data[0];
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x04);delay();		

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	
	
	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	data<<=1;	 
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	for ( address=1; address<54; address++)
	{


	unsigned char data= gold_data[address];
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();		

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	
	
	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	data<<=1;	 
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();	

	}
		
		

}
//-----------------------------------------------------------------------------------------
void change_data()

{

	printf("Contents of default data:\n");
	printf(" #  data #  data #  data #  data #  data #  data #  data #  data #  data #  data\n");
	for (int i=0; i<128;i++)
	{

	printf("%3d %3x ", i,gold_data[i]);

	}
	again: printf("\nEnter the address location you want to change. (0 to 127)\n");
	int location; 
	cin >> location;

	printf("Enter the byte in HEX format.\n");
	unsigned char value;

	scanf("%x",&value);

	gold_data[location]=value;
	printf("Done (y/n)?\n");

	char done;
	cin >> done;
	if (done == 'y');
	else {goto again;}
	printf(" #  data #  data #  data #  data #  data #  data #  data #  data #  data #  data\n");
	for (i=0; i<128;i++)
	{

	printf("%3d %3x ", i,gold_data[i]);

	}

	printf("\n");
}
//-----------------------------------------------------------------------------------------
void save_data()

{

	int handle;										// open file for write operation.
	char filename[80];
	printf("Enter the name of file to save.\n");
	cin >> filename;
	if (( handle= open(filename, O_CREAT|O_BINARY|O_RDWR, S_IREAD|S_IWRITE)) == -1)

	{
		printf("Open failed\n");
	}

	write(handle,gold_data,128);
	
}
//-----------------------------------------------------------------------------------------
void read_custom_file()

{
	int handle;										// open file for read operation.
	char filename[80];
	printf("Enter the name of file to read.\n");
	cin >> filename;
	if (( handle= open(filename, O_CREAT|O_BINARY|O_RDWR, S_IREAD|S_IWRITE)) == -1)

	{
		printf("Open failed\n");
	}

	read(handle,gold_data,128);
	printf(" #  data #  data #  data #  data #  data #  data #  data #  data #  data #  data\n");
	for (i=0; i<128;i++)
	{

	printf("%3d %3x ", i,gold_data[i]);

	}	
}
//-----------------------------------------------------------------------------------------
void read_eeprom()

{
	
	unsigned char indata=0;	//input data buffer
	unsigned char data=0;
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//start condition        
	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();		//write control byte '1010 000 0'
	_outp(SCL, 0x04);delay();		//'1'
	_outp(SCL, 0x00);delay();	
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x80);delay();		//'1'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x00);delay();		//'0' write condition
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();		
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	


	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	


	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
	

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	
	_outp(SCL, 0x04);delay();

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//start condition        
	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();		//write control byte '1010 000 1'
	_outp(SCL, 0x04);delay();		//'1'
	_outp(SCL, 0x00);delay();	
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x80);delay();		//'1'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();		//'1' read condition
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	

	for ( address=0; address<129; address++)
	{
    _outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);

	indata<<=1;	
	indata >>= 7;			// clear up unwanted bits
	indata <<=7;
	data=0x00;
	data = data | indata;

   
	_outp(SCL, 0x00);delay();
    _outp(SCL, 0x04);delay();
	indata=_inp(ACK);
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=6;
	data = data | indata;	


	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();	//read data
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=5;
	data = data | indata;	

	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();		//read data
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=4;
	data=data | indata;
	
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();		//read data
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=3;
	data=data | indata;

	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();		//read data
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=2;
	data=data | indata;

	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();		//read data
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=1;
	data=data | indata;

	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();		//read data

	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	data=data | indata;	

	_outp(SCL, 0x00);delay();
	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();		//acknowledge from CPU
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	_outp(SDA, 0x80);delay();

	gold_data[address]=data;


	}

	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x04);delay();		//stop condition, end of sequential read
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x00);delay();
	_outp(SDA, 0x00);delay();

	printf(" #  data #  data #  data #  data #  data #  data #  data #  data #  data #  data\n");
	for (i=0; i<128;i++)
		{

		printf("%3d %3x ", i,gold_data[i]);

		}	

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();
}
//-----------------------------------------------------------------------------------------
void verify_eeprom()

{
	
	unsigned char indata=0;	//input data buffer
	unsigned char data=0;
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//start condition        
	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();		//write control byte '1010 000 0'
	_outp(SCL, 0x04);delay();		//'1'
	_outp(SCL, 0x00);delay();	
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x80);delay();		//'1'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x00);delay();		//'0' write condition
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();		
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	


	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	


	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
	

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	
	_outp(SCL, 0x04);delay();

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//start condition        
	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();		//write control byte '1010 000 1'
	_outp(SCL, 0x04);delay();		//'1'
	_outp(SCL, 0x00);delay();	
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x80);delay();		//'1'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();		//'1' read condition
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	

	for ( unsigned char x=0; x<129; x++)
	{
    _outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);

	indata<<=1;	
	indata >>= 7;			// clear up unwanted bits
	indata <<=7;
	data=0x00;
	data = data | indata;

   
	_outp(SCL, 0x00);delay();
    _outp(SCL, 0x04);delay();
	indata=_inp(ACK);
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=6;
	data = data | indata;	


	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();	//read data
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=5;
	data = data | indata;	

	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();		//read data
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=4;
	data=data | indata;
	
	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();		//read data
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=3;
	data=data | indata;

	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();		//read data
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=2;
	data=data | indata;

	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();		//read data
	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	indata <<=1;
	data=data | indata;

	_outp(SCL, 0x00);delay();
	_outp(SCL, 0x04);delay();
	indata=_inp(ACK);delay();		//read data

	indata <<=1;			//clear up unwanted bits
	indata >>=7;
	data=data | indata;	

	_outp(SCL, 0x00);delay();
	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();		//acknowledge from CPU
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	_outp(SDA, 0x80);delay();

	compare[x]=data;

	}

	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x04);delay();		//stop condition, end of sequential read
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x00);delay();
	_outp(SDA, 0x00);delay();


	for (i=0; i<128;i++)
		{

		if (gold_data[i] != compare[i])

			{ 
				printf(" ERROR: ADDRESS   WRITE DATA   READ DATA\n");
				printf("          %d         %x            %x   \n", i, gold_data[i], compare[i]);
				break;
			}
		else
			printf("Verify O.K.\n");
		}	

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();
}
//-----------------------------------------------------------------------------------------
void program_default()

{
	int handle;										// open file for read operation.
	char filename[80];

	//printf("Enter the name of file to read.\n");
	//cin >> filename;
	//filename = "goldfile.dat";
	if (( handle= open("99.dat", O_CREAT|O_BINARY|O_RDWR, S_IREAD|S_IWRITE)) == -1)

	{
		printf("Open failed\n");
	}

	read(handle,gold_data,128);
	printf(" #  data #  data #  data #  data #  data #  data #  data #  data #  data #  data\n");
	for (i=0; i<128;i++)
	{

	printf("%3d %3x ", i,gold_data[i]);

	}	

	write_eeprom();
}





//-----------------------------------------------------------------------------------------
void delay()

{
	for (a=0; a<100; a++)
	{}
	
}